/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.core.util;

import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.StringBufferOutputStream;
import com.liferay.ide.core.util.CoreUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

public class FileUtil {
    public static void clearContents(File versionFile) {
        if (versionFile != null && versionFile.exists()) {
            try {
                RandomAccessFile file = new RandomAccessFile(versionFile, "rw");
                file.setLength(0L);
                file.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void copyFileToIFolder(File file, IFolder folder, IProgressMonitor monitor) throws CoreException {
        IFile iFile = folder.getFile(file.getName());
        try {
            FileInputStream input = new FileInputStream(file);
            if (iFile.exists()) {
                iFile.setContents((InputStream)input, true, true, monitor);
            } else {
                iFile.create((InputStream)input, true, monitor);
            }
            input.close();
        }
        catch (Exception e) {
            throw new CoreException(LiferayCore.createErrorStatus("Could not copy file to folder " + file.getName(), e));
        }
    }

    public static void copyFile(File src, File dest) {
        if (src == null || !src.exists() || dest == null || dest.isDirectory()) {
            return;
        }
        byte[] buf = new byte[4096];
        FileOutputStream out = null;
        FileInputStream in = null;
        try {
            try {
                out = new FileOutputStream(dest);
                in = new FileInputStream(src);
                int avail = in.read(buf);
                while (avail > 0) {
                    ((OutputStream)out).write(buf, 0, avail);
                    avail = in.read(buf);
                }
            }
            catch (Exception e) {
                LiferayCore.logError("Unable to copy file " + src.getName() + " to " + dest.getAbsolutePath(), e);
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void copyFileToDir(File src, File dir) {
        FileUtil.copyFileToDir(src, src.getName(), dir);
    }

    public static void copyFileToDir(File src, String newName, File dir) {
        FileUtil.copyFile(src, new File(dir, newName));
    }

    public static void deleteDir(File directory, boolean removeAll) {
        if (directory == null || !directory.isDirectory()) {
            return;
        }
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory() && removeAll) {
                FileUtil.deleteDir(file, removeAll);
            } else {
                file.delete();
            }
            ++n2;
        }
        directory.delete();
    }

    public static void deleteDirContents(File directory) {
        if (directory == null || !directory.isDirectory()) {
            return;
        }
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FileUtil.deleteDir(file, true);
            } else {
                file.delete();
            }
            ++n2;
        }
    }

    public static File[] getDirectories(File directory) {
        return directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
    }

    public static IContainer getWorkspaceContainer(File f) {
        Path path;
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wsroot = ws.getRoot();
        IContainer[] wsContainers = wsroot.findContainersForLocationURI((path = new Path(f.getAbsolutePath())).toFile().toURI());
        if (wsContainers.length > 0) {
            return wsContainers[0];
        }
        return null;
    }

    public static IFile getWorkspaceFile(File f, String expectedProjectName) {
        Path path;
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wsroot = ws.getRoot();
        IFile[] wsFiles = wsroot.findFilesForLocationURI((path = new Path(f.getAbsolutePath())).toFile().toURI());
        if (wsFiles.length > 0) {
            IFile[] iFileArray = wsFiles;
            int n = wsFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IFile wsFile = iFileArray[n2];
                if (wsFile.getProject().getName().equals(expectedProjectName)) {
                    return wsFile;
                }
                ++n2;
            }
        }
        return null;
    }

    public static void mkdirs(File f) throws CoreException {
        if (f.exists()) {
            if (f.isFile()) {
                String msg = NLS.bind((String)Msgs.locationIsFile, (Object)f.getAbsolutePath());
                throw new CoreException(LiferayCore.createErrorStatus(msg));
            }
        } else {
            FileUtil.mkdirs(f.getParentFile());
            IContainer wsContainer = FileUtil.getWorkspaceContainer(f);
            if (wsContainer != null) {
                IFolder iFolder = (IFolder)wsContainer;
                iFolder.create(true, true, null);
            } else {
                boolean isSuccessful = f.mkdir();
                if (!isSuccessful) {
                    String msg = NLS.bind((String)Msgs.failedToCreateDirectory, (Object)f.getAbsolutePath());
                    throw new CoreException(LiferayCore.createErrorStatus(msg));
                }
            }
        }
    }

    public static String readContents(File file) {
        return FileUtil.readContents(file, false);
    }

    public static String readContents(File file, boolean includeNewlines) {
        StringBuffer contents;
        block17: {
            if (file == null) {
                return null;
            }
            if (!file.exists()) {
                return null;
            }
            contents = new StringBuffer();
            BufferedReader bufferedReader = null;
            try {
                try {
                    String line;
                    FileReader fileReader = new FileReader(file);
                    bufferedReader = new BufferedReader(fileReader);
                    while ((line = bufferedReader.readLine()) != null) {
                        contents.append(line);
                        if (!includeNewlines) continue;
                        contents.append(System.getProperty("line.separator"));
                    }
                }
                catch (Exception e) {
                    LiferayCore.logError("Could not read file: " + file.getPath());
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return contents.toString();
    }

    public static String readContents(InputStream contents) throws IOException {
        byte[] buffer = new byte[4096];
        BufferedInputStream bin = new BufferedInputStream(contents);
        StringBufferOutputStream out = new StringBufferOutputStream();
        int bytesRead = 0;
        while ((bytesRead = bin.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        if (bin != null) {
            bin.close();
        }
        if (out != null) {
            out.flush();
            out.close();
        }
        return out.toString();
    }

    public static String[] readLinesFromFile(File file) {
        return FileUtil.readLinesFromFile(file, false);
    }

    public static String[] readLinesFromFile(File file, boolean includeNewlines) {
        ArrayList<String> lines;
        block18: {
            if (file == null) {
                return null;
            }
            if (!file.exists()) {
                return null;
            }
            lines = new ArrayList<String>();
            BufferedReader bufferedReader = null;
            try {
                try {
                    String line;
                    FileReader fileReader = new FileReader(file);
                    bufferedReader = new BufferedReader(fileReader);
                    while ((line = bufferedReader.readLine()) != null) {
                        StringBuffer contents = new StringBuffer(line);
                        if (includeNewlines) {
                            contents.append(System.getProperty("line.separator"));
                        }
                        lines.add(contents.toString());
                    }
                }
                catch (Exception e) {
                    LiferayCore.logError("Could not read file: " + file.getPath());
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return lines.toArray(new String[lines.size()]);
    }

    public static Document readXML(InputStream inputStream, EntityResolver resolver, ErrorHandler error) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (resolver != null) {
                db.setEntityResolver(resolver);
            }
            if (error != null) {
                db.setErrorHandler(error);
            }
            return db.parse(inputStream);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Document readXML(String content) {
        return FileUtil.readXML(new ByteArrayInputStream(content.getBytes()), null, null);
    }

    public static Document readXMLFile(File file) {
        return FileUtil.readXMLFile(file, null);
    }

    public static Document readXMLFile(File file, EntityResolver resolver) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (resolver != null) {
                db.setEntityResolver(resolver);
            }
            return db.parse(file);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static boolean searchAndReplace(File file, String search, String replace) throws FileNotFoundException, IOException {
        boolean replaced = false;
        if (file.exists()) {
            String replaceContents;
            String searchContents = CoreUtil.readStreamToString(new FileInputStream(file));
            replaced = !searchContents.equals(replaceContents = searchContents.replaceAll(search, replace));
            CoreUtil.writeStreamFromString(replaceContents, new FileOutputStream(file));
        }
        return replaced;
    }

    public static void validateEdit(IFile ... files) throws CoreException {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IStatus st = ws.validateEdit(files, IWorkspace.VALIDATE_PROMPT);
        if (st.getSeverity() == 4) {
            throw new CoreException(st);
        }
    }

    public static String validateNewFolder(IFolder folder, String folderValue) {
        if (folder == null || folderValue == null) {
            return null;
        }
        if (CoreUtil.isNullOrEmpty(folderValue)) {
            return Msgs.folderValueNotEmpty;
        }
        if (!Path.ROOT.isValidPath(folderValue)) {
            return Msgs.folderValueInvalid;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validatePath(folder.getFolder(folderValue).getFullPath().toString(), 2);
        if (!result.isOK()) {
            return result.getMessage();
        }
        if (folder.getFolder((IPath)new Path(folderValue)).exists()) {
            return Msgs.folderAlreadyExists;
        }
        return null;
    }

    public static void writeFile(File f, byte[] contents, String expectedProjectName) throws CoreException {
        FileUtil.writeFile(f, new ByteArrayInputStream(contents), expectedProjectName);
    }

    public static void writeFile(File f, InputStream contents) throws CoreException {
        FileUtil.writeFile(f, contents, null);
    }

    public static void writeFile(File f, InputStream contents, String expectedProjectName) throws CoreException {
        IFile wsfile;
        if (f.exists()) {
            if (f.isDirectory()) {
                String msg = NLS.bind((String)Msgs.locationIsDirectory, (Object)f.getAbsolutePath());
                throw new CoreException(LiferayCore.createErrorStatus(msg));
            }
        } else {
            FileUtil.mkdirs(f.getParentFile());
        }
        if ((wsfile = FileUtil.getWorkspaceFile(f, expectedProjectName)) != null) {
            FileUtil.validateEdit(wsfile);
            if (wsfile.exists()) {
                wsfile.setContents(contents, true, false, null);
            } else {
                wsfile.create(contents, true, null);
            }
        } else {
            if (f.exists() && !f.canWrite()) {
                String msg = NLS.bind((String)Msgs.cannotWriteFile, (Object)f.getAbsolutePath());
                throw new CoreException(LiferayCore.createErrorStatus(msg));
            }
            byte[] buffer = new byte[1024];
            FileOutputStream out = null;
            try {
                try {
                    int count;
                    out = new FileOutputStream(f);
                    while ((count = contents.read(buffer)) != -1) {
                        out.write(buffer, 0, count);
                    }
                    out.flush();
                }
                catch (IOException e) {
                    String msg = NLS.bind((String)Msgs.failedWhileWriting, (Object)f.getAbsolutePath());
                    throw new CoreException(LiferayCore.createErrorStatus(msg, e));
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void writeFile(File f, String contents, String expectedProjectName) throws CoreException {
        try {
            FileUtil.writeFile(f, contents.getBytes("UTF-8"), expectedProjectName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static int writeFileFromStream(File tempFile, InputStream in) throws IOException {
        byte[] buffer = new byte[1024];
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile));
        BufferedInputStream bin = new BufferedInputStream(in);
        int bytesRead = 0;
        int bytesTotal = 0;
        while ((bytesRead = bin.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            bytesTotal += bytesRead;
        }
        if (bin != null) {
            bin.close();
        }
        if (out != null) {
            out.flush();
            out.close();
        }
        return bytesTotal;
    }

    public static String writeXml(Document document) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(writer));
        return writer.getBuffer().toString();
    }

    private static class Msgs
    extends NLS {
        public static String cannotWriteFile;
        public static String failedToCreateDirectory;
        public static String failedWhileWriting;
        public static String folderAlreadyExists;
        public static String folderValueInvalid;
        public static String folderValueNotEmpty;
        public static String locationIsDirectory;
        public static String locationIsFile;

        static {
            Msgs.initializeMessages((String)FileUtil.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

