/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.hyperlink;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.core.util.DOMUtils;
import org.eclipse.wst.xml.search.editor.hyperlink.HyperlinkUtils;
import org.eclipse.wst.xml.search.editor.references.IXMLReference;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceToExpression;
import org.eclipse.wst.xml.search.editor.references.XMLReferencesUtil;
import org.eclipse.wst.xml.search.editor.searchers.IXMLSearcher;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLReferencesHyperlinkDetector
extends AbstractHyperlinkDetector {
    public static final IHyperlink[] EMPTY_HYPERLINK = null;

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || textViewer == null) {
            return EMPTY_HYPERLINK;
        }
        IDocument document = textViewer.getDocument();
        IDOMNode currentNode = DOMUtils.getNodeByOffset((IDocument)document, (int)region.getOffset());
        if (currentNode == null) {
            return EMPTY_HYPERLINK;
        }
        short nodeType = currentNode.getNodeType();
        switch (nodeType) {
            case 1: {
                return this.detectHyperlinks((Element)currentNode, textViewer, region, canShowMultipleHyperlinks);
            }
            case 3: {
                return this.detectHyperlinks((Text)currentNode, textViewer, region, canShowMultipleHyperlinks);
            }
        }
        return EMPTY_HYPERLINK;
    }

    private IHyperlink[] detectHyperlinks(Element element, ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IDOMAttr attr = DOMUtils.getAttrByOffset((Node)element, (int)region.getOffset());
        if (attr == null) {
            return EMPTY_HYPERLINK;
        }
        return this.detectHyperlinks((IDOMNode)attr, textViewer, region, canShowMultipleHyperlinks);
    }

    private IHyperlink[] detectHyperlinks(Text text, ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        return this.detectHyperlinks((IDOMNode)text, textViewer, region, canShowMultipleHyperlinks);
    }

    private IHyperlink[] detectHyperlinks(IDOMNode selectedNode, ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IXMLReference reference = XMLReferencesUtil.getXMLReference((Node)selectedNode, selectedNode.getModel().getContentTypeIdentifier());
        if (reference == null) {
            return EMPTY_HYPERLINK;
        }
        IFile file = DOMUtils.getFile((IDOMNode)selectedNode);
        IRegion hyperlinkRegion = HyperlinkUtils.getHyperlinkRegion((Node)selectedNode);
        int offset = region.getOffset() - hyperlinkRegion.getOffset();
        ArrayList<IHyperlink> hyperLinks = new ArrayList<IHyperlink>();
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (reference.isExpression()) {
            IXMLReferenceToExpression expression = (IXMLReferenceToExpression)reference;
            IXMLSearcher searcher = expression.getSearcher();
            if (searcher != null) {
                searcher.searchForHyperlink(selectedNode, offset, DOMUtils.getNodeValue((Node)selectedNode), -1, -1, file, expression, hyperlinkRegion, hyperLinks, textEditor);
            }
        } else {
            List<IXMLReferenceTo> toPath = reference.getTo();
            for (IXMLReferenceTo referenceTo : toPath) {
                IXMLSearcher searcher = referenceTo.getSearcher();
                if (searcher == null) continue;
                searcher.searchForHyperlink(selectedNode, offset, DOMUtils.getNodeValue((Node)selectedNode), -1, -1, file, referenceTo, hyperlinkRegion, hyperLinks, textEditor);
            }
        }
        if (hyperLinks.size() == 0) {
            return EMPTY_HYPERLINK;
        }
        return hyperLinks.toArray(new IHyperlink[hyperLinks.size()]);
    }
}

