/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.core.queryspecifications.IXMLQuerySpecification;
import org.eclipse.wst.xml.search.core.queryspecifications.IXMLQuerySpecificationRegistry;
import org.eclipse.wst.xml.search.core.queryspecifications.XMLQuerySpecificationRegistry;
import org.eclipse.wst.xml.search.core.reporter.IXMLSearchReporter;
import org.eclipse.wst.xml.search.editor.internal.Messages;
import org.eclipse.wst.xml.search.editor.internal.XMLSearchEditorPlugin;
import org.eclipse.wst.xml.search.editor.internal.reporter.XMLSearchReporterManager;
import org.eclipse.wst.xml.search.editor.internal.util.ExceptionHandler;
import org.eclipse.wst.xml.search.editor.references.IXMLReferencePath;
import org.eclipse.wst.xml.search.editor.references.XMLReferencePathResult;
import org.eclipse.wst.xml.search.editor.references.XMLReferencesUtil;
import org.eclipse.wst.xml.search.editor.util.XMLQuerySpecificationUtil;
import org.eclipse.wst.xml.search.ui.internal.participant.SearchParticipantDescriptor;
import org.eclipse.wst.xml.search.ui.internal.participant.SearchParticipantsExtensionPoint;
import org.eclipse.wst.xml.search.ui.util.DOMUtils;
import org.eclipse.wst.xml.search.ui.util.SearchUtil;
import org.w3c.dom.Node;

public class ReferencesInContainerHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ITextEditor textEditor = SearchUtil.getTextEditor((ExecutionEvent)event);
        if (textEditor == null) {
            this.showOperationUnavailableDialog(XMLSearchEditorPlugin.getActiveWorkbenchShell(), Messages.ReferencesInContainerHandler_operationUnavailable_textEditorUnavailable);
            return null;
        }
        Shell shell = textEditor.getSite().getShell();
        IFile file = SearchUtil.getFile((IEditorPart)textEditor);
        if (file == null) {
            this.showOperationUnavailableDialog(XMLSearchEditorPlugin.getActiveWorkbenchShell(), Messages.ReferencesInContainerHandler_operationUnavailable_fileUnavailable);
            return null;
        }
        IDOMNode selectedNode = DOMUtils.getSelectedNode((ITextEditor)textEditor);
        if (selectedNode == null) {
            this.showOperationUnavailableDialog(XMLSearchEditorPlugin.getActiveWorkbenchShell(), Messages.ReferencesInContainerHandler_operationUnavailable_domNodeUnavailable);
            return null;
        }
        XMLReferencePathResult result = XMLReferencesUtil.getReferencePath((Node)selectedNode, file);
        SearchParticipantDescriptor[] participantDescriptors = SearchParticipantsExtensionPoint.getInstance().getSearchParticipants((Object)selectedNode);
        if (result == null && (participantDescriptors == null || participantDescriptors.length < 1)) {
            this.showOperationUnavailableDialog(XMLSearchEditorPlugin.getActiveWorkbenchShell(), Messages.ReferencesInContainerHandler_operationUnavailable_noReferencesDefined);
            return null;
        }
        XMLQuerySpecificationRegistry querySpecificationRegistry = new XMLQuerySpecificationRegistry((IResource)file, (Object)selectedNode);
        if (result != null) {
            for (IXMLReferencePath referencePath : result) {
                String query;
                IXMLQuerySpecification querySpecification = XMLQuerySpecificationUtil.getQuerySpecification(referencePath);
                if (querySpecification == null || (query = referencePath.getQuery(selectedNode, null, querySpecification.getEqualsStringQueryBuilder(), result.isReversed())) == null) continue;
                querySpecificationRegistry.register(querySpecification, query, null);
            }
        }
        try {
            SearchUtil.performNewSearch((Shell)shell, (IXMLQuerySpecificationRegistry)querySpecificationRegistry, (SearchParticipantDescriptor[])participantDescriptors, (IXMLSearchReporter)XMLSearchReporterManager.getDefault());
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CoreException ex) {
            ExceptionHandler.handle(ex, shell, Messages.Search_Error_search_notsuccessful_title, Messages.Search_Error_search_notsuccessful_message);
        }
        return null;
    }

    private void showOperationUnavailableDialog(Shell shell, String message) {
        MessageDialog.openInformation((Shell)shell, (String)Messages.ReferencesInContainerHandler_operationUnavailable_title, (String)message);
    }
}

