/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.searchers.xml;

import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.core.IXMLSearchDOMNodeCollector;
import org.eclipse.wst.xml.search.core.util.DOMUtils;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.eclipse.wst.xml.search.editor.contentassist.IContentAssistAdditionalProposalInfoProvider;
import org.eclipse.wst.xml.search.editor.contentassist.IContentAssistProposalRecorder;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceToXML;
import org.eclipse.wst.xml.search.editor.searchers.AbstractContentAssisitCollector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ContentAssisitCollectorForXML
extends AbstractContentAssisitCollector<IXMLReferenceToXML>
implements IXMLSearchDOMNodeCollector {
    public ContentAssisitCollectorForXML(String forceBeforeText, String forceEndText, IXMLReferenceToXML referencePath, IContentAssistProposalRecorder recorder) {
        super(forceBeforeText, forceEndText, referencePath, recorder);
    }

    public boolean add(IDOMNode node) {
        this.collect(this.recorder, node, (IXMLReferenceToXML)this.referencePath);
        return true;
    }

    private void collect(IContentAssistProposalRecorder recorder, IDOMNode node, IXMLReferenceToXML referencePath) {
        String value = null;
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 2: {
                value = ((Attr)node).getValue();
                break;
            }
            case 3: {
                value = DOMUtils.getTextContent((Text)((Text)node));
                break;
            }
            case 1: {
                String targetNode = referencePath.getTargetNodes()[0];
                if (targetNode.startsWith("@")) {
                    String attrValue;
                    String attrName = targetNode.substring(1, targetNode.length());
                    value = attrValue = ((Element)node).getAttribute(attrName);
                    break;
                }
                Element element = (Element)node;
                Node firstChild = element.getFirstChild();
                if (firstChild == null || firstChild.getNodeType() != 3) break;
                value = DOMUtils.getTextContent((Text)((Text)firstChild));
            }
        }
        if (value == null) {
            return;
        }
        Image image = null;
        int relevance = 1000;
        String displayText = value;
        String replaceText = this.getReplaceText(value);
        String proposedObject = null;
        IContentAssistAdditionalProposalInfoProvider<?> provider = referencePath.getAdditionalProposalInfoProvider();
        if (provider != null) {
            String newDisplayText = provider.getDisplayText(displayText, node);
            if (!StringUtils.isEmpty((String)newDisplayText)) {
                displayText = newDisplayText;
            }
            image = provider.getImage(node);
            proposedObject = provider.getTextInfo(node);
        }
        recorder.recordProposal(image, relevance, displayText, replaceText, proposedObject);
    }
}

