/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.tycho.m2e.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.jdt.IClasspathEntryDescriptor;
import org.eclipse.m2e.jdt.internal.ClasspathEntryDescriptor;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.pde.core.IClasspathContributor;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.sonatype.tycho.m2e.internal.EmbeddedArtifacts;

public class PDEClasspathContributor
implements IClasspathContributor {
    private static final IMavenProjectRegistry mavenProjects = MavenPlugin.getMavenProjectRegistry();
    private static final IAccessRule EXCLUDE_ALL_RULE = JavaCore.newAccessRule((IPath)new Path("**/*"), (int)257);

    public List<IClasspathEntry> getInitialEntries(BundleDescription bundle) {
        return Collections.emptyList();
    }

    public List<IClasspathEntry> getEntriesForDependency(BundleDescription bundle, BundleDescription addedDependency) {
        IPluginModelBase model = PluginRegistry.findModel((BundleDescription)addedDependency);
        IProject project = this.getProject(model);
        if (project == null) {
            return Collections.emptyList();
        }
        IMavenProjectFacade facade = mavenProjects.getProject(project);
        if (facade == null) {
            return Collections.emptyList();
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return Collections.emptyList();
        }
        List<IAccessRule> accessRules = this.getAccessRules(bundle, addedDependency);
        Map<ArtifactKey, String> embeddedArtifacts = EmbeddedArtifacts.getEmbeddedArtifacts(project);
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        for (Map.Entry<ArtifactKey, IClasspathEntryDescriptor> entry : this.getMavenClasspath(javaProject).entrySet()) {
            if (!embeddedArtifacts.containsKey(entry.getKey())) continue;
            entries.add(this.newClasspathEntry(entry.getValue(), accessRules));
        }
        return entries;
    }

    private List<IAccessRule> getAccessRules(BundleDescription bundle, BundleDescription addedDependency) {
        Map<BundleDescription, ArrayList<Rule>> map = this.retrieveVisiblePackagesFromState(bundle);
        if (map != null) {
            return PDEClasspathContributor.getAccessRules((Collection<Rule>)map.get(addedDependency));
        }
        return null;
    }

    private IClasspathEntry newClasspathEntry(IClasspathEntryDescriptor prototype, Collection<IAccessRule> rules) {
        ClasspathEntryDescriptor entry = new ClasspathEntryDescriptor(prototype.getEntryKind(), prototype.getPath());
        entry.setArtifactKey(prototype.getArtifactKey());
        if (rules != null) {
            for (IAccessRule rule : rules) {
                entry.addAccessRule(rule);
            }
        }
        return entry.toClasspathEntry();
    }

    private Map<ArtifactKey, IClasspathEntryDescriptor> getMavenClasspath(IJavaProject javaProject) {
        try {
            IClasspathContainer container = JavaCore.getClasspathContainer((IPath)new Path("org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER"), (IJavaProject)javaProject);
            if (container != null) {
                LinkedHashMap<ArtifactKey, IClasspathEntryDescriptor> result = new LinkedHashMap<ArtifactKey, IClasspathEntryDescriptor>();
                IClasspathEntry[] iClasspathEntryArray = container.getClasspathEntries();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    ClasspathEntryDescriptor descriptor = new ClasspathEntryDescriptor(entry);
                    ArtifactKey key = descriptor.getArtifactKey();
                    if (key != null) {
                        result.put(key, (IClasspathEntryDescriptor)descriptor);
                    }
                    ++n2;
                }
                return result;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return Collections.emptyMap();
    }

    private IProject getProject(IPluginModelBase model) {
        IResource resource = model.getUnderlyingResource();
        if (resource == null) {
            return null;
        }
        return resource.getProject();
    }

    private Map<BundleDescription, ArrayList<Rule>> retrieveVisiblePackagesFromState(BundleDescription desc) {
        HashMap<BundleDescription, ArrayList<Rule>> visiblePackages = new HashMap<BundleDescription, ArrayList<Rule>>();
        StateHelper helper = Platform.getPlatformAdmin().getStateHelper();
        this.addVisiblePackagesFromState(helper, desc, visiblePackages);
        if (desc.getHost() != null) {
            this.addVisiblePackagesFromState(helper, (BundleDescription)desc.getHost().getSupplier(), visiblePackages);
        }
        return visiblePackages;
    }

    private void addVisiblePackagesFromState(StateHelper helper, BundleDescription desc, Map<BundleDescription, ArrayList<Rule>> visiblePackages) {
        if (desc == null) {
            return;
        }
        ExportPackageDescription[] exports = helper.getVisiblePackages(desc);
        int i = 0;
        while (i < exports.length) {
            BundleDescription exporter = exports[i].getExporter();
            if (exporter != null) {
                Rule rule;
                ArrayList<Rule> list = visiblePackages.get(exporter);
                if (list == null) {
                    list = new ArrayList();
                    visiblePackages.put(exporter, list);
                }
                if (!list.contains(rule = this.getRule(helper, desc, exports[i]))) {
                    list.add(rule);
                }
            }
            ++i;
        }
    }

    private Rule getRule(StateHelper helper, BundleDescription desc, ExportPackageDescription export) {
        Rule rule = new Rule();
        rule.discouraged = helper.getAccessCode(desc, export) == 2;
        String name = export.getName();
        rule.path = name.equals(".") ? new Path("*") : new Path(String.valueOf(name.replaceAll("\\.", "/")) + "/*");
        return rule;
    }

    protected static List<IAccessRule> getAccessRules(Collection<Rule> rules) {
        if (rules == null) {
            return null;
        }
        ArrayList<IAccessRule> accessRules = new ArrayList<IAccessRule>();
        for (Rule rule : rules) {
            accessRules.add(rule.discouraged ? PDEClasspathContributor.getDiscouragedRule(rule.path) : PDEClasspathContributor.getAccessibleRule(rule.path));
        }
        accessRules.add(EXCLUDE_ALL_RULE);
        return accessRules;
    }

    private static synchronized IAccessRule getAccessibleRule(IPath path) {
        return JavaCore.newAccessRule((IPath)path, (int)0);
    }

    private static synchronized IAccessRule getDiscouragedRule(IPath path) {
        return JavaCore.newAccessRule((IPath)path, (int)2);
    }

    public class Rule {
        IPath path;
        boolean discouraged;

        public boolean equals(Object other) {
            if (!(other instanceof Rule)) {
                return false;
            }
            return this.discouraged == ((Rule)other).discouraged && this.path.equals((Object)((Rule)other).path);
        }

        public String toString() {
            return this.discouraged ? String.valueOf(this.path.toString()) + " [discouraged]" : this.path.toString();
        }
    }
}

