/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.ui.internal;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.core.IXMLSearchDOMNodeCollector;
import org.eclipse.wst.xml.search.core.IXMLSearchEngine;
import org.eclipse.wst.xml.search.core.namespaces.Namespaces;
import org.eclipse.wst.xml.search.core.queryspecifications.IXMLQuerySpecificationRegistry;
import org.eclipse.wst.xml.search.core.queryspecifications.requestor.IXMLSearchRequestor;
import org.eclipse.wst.xml.search.core.queryspecifications.visitor.IXMLSearchDOMDocumentVisitor;
import org.eclipse.wst.xml.search.core.reporter.IXMLSearchReporter;
import org.eclipse.wst.xml.search.ui.XMLMatch;
import org.eclipse.wst.xml.search.ui.internal.Messages;
import org.eclipse.wst.xml.search.ui.internal.XMLSearchResult;
import org.eclipse.wst.xml.search.ui.internal.XMLSearchUIPlugin;
import org.eclipse.wst.xml.search.ui.internal.participant.SearchParticipantDescriptor;
import org.eclipse.wst.xml.search.ui.participant.IMatchPresentation;
import org.eclipse.wst.xml.search.ui.participant.IQueryParticipant;
import org.eclipse.wst.xml.search.ui.participant.ISearchRequestor;

public class XMLSearchQuery
implements ISearchQuery,
IXMLSearchDOMNodeCollector {
    private IContainer container;
    private IXMLSearchRequestor scope;
    private IXMLSearchDOMDocumentVisitor visitor;
    private String query;
    private String xpathEvaluatorId;
    private Namespaces namespaceInfos;
    private ISearchResult fResult;
    private IDOMNode selectedNode;
    private IXMLSearchEngine engine;
    private IXMLQuerySpecificationRegistry querySpecificationRegistry;
    private final SearchParticipantDescriptor[] participantDescriptors;
    private long startTime = 0L;
    private long endTime = 0L;
    private IXMLSearchReporter reporter;

    public XMLSearchQuery(IContainer container, IXMLSearchRequestor scope, IXMLSearchDOMDocumentVisitor visitor, String query, String xpathEvaluatorId, Namespaces namespaceInfos, IDOMNode selectedNode, IXMLSearchEngine engine, IXMLSearchReporter reporter) {
        this.container = container;
        this.scope = scope;
        this.visitor = visitor;
        this.query = query;
        this.namespaceInfos = namespaceInfos;
        this.xpathEvaluatorId = xpathEvaluatorId;
        this.selectedNode = selectedNode;
        this.engine = engine;
        this.reporter = reporter;
        this.participantDescriptors = null;
    }

    public XMLSearchQuery(IXMLQuerySpecificationRegistry querySpecificationRegistry, SearchParticipantDescriptor[] participantDescriptors, IXMLSearchEngine engine, IXMLSearchReporter reporter) {
        this.engine = engine;
        this.querySpecificationRegistry = querySpecificationRegistry;
        this.participantDescriptors = participantDescriptors;
        this.reporter = reporter;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public String getLabel() {
        return Messages.XMLSearchQuery_label;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getResultLabel(int nMatches) {
        long time = 0L;
        if (this.startTime > 0L) {
            time = this.endTime > 0L ? this.endTime - this.startTime : System.currentTimeMillis() - this.startTime;
        }
        if (this.querySpecificationRegistry != null) {
            String label = this.querySpecificationRegistry.getQueriesLabel();
            Object[] values = new Object[]{label, nMatches, time};
            return NLS.bind((String)Messages.XMLSearchQuery_xpathPattern, (Object[])values);
        }
        Object[] values = new Object[]{this.query, nMatches, time};
        return NLS.bind((String)Messages.XMLSearchQuery_xpathPattern, (Object[])values);
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            XMLSearchResult result = new XMLSearchResult(this);
            this.fResult = result;
        }
        return this.fResult;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.startTime = System.currentTimeMillis();
        XMLSearchResult xmlResult = (XMLSearchResult)this.getSearchResult();
        xmlResult.removeAll();
        if (this.querySpecificationRegistry != null) {
            int i;
            Object selectedNode = this.querySpecificationRegistry.getSelectedNode();
            if (this.participantDescriptors != null) {
                int[] ticks = new int[this.participantDescriptors.length];
                i = 0;
                while (i < this.participantDescriptors.length) {
                    int iPrime = i++;
                    ISafeRunnable runnable = new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                            ticks[iPrime] = 0;
                            String message = Messages.XMLSearchQuery_error_participant_estimate;
                            XMLSearchUIPlugin.log((IStatus)new Status(4, "org.eclipse.wst.xml.search.ui", 0, message, exception));
                        }

                        public void run() throws Exception {
                            ticks[iPrime] = 1;
                        }
                    };
                    SafeRunner.run((ISafeRunnable)runnable);
                }
            }
            IStatus status = this.engine.search(this.querySpecificationRegistry, (IXMLSearchDOMNodeCollector)this, this.reporter, monitor);
            if (this.participantDescriptors != null) {
                i = 0;
                while (i < this.participantDescriptors.length) {
                    SearchRequestor requestor = new SearchRequestor(this.participantDescriptors[i].getParticipant(), xmlResult);
                    SubProgressMonitor participantPM = new SubProgressMonitor(monitor, 1);
                    int iPrime = i++;
                    ISafeRunnable runnable = new ISafeRunnable((IProgressMonitor)participantPM){
                        private final /* synthetic */ IProgressMonitor val$participantPM;
                        {
                            this.val$participantPM = iProgressMonitor;
                        }

                        public void handleException(Throwable exception) {
                            XMLSearchQuery.this.participantDescriptors[iPrime].disable();
                            String message = Messages.XMLSearchQuery_error_participant_search;
                            XMLSearchUIPlugin.log((IStatus)new Status(4, "org.eclipse.wst.xml.search.ui", 0, message, exception));
                        }

                        public void run() throws Exception {
                            IQueryParticipant participant = XMLSearchQuery.this.participantDescriptors[iPrime].getParticipant();
                            participant.search(requestor, selectedNode, this.val$participantPM);
                        }
                    };
                    SafeRunner.run((ISafeRunnable)runnable);
                }
            }
            return status;
        }
        try {
            IStatus iStatus = this.engine.search((IResource)this.container, this.scope, this.visitor, this.query, this.xpathEvaluatorId, this.namespaceInfos, (IXMLSearchDOMNodeCollector)this, (Object)this.selectedNode, this.reporter, monitor);
            return iStatus;
        }
        finally {
            this.endTime = System.currentTimeMillis();
        }
    }

    public boolean add(IDOMNode node) {
        XMLSearchResult xmlResult = (XMLSearchResult)this.getSearchResult();
        xmlResult.addMatch(new XMLMatch(node));
        return true;
    }

    static /* synthetic */ SearchParticipantDescriptor[] access$0(XMLSearchQuery xMLSearchQuery) {
        return xMLSearchQuery.participantDescriptors;
    }

    private static class SearchRequestor
    implements ISearchRequestor {
        private IQueryParticipant fParticipant;
        private XMLSearchResult fSearchResult;

        @Override
        public void reportMatch(Match match) {
            IMatchPresentation participant = this.fParticipant.getUIParticipant();
            if (participant == null || match.getElement() instanceof IDOMNode || match.getElement() instanceof IResource) {
                this.fSearchResult.addMatch(match);
            } else {
                this.fSearchResult.addMatch(match, participant);
            }
        }

        protected SearchRequestor(IQueryParticipant participant, XMLSearchResult result) {
            this.fParticipant = participant;
            this.fSearchResult = result;
        }
    }
}

