/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.ui.internal.participant;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.xml.search.ui.internal.Messages;
import org.eclipse.wst.xml.search.ui.internal.XMLSearchUIPlugin;
import org.eclipse.wst.xml.search.ui.participant.IQueryParticipant;

public class SearchParticipantDescriptor {
    private static final String CLASS = "class";
    private static final String NATURE = "nature";
    private static final String ID = "id";
    private IConfigurationElement fConfigurationElement;
    private boolean fEnabled;
    private IQueryParticipant participant;

    protected SearchParticipantDescriptor(IConfigurationElement configElement) {
        this.fConfigurationElement = configElement;
        this.fEnabled = true;
    }

    protected IStatus checkSyntax() {
        if (this.fConfigurationElement.getAttribute(ID) == null) {
            String format = Messages.SearchParticipant_error_noID;
            String message = MessageFormat.format(format, this.fConfigurationElement.getDeclaringExtension().getUniqueIdentifier());
            return new Status(4, "org.eclipse.wst.xml.search.ui", 0, message, null);
        }
        if (this.fConfigurationElement.getAttribute(CLASS) == null) {
            String format = Messages.SearchParticipant_error_noClass;
            String message = MessageFormat.format(format, this.fConfigurationElement.getAttribute(ID));
            return new Status(4, "org.eclipse.wst.xml.search.ui", 0, message, null);
        }
        try {
            this.participant = this.create();
        }
        catch (CoreException e) {
            XMLSearchUIPlugin.log(e.getStatus());
            this.disable();
            String format = Messages.SearchParticipant_error_noClass;
            String message = MessageFormat.format(format, this.fConfigurationElement.getAttribute(ID));
            return new Status(4, "org.eclipse.wst.xml.search.ui", 0, message, null);
        }
        return Status.OK_STATUS;
    }

    public String getID() {
        return this.fConfigurationElement.getAttribute(ID);
    }

    public void disable() {
        this.fEnabled = false;
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    protected IQueryParticipant create() throws CoreException {
        try {
            return (IQueryParticipant)this.fConfigurationElement.createExecutableExtension(CLASS);
        }
        catch (ClassCastException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xml.search.ui", 0, Messages.SearchParticipant_error_classCast, (Throwable)e));
        }
    }

    protected String getNature() {
        return this.fConfigurationElement.getAttribute(NATURE);
    }

    public boolean isEnabledFor(Object selectedNode) {
        return this.getParticipant().isEnabledFor(selectedNode);
    }

    public IQueryParticipant getParticipant() {
        return this.participant;
    }
}

