/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.ui.internal.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wst.xml.search.core.xpath.IXPathProcessorType;
import org.eclipse.wst.xml.search.core.xpath.XPathProcessorManager;
import org.eclipse.wst.xml.search.ui.internal.Messages;
import org.eclipse.wst.xml.search.ui.internal.XMLSearchUIPlugin;
import org.eclipse.wst.xml.search.ui.internal.preferences.InstalledProcessorsBlock;

public class XPathProcessorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private InstalledProcessorsBlock processorsBlock;

    public XPathProcessorPreferencePage() {
        this.setTitle(Messages.XPathProcessorPreferencePage_0);
        this.setDescription(Messages.XPathProcessorPreferencePage_1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(XMLSearchUIPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite ancestor) {
        this.initializeDialogUnits((Control)ancestor);
        this.noDefaultAndApplyButton();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        ancestor.setLayout((Layout)layout);
        this.processorsBlock = new InstalledProcessorsBlock();
        this.processorsBlock.createControl(ancestor);
        Control control = this.processorsBlock.getControl();
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        control.setLayoutData((Object)data);
        this.initDefaultInstall();
        this.processorsBlock.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IXPathProcessorType processor = XPathProcessorPreferencePage.this.getCurrentDefaultProcessor();
                if (processor == null) {
                    XPathProcessorPreferencePage.this.setValid(false);
                    XPathProcessorPreferencePage.this.setErrorMessage(Messages.XPathProcessorPreferencePage_2);
                } else {
                    XPathProcessorPreferencePage.this.setValid(true);
                    XPathProcessorPreferencePage.this.setErrorMessage(null);
                }
            }
        });
        this.applyDialogFont(ancestor);
        return ancestor;
    }

    public boolean performOk() {
        IXPathProcessorType processorType = this.getCurrentDefaultProcessor();
        if (processorType == null) {
            this.setErrorMessage("Please select a XPath processor");
            return false;
        }
        this.processorsBlock.saveColumnSettings();
        XPathProcessorManager.getDefault().setDefaultProcessor(processorType);
        return true;
    }

    private void initDefaultInstall() {
        IXPathProcessorType processorType = XPathProcessorManager.getDefault().getDefaultProcessor();
        this.verifyDefaultVM(processorType);
    }

    private void verifyDefaultVM(IXPathProcessorType install) {
        if (install != null) {
            this.processorsBlock.setCheckedInstall(install);
        } else {
            this.processorsBlock.setCheckedInstall(null);
        }
    }

    private IXPathProcessorType getCurrentDefaultProcessor() {
        return this.processorsBlock.getCheckedInstall();
    }

    static /* synthetic */ IXPathProcessorType access$0(XPathProcessorPreferencePage xPathProcessorPreferencePage) {
        return xPathProcessorPreferencePage.getCurrentDefaultProcessor();
    }
}

