/*
 * Decompiled with CFR 0.152.
 */
package tern.resources;

import tern.ITernProject;
import tern.TernException;
import tern.resources.ITernFileUploader;
import tern.server.IResponseHandler;
import tern.server.ITernServer;
import tern.server.protocol.TernDoc;

public class SynchronousTernFileUploader
implements ITernFileUploader {
    private ITernProject project;

    public SynchronousTernFileUploader(ITernProject project) {
        this.project = project;
    }

    @Override
    public boolean cancel(String fileName) {
        return false;
    }

    @Override
    public void request(final TernDoc doc) {
        ITernServer server = this.project.getTernServer();
        if (server != null && !server.isDisposed()) {
            server.request(doc, new IResponseHandler(){

                @Override
                public void onSuccess(Object data, String dataAsJsonString) {
                }

                @Override
                public void onError(String error, Throwable t) {
                    SynchronousTernFileUploader.this.project.handleException(new TernException(error, t));
                    SynchronousTernFileUploader.this.project.getFileSynchronizer().uploadFailed(doc);
                }

                @Override
                public boolean isDataAsJsonString() {
                    return false;
                }
            });
        }
    }

    @Override
    public void join(long timeout) {
    }
}

