/*
 * Decompiled with CFR 0.152.
 */
package tern.server.protocol.outline;

import tern.server.protocol.IJSONObjectHelper;
import tern.server.protocol.ITernResultProcessor;
import tern.server.protocol.TernDoc;
import tern.server.protocol.outline.IJSNode;
import tern.server.protocol.outline.IJSNodeRoot;
import tern.server.protocol.outline.ITernOutlineCollector;

public class TernOutlineResultProcessor
implements ITernResultProcessor<ITernOutlineCollector> {
    public static final TernOutlineResultProcessor INSTANCE = new TernOutlineResultProcessor();
    private static final String OUTLINE_FIELD_NAME = "outline";
    private static final String CHILDREN_FIELD_NAME = "children";

    @Override
    public void process(TernDoc doc, IJSONObjectHelper helper, Object jsonObject, ITernOutlineCollector collector) {
        Iterable<Object> outline = helper.getList(jsonObject, OUTLINE_FIELD_NAME);
        IJSNodeRoot root = collector.createRoot();
        if (outline != null) {
            this.addChildren(outline, root, collector, helper);
        }
    }

    protected void addChildren(Iterable<Object> jsonNodes, IJSNode parent, ITernOutlineCollector collector, IJSONObjectHelper helper) {
        String name = null;
        String type = null;
        String kind = null;
        String value = null;
        Long start = null;
        Long end = null;
        String file = null;
        IJSNode node = null;
        for (Object jsonNode : jsonNodes) {
            name = helper.getText(jsonNode, "name");
            type = helper.getText(jsonNode, "type");
            kind = helper.getText(jsonNode, "kind");
            value = helper.getText(jsonNode, "value");
            start = helper.getLong(jsonNode, "start");
            end = helper.getLong(jsonNode, "end");
            file = helper.getText(jsonNode, "file");
            node = collector.createNode(name, type, kind, value, start, end, file, parent, jsonNode, helper);
            Iterable<Object> jsonChildren = helper.getList(jsonNode, CHILDREN_FIELD_NAME);
            if (jsonChildren == null) continue;
            this.addChildren(jsonChildren, node, collector, helper);
        }
    }
}

