/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.action;

import com.liferay.ide.gradle.core.GradleUtil;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.ui.action.AbstractObjectAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class GradleTaskAction
extends AbstractObjectAction {
    IProject _project = null;

    protected void afterTask() {
    }

    protected abstract String getGradleTask();

    public void run(IAction action) {
        if (this.fSelection instanceof IStructuredSelection) {
            Object[] elems = ((IStructuredSelection)this.fSelection).toArray();
            IFile gradleBuildFile = null;
            Object elem = elems[0];
            if (elem instanceof IFile) {
                gradleBuildFile = (IFile)elem;
                this._project = gradleBuildFile.getProject();
            } else if (elem instanceof IProject) {
                this._project = (IProject)elem;
                gradleBuildFile = this._project.getFile("build.gradle");
            }
            if (gradleBuildFile.exists()) {
                Job job = new Job(String.valueOf(this._project.getName()) + " - " + this.getGradleTask()){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            monitor.beginTask(GradleTaskAction.this.getGradleTask(), 100);
                            GradleUtil.runGradleTask((IProject)GradleTaskAction.this._project, (String)GradleTaskAction.this.getGradleTask(), (IProgressMonitor)monitor);
                            monitor.worked(80);
                            GradleTaskAction.this._project.refreshLocal(2, monitor);
                            monitor.worked(20);
                        }
                        catch (Exception e) {
                            return ProjectUI.createErrorStatus((String)("Error running Gradle goal " + GradleTaskAction.this.getGradleTask()), (Exception)e);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.addJobChangeListener(new IJobChangeListener(){

                    public void sleeping(IJobChangeEvent event) {
                    }

                    public void scheduled(IJobChangeEvent event) {
                    }

                    public void running(IJobChangeEvent event) {
                    }

                    public void done(IJobChangeEvent event) {
                        GradleTaskAction.this.afterTask();
                    }

                    public void awake(IJobChangeEvent event) {
                    }

                    public void aboutToRun(IJobChangeEvent event) {
                    }
                });
                job.schedule();
            }
        }
    }
}

