/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.project.core.PluginClasspathContainer;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;

public class SDKClasspathContainer
extends PluginClasspathContainer
implements IClasspathContainer {
    private static final String[] commonJars = new String[]{"commons-logging.jar", "log4j.jar", "util-bridges.jar", "util-java.jar", "util-taglib.jar"};
    public static final String ID = "com.liferay.ide.sdk.container";
    private final IPath bundleDir;
    private final IPath[] bundleLibDependencyPaths;
    private final IPath portalGlobalDir;
    private final IPath[] sdkDependencyPaths;

    public SDKClasspathContainer(IPath containerPath, IJavaProject project, IPath portalDir, String javadocURL, IPath sourceURL, IPath portalGlobalDir, IPath bundleDir, IPath[] bundleLibDependencyPaths, IPath[] sdkDependencyPaths) {
        super(containerPath, project, portalDir, javadocURL, sourceURL);
        this.portalGlobalDir = portalGlobalDir;
        this.bundleDir = bundleDir;
        this.bundleLibDependencyPaths = bundleLibDependencyPaths;
        this.sdkDependencyPaths = sdkDependencyPaths;
    }

    public IPath getBundleDir() {
        return this.bundleDir;
    }

    public IPath[] getBundleLibDependencyPath() {
        return this.bundleLibDependencyPaths;
    }

    @Override
    public IClasspathEntry[] getClasspathEntries() {
        if (this.classpathEntries == null) {
            ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
            Object[] objectArray = this.bundleLibDependencyPaths;
            int n = this.bundleLibDependencyPaths.length;
            int n2 = 0;
            while (n2 < n) {
                IPath pluginJarPath = objectArray[n2];
                IPath sourcePath = null;
                if (portalSourceJars.contains(pluginJarPath.lastSegment())) {
                    sourcePath = this.getSourceLocation();
                }
                entries.add(this.createClasspathEntry(pluginJarPath, sourcePath, this.javadocURL));
                ++n2;
            }
            if (this.portalDir != null) {
                objectArray = this.getPortalJars();
                n = objectArray.length;
                n2 = 0;
                while (n2 < n) {
                    IPath pluginJar = objectArray[n2];
                    entries.add(this.createPortalJarClasspathEntry((String)pluginJar));
                    ++n2;
                }
                objectArray = this.getPortalDependencyJars();
                n = objectArray.length;
                n2 = 0;
                while (n2 < n) {
                    IPath pluginPackageJar = objectArray[n2];
                    entries.add(this.createPortalJarClasspathEntry((String)pluginPackageJar));
                    ++n2;
                }
            }
            if (this.sdkDependencyPaths != null) {
                objectArray = this.sdkDependencyPaths;
                n = this.sdkDependencyPaths.length;
                n2 = 0;
                while (n2 < n) {
                    IPath sdkDependencyJarPath = objectArray[n2];
                    entries.add(this.createClasspathEntry(sdkDependencyJarPath, null, null));
                    ++n2;
                }
            }
            this.classpathEntries = entries.toArray(new IClasspathEntry[entries.size()]);
        }
        return this.classpathEntries;
    }

    @Override
    public String getDescription() {
        return "Plugins SDK Dependencies";
    }

    public IPath getPortalGlobalDir() {
        return this.portalGlobalDir;
    }

    @Override
    protected String[] getPortalJars() {
        return commonJars;
    }
}

