/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.ISDKProjectsImportDataModelProperties;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.ProjectRecord;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.core.util.SDKPluginFacetUtil;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import com.liferay.ide.sdk.core.SDKUtil;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class SDKProjectConvertOperation
extends AbstractDataModelOperation
implements ISDKProjectsImportDataModelProperties {
    IProject convertedProject;

    public SDKProjectConvertOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Object[] selectedProjects = (Object[])this.getDataModel().getProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS");
        int i = 0;
        while (i < selectedProjects.length) {
            IStatus status;
            if (selectedProjects[i] instanceof ProjectRecord && !(status = this.convertProject((ProjectRecord)selectedProjects[i], monitor)).isOK()) {
                return status;
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    protected IProject convertExistingProject(ProjectRecord record, IProgressMonitor monitor) throws CoreException {
        String projectName = record.getProjectName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        if (record.description == null) {
            record.description = workspace.newProjectDescription(projectName);
            Path locationPath = new Path(record.projectSystemFile.getAbsolutePath());
            if (Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                record.description.setLocation(null);
            } else {
                record.description.setLocation((IPath)locationPath);
            }
        } else {
            record.description.setName(projectName);
        }
        monitor.beginTask(Msgs.importingProject, 100);
        project.open(1, CoreUtil.newSubMonitor((IProgressMonitor)monitor, (int)70));
        IFacetedProject fProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
        FacetedProjectWorkingCopy fpwc = new FacetedProjectWorkingCopy(fProject);
        String sdkLocation = this.getDataModel().getStringProperty("ISDKProjectsImportDataModelProperties.SDK_LOCATION");
        IRuntime runtime = (IRuntime)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        String pluginType = ProjectUtil.guessPluginType((IFacetedProjectWorkingCopy)fpwc);
        SDKPluginFacetUtil.configureProjectAsRuntimeProject((IFacetedProjectWorkingCopy)fpwc, runtime, pluginType, sdkLocation, record);
        fpwc.commitChanges(monitor);
        monitor.done();
        return project;
    }

    protected IStatus convertProject(ProjectRecord projectRecord, IProgressMonitor monitor) {
        IProject project = null;
        if (projectRecord.project != null) {
            try {
                project = this.convertExistingProject(projectRecord, monitor);
            }
            catch (CoreException e) {
                return ProjectCore.createErrorStatus((Exception)((Object)e));
            }
        }
        this.convertedProject = project;
        return Status.OK_STATUS;
    }

    protected String getSDKName() {
        String sdkLocation = this.getDataModel().getStringProperty("ISDKProjectsImportDataModelProperties.SDK_LOCATION");
        Path sdkLocationPath = new Path(sdkLocation);
        SDK sdk = SDKManager.getInstance().getSDK((IPath)sdkLocationPath);
        String sdkName = null;
        if (sdk != null) {
            sdkName = sdk.getName();
        } else {
            sdk = SDKUtil.createSDKFromLocation((IPath)sdkLocationPath);
            SDKManager.getInstance().addSDK(sdk);
            sdkName = sdk.getName();
        }
        return sdkName;
    }

    private static class Msgs
    extends NLS {
        public static String importingProject;

        static {
            Msgs.initializeMessages((String)SDKProjectConvertOperation.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

