/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.jsf;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.jsf.NewLiferayJSFModuleProjectOp;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.platform.PathBridge;

public class JSFModuleProjectNameListener
extends FilteredListener<PropertyContentEvent> {
    protected void handleTypedEvent(PropertyContentEvent event) {
        JSFModuleProjectNameListener.updateLocation(this.op(event));
    }

    protected NewLiferayJSFModuleProjectOp op(PropertyContentEvent event) {
        return (NewLiferayJSFModuleProjectOp)event.property().element().nearest(NewLiferayJSFModuleProjectOp.class);
    }

    public static void updateLocation(NewLiferayJSFModuleProjectOp op) {
        String currentProjectName = (String)op.getProjectName().content(true);
        Path newLocationBase = null;
        if (currentProjectName == null || CoreUtil.isNullOrEmpty((String)currentProjectName.trim())) {
            return;
        }
        boolean useDefaultLocation = (Boolean)op.getUseDefaultLocation().content(true);
        if (useDefaultLocation) {
            newLocationBase = PathBridge.create((IPath)CoreUtil.getWorkspaceRoot().getLocation());
        } else {
            Path currentProjectLocation = (Path)op.getLocation().content(true);
            boolean hasLiferayWorkspace = false;
            if (currentProjectLocation != null) {
                hasLiferayWorkspace = LiferayWorkspaceUtil.isValidWorkspaceLocation(currentProjectLocation.toOSString());
            }
            if (hasLiferayWorkspace) {
                File workspaceDir = LiferayWorkspaceUtil.getWorkspaceDir(currentProjectLocation.toFile());
                if (workspaceDir == null || !workspaceDir.exists()) {
                    return;
                }
                String[] folders = LiferayWorkspaceUtil.getLiferayWorkspaceProjectWarsDirs(workspaceDir.getAbsolutePath());
                if (folders != null) {
                    boolean appendWarFolder = false;
                    IPath projectLocation = PathBridge.create((Path)currentProjectLocation);
                    String[] stringArray = folders;
                    int n = folders.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String folder = stringArray[n2];
                        if (projectLocation.lastSegment().endsWith(folder)) {
                            appendWarFolder = true;
                            break;
                        }
                        ++n2;
                    }
                    newLocationBase = appendWarFolder ? PathBridge.create((IPath)projectLocation) : PathBridge.create((IPath)projectLocation.append(folders[0]));
                } else {
                    newLocationBase = PathBridge.create((IPath)CoreUtil.getWorkspaceRoot().getLocation());
                }
            }
        }
        if (newLocationBase != null) {
            op.setLocation(newLocationBase);
        }
    }
}

