/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.model.internal;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOpMethods;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.sapphire.DefaultValueService;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;

public class GroupIdDefaultValueService
extends DefaultValueService {
    protected String compute() {
        String groupId = null;
        org.eclipse.sapphire.modeling.Path location = (org.eclipse.sapphire.modeling.Path)this.op().getLocation().content();
        if (location != null) {
            NewLiferayPluginProjectOp op = this.op();
            String parentProjectLocation = location.toOSString();
            IPath parentProjectOsPath = Path.fromOSString((String)parentProjectLocation);
            String projectName = (String)this.op().getProjectName().content();
            groupId = NewLiferayPluginProjectOpMethods.getMavenParentPomGroupId(op, projectName, parentProjectOsPath);
        }
        if (groupId == null && CoreUtil.isNullOrEmpty((String)(groupId = this.getDefaultMavenGroupId()))) {
            groupId = "com.example.plugins";
        }
        return groupId;
    }

    private String getDefaultMavenGroupId() {
        IScopeContext[] prefContexts = new IScopeContext[]{DefaultScope.INSTANCE, InstanceScope.INSTANCE};
        String defaultMavenGroupId = Platform.getPreferencesService().getString("com.liferay.ide.project.core", "default-plugin-project-maven-groupid", null, prefContexts);
        return defaultMavenGroupId;
    }

    protected void initDefaultValueService() {
        super.initDefaultValueService();
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                GroupIdDefaultValueService.this.refresh();
            }
        };
        this.op().getLocation().attach((Listener)listener);
        this.op().getProjectName().attach((Listener)listener);
    }

    private NewLiferayPluginProjectOp op() {
        return (NewLiferayPluginProjectOp)this.context(NewLiferayPluginProjectOp.class);
    }
}

