/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules;

import com.liferay.ide.project.core.modules.NewLiferayModuleProjectOp;
import org.eclipse.sapphire.DefaultValueService;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;

public class ComponentNameDefaultValueService
extends DefaultValueService {
    private FilteredListener<PropertyContentEvent> listener;

    protected void initDefaultValueService() {
        super.initDefaultValueService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                ComponentNameDefaultValueService.this.refresh();
            }
        };
        this.op().property(NewLiferayModuleProjectOp.PROP_PROJECT_NAME).attach(this.listener);
        this.op().property(NewLiferayModuleProjectOp.PROP_PROJECT_TEMPLATE_NAME).attach(this.listener);
    }

    protected String compute() {
        String retVal = "";
        String projectName = (String)this.op().getProjectName().content(true);
        if (projectName != null) {
            String projectTemplate = (String)this.op().getProjectTemplateName().content();
            String className = this.getClassName(projectName);
            if (projectTemplate.equals("activator") && !className.endsWith("Activator")) {
                className = String.valueOf(className) + "Activator";
            } else if ((projectTemplate.equals("mvc-portlet") || projectTemplate.equals("portlet")) && className.length() > 7 && className.endsWith("Portlet")) {
                className = className.substring(0, className.length() - 7);
            }
            retVal = className;
        }
        return retVal;
    }

    private NewLiferayModuleProjectOp op() {
        return (NewLiferayModuleProjectOp)this.context(NewLiferayModuleProjectOp.class);
    }

    private String getClassName(String name) {
        name = this.getCapitalizedName(name);
        return ComponentNameDefaultValueService.removeChar(name, ' ');
    }

    private String getCapitalizedName(String name) {
        name = name.replace('-', ' ');
        name = name.replace('.', ' ');
        return ComponentNameDefaultValueService.capitalize(name, ' ');
    }

    static String removeChar(String s, char c) {
        int y = s.indexOf(c);
        if (y == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        int x = 0;
        while (x <= y) {
            sb.append(s.substring(x, y));
            x = y + 1;
            y = s.indexOf(c, x);
        }
        sb.append(s.substring(x));
        return sb.toString();
    }

    private static String capitalize(String s, char separator) {
        StringBuilder sb = new StringBuilder(s.length());
        sb.append(s);
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            if (i == 0 || sb.charAt(i - 1) == separator) {
                c = Character.toUpperCase(c);
            }
            sb.setCharAt(i, c);
            ++i;
        }
        return sb.toString();
    }

    public void dispose() {
        if (this.op() != null) {
            this.op().property(NewLiferayModuleProjectOp.PROP_PROJECT_TEMPLATE_NAME).detach(this.listener);
            this.op().property(NewLiferayModuleProjectOp.PROP_PROJECT_NAME).detach(this.listener);
        }
        super.dispose();
    }
}

