/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules;

import com.liferay.ide.core.ILiferayProjectImporter;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.ImportLiferayModuleProjectOp;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;
import org.eclipse.sapphire.platform.StatusBridge;

public class ImportLiferayModuleProjectOpMethods {
    public static final Status execute(ImportLiferayModuleProjectOp op, ProgressMonitor pm) {
        IProgressMonitor monitor = ProgressMonitorBridge.create((ProgressMonitor)pm);
        monitor.beginTask("Importing Module project...", 100);
        String location = ((Path)op.getLocation().content()).toOSString();
        ILiferayProjectImporter importer = LiferayCore.getImporter((String)((String)op.getBuildType().content()));
        Status retval = Status.createOkStatus();
        try {
            importer.importProjects(location, monitor);
        }
        catch (CoreException e) {
            retval = Status.createErrorStatus((Throwable)e);
        }
        return retval;
    }

    public static IStatus getBuildType(String location) {
        ILiferayProjectImporter[] importers;
        IStatus retval = null;
        ILiferayProjectImporter[] iLiferayProjectImporterArray = importers = LiferayCore.getImporters();
        int n = importers.length;
        int n2 = 0;
        while (n2 < n) {
            ILiferayProjectImporter importer = iLiferayProjectImporterArray[n2];
            IStatus status = importer.canImport(location);
            if (status == null) {
                retval = ProjectCore.createErrorStatus("Location is not recognized as a valid project type.");
            } else {
                if (status.isOK()) {
                    retval = StatusBridge.create((Status)Status.createStatus((Status.Severity)Status.Severity.OK, (String)importer.getBuildType()));
                    break;
                }
                if (status.getSeverity() == 4) {
                    retval = StatusBridge.create((Status)Status.createStatus((Status.Severity)Status.Severity.ERROR, (String)status.getMessage()));
                    break;
                }
                if (status.getSeverity() == 2) {
                    retval = StatusBridge.create((Status)Status.createStatus((Status.Severity)Status.Severity.WARNING, (String)status.getMessage()));
                    break;
                }
            }
            ++n2;
        }
        if (retval == null) {
            retval = StatusBridge.create((Status)Status.createStatus((Status.Severity)Status.Severity.ERROR, (String)"No project importers found."));
        }
        return retval;
    }
}

