/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.modules.ImportLiferayModuleProjectOp;
import com.liferay.ide.project.core.modules.ImportLiferayModuleProjectOpMethods;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import com.liferay.ide.project.core.util.ProjectImportUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.services.ValidationService;

public class ImportModuleProjectLocationValidationService
extends ValidationService {
    protected Status compute() {
        Status retval = Status.createOkStatus();
        Path path = (Path)this.op().getLocation().content();
        if (path != null && !path.isEmpty()) {
            String location = path.toOSString();
            retval = StatusBridge.create((IStatus)ProjectImportUtil.validatePath(location));
            if (!retval.ok()) {
                return retval;
            }
            if (LiferayWorkspaceUtil.isValidWorkspaceLocation(location)) {
                retval = Status.createErrorStatus((String)"Can't import Liferay Workspace, please use Import Liferay Workspace Project wizard.");
                return retval;
            }
            retval = StatusBridge.create((IStatus)ImportLiferayModuleProjectOpMethods.getBuildType(location));
            if (retval.severity() == Status.Severity.ERROR) {
                return retval;
            }
            String projectName = path.lastSegment();
            if (CoreUtil.getProject((String)projectName).exists()) {
                retval = Status.createErrorStatus((String)"A project with that name already exists.");
                return retval;
            }
        }
        return retval;
    }

    private ImportLiferayModuleProjectOp op() {
        return (ImportLiferayModuleProjectOp)this.context(ImportLiferayModuleProjectOp.class);
    }
}

