/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules.templates.friendlyurl;

import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.templates.AbstractLiferayComponentTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class NewLiferayComponentFriendUrlOperation
extends AbstractLiferayComponentTemplate {
    private static final String TEMPLATE_FILE = "friendlyurl/friendlyUrl.ftl";
    private static final String SUPER_CLASS = "DefaultFriendlyURLMapper";
    private static final String EXTENSION_CLASS = "FriendlyURLMapper.class";
    private static final String[] PROPERTIES_LIST = new String[]{"javax.portlet.name=com_liferay_network_utilities_web_portlet_NetworkUtilitiesPortlet"};

    @Override
    protected List<String> getImports() {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("com.liferay.portal.kernel.portlet.DefaultFriendlyURLMapper");
        imports.add("com.liferay.portal.kernel.portlet.FriendlyURLMapper");
        imports.addAll(super.getImports());
        return imports;
    }

    @Override
    protected List<String> getProperties() {
        ArrayList<String> friendUrlProperties = new ArrayList<String>();
        friendUrlProperties.addAll(Arrays.asList(PROPERTIES_LIST));
        friendUrlProperties.add("com.liferay.portlet.friendly-url-routes=META-INF/friendly-url-routes/" + this.componentClassName.toLowerCase() + "/routes.xml");
        return friendUrlProperties;
    }

    @Override
    protected String getSuperClass() {
        return SUPER_CLASS;
    }

    @Override
    protected String getExtensionClass() {
        return EXTENSION_CLASS;
    }

    @Override
    protected String getTemplateFile() {
        return TEMPLATE_FILE;
    }

    @Override
    protected void doMergeResourcesOperation() throws CoreException {
        try {
            IFolder resourceFolder = this.liferayProject.getSourceFolder("resources");
            IFolder metaFolder = resourceFolder.getFolder("META-INF/friendly-url-routes");
            IFile routesXml = metaFolder.getFile((IPath)new Path(String.valueOf(this.componentClassName.toLowerCase()) + "/routes.xml"));
            if (!routesXml.getLocation().toFile().exists()) {
                this.createSampleFile(routesXml, "friendlyurl/friendurl-routes.xml");
            }
        }
        catch (Exception e) {
            throw new CoreException(ProjectCore.createErrorStatus(e));
        }
    }
}

