/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules.templates.servicewrapper;

import com.liferay.ide.project.core.modules.ServiceContainer;
import com.liferay.ide.project.core.modules.templates.AbstractLiferayComponentTemplate;
import com.liferay.ide.project.core.util.TargetPlatformUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.osgi.framework.Version;

public class NewLiferayComponentServiceOperation
extends AbstractLiferayComponentTemplate {
    private static final String TEMPLATE_FILE = "servicewrapper/servicewrapper.ftl";
    private String serviceClassName;

    @Override
    protected List<String> getImports() {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("com.liferay.portal.kernel.service.ServiceWrapper");
        imports.add(this.serviceName);
        imports.addAll(super.getImports());
        return imports;
    }

    @Override
    protected String getSuperClass() {
        if (this.serviceName != null) {
            int servicePos = this.serviceName.lastIndexOf(".");
            this.serviceClassName = this.serviceName.substring(servicePos + 1);
        }
        return this.serviceClassName;
    }

    @Override
    protected String getExtensionClass() {
        return "ServiceWrapper.class";
    }

    @Override
    protected String getTemplateFile() {
        return TEMPLATE_FILE;
    }

    @Override
    protected List<String[]> getComponentDependency() throws CoreException {
        List<String[]> componentDependency = super.getComponentDependency();
        try {
            ServiceContainer serviceBundle = TargetPlatformUtil.getServiceWrapperBundle(this.serviceName);
            if (serviceBundle != null) {
                Version retriveVersion = new Version(serviceBundle.getBundleVersion());
                componentDependency.add(new String[]{serviceBundle.getBundleGroup(), serviceBundle.getBundleName(), String.valueOf(retriveVersion.getMajor()) + "." + retriveVersion.getMinor() + ".0"});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return componentDependency;
    }
}

