/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.upgrade.service;

import com.liferay.ide.project.core.upgrade.CodeUpgradeOp;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.DerivedValueService;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.platform.PathBridge;

public class CheckSDKLocationDerivedValueService
extends DerivedValueService {
    private FilteredListener<PropertyContentEvent> listener;

    private void checkProjects(CodeUpgradeOp op, SDK sdk) {
        File[] webs;
        File[] themes;
        File[] layouttpls;
        File[] exts;
        Object serviceXml3;
        File[] hooks;
        Object serviceXml22;
        int n;
        File[] portlets = this.getFiles(sdk, "portlet");
        if (portlets != null) {
            File[] fileArray = portlets;
            n = portlets.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    op.setHasPortlet("true");
                    serviceXml22 = new Path(file.getPath()).append("docroot/WEB-INF/service.xml").toFile();
                    if (((File)serviceXml22).exists()) {
                        op.setHasServiceBuilder("true");
                    }
                }
                ++n2;
            }
        }
        if ((hooks = this.getFiles(sdk, "hook")) != null) {
            serviceXml22 = hooks;
            int n3 = hooks.length;
            n = 0;
            while (n < n3) {
                File file = serviceXml22[n];
                if (file.isDirectory()) {
                    op.setHasHook("true");
                    serviceXml3 = new Path(file.getPath()).append("docroot/WEB-INF/service.xml").toFile();
                    if (((File)serviceXml3).exists()) {
                        op.setHasServiceBuilder("true");
                    }
                }
                ++n;
            }
        }
        if ((exts = this.getFiles(sdk, "ext")) != null) {
            serviceXml3 = exts;
            int serviceXml22 = exts.length;
            int n4 = 0;
            while (n4 < serviceXml22) {
                File file = serviceXml3[n4];
                if (file.isDirectory()) {
                    op.setHasExt("true");
                    break;
                }
                ++n4;
            }
        }
        if ((layouttpls = this.getFiles(sdk, "layouttpl")) != null) {
            File[] fileArray = layouttpls;
            int serviceXml3 = layouttpls.length;
            int serviceXml22 = 0;
            while (serviceXml22 < serviceXml3) {
                File file = fileArray[serviceXml22];
                if (file.isDirectory()) {
                    op.setHasLayout("true");
                    break;
                }
                ++serviceXml22;
            }
        }
        if ((themes = this.getFiles(sdk, "theme")) != null) {
            File[] fileArray = themes;
            int n5 = themes.length;
            int serviceXml3 = 0;
            while (serviceXml3 < n5) {
                File file = fileArray[serviceXml3];
                if (file.isDirectory()) {
                    op.setHasTheme("true");
                    break;
                }
                ++serviceXml3;
            }
        }
        if ((webs = this.getFiles(sdk, "web")) != null) {
            File[] fileArray = webs;
            int n6 = webs.length;
            int n7 = 0;
            while (n7 < n6) {
                File file = fileArray[n7];
                if (file.isDirectory()) {
                    op.setHasWeb("true");
                    break;
                }
                ++n7;
            }
        }
    }

    protected String compute() {
        CodeUpgradeOp op = this.op();
        Path path = (Path)op.getSdkLocation().content();
        SDK sdk = SDKUtil.createSDKFromLocation((IPath)PathBridge.create((Path)path));
        String liferay62ServerLocation = null;
        try {
            if (sdk != null) {
                liferay62ServerLocation = (String)sdk.getBuildProperties(true).get("app.server.parent.dir");
                this.checkProjects(op, sdk);
            } else {
                this.setAllStateFalse(op);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return liferay62ServerLocation;
    }

    private File[] getFiles(SDK sdk, String projectType) {
        IPath folderPath = sdk.getLocation().append(sdk.getPluginFolder(projectType));
        File folder = folderPath.toFile();
        if (!folder.exists()) {
            return null;
        }
        return folder.listFiles();
    }

    protected void initDerivedValueService() {
        super.initDerivedValueService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                CheckSDKLocationDerivedValueService.this.refresh();
            }
        };
        this.op().property(CodeUpgradeOp.PROP_SDK_LOCATION).attach(this.listener);
    }

    private CodeUpgradeOp op() {
        return (CodeUpgradeOp)this.context(CodeUpgradeOp.class);
    }

    private void setAllStateFalse(CodeUpgradeOp op) {
        op.setHasPortlet(false);
        op.setHasServiceBuilder(false);
        op.setHasHook(false);
        op.setHasExt(false);
        op.setHasLayout(false);
        op.setHasTheme(false);
        op.setHasWeb(false);
    }
}

