/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.util;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.ZipUtil;
import com.liferay.ide.project.core.BinaryProjectRecord;
import com.liferay.ide.project.core.IPortletFramework;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.ProjectRecord;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.core.util.ResourceFilterUtil;
import com.liferay.ide.sdk.core.ISDKConstants;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import com.liferay.ide.sdk.core.SDKUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.internal.BridgedRuntime;

public class ProjectImportUtil {
    public static boolean collectBinariesFromDirectory(Collection<File> binaryProjectFiles, File directory, boolean recurse, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(NLS.bind((String)Msgs.checking, (Object)directory.getPath()));
        List<String> wildCards = Arrays.asList(ISDKConstants.BINARY_PLUGIN_PROJECT_WILDCARDS);
        WildcardFileFilter wildcardFileFilter = new WildcardFileFilter(wildCards);
        Collection contents = FileUtils.listFiles((File)directory, (IOFileFilter)wildcardFileFilter, (IOFileFilter)DirectoryFileFilter.INSTANCE);
        if (contents == null) {
            return false;
        }
        for (File file : contents) {
            if (binaryProjectFiles.contains(file) || !ProjectImportUtil.isValidLiferayPlugin(file)) continue;
            binaryProjectFiles.add(file);
        }
        return true;
    }

    public static ProjectRecord createSDKPluginProject(BridgedRuntime bridgedRuntime, BinaryProjectRecord pluginBinaryRecord, SDK liferaySDK) throws IOException {
        ProjectRecord projectRecord = null;
        if (!pluginBinaryRecord.isConflicts()) {
            String displayName = pluginBinaryRecord.getDisplayName();
            File binaryFile = pluginBinaryRecord.getBinaryFile();
            IPath projectPath = null;
            IPath sdkPluginProjectFolder = liferaySDK.getLocation();
            String webappRootFolder = null;
            NullProgressMonitor npm = new NullProgressMonitor();
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add(displayName);
            arguments.add(displayName);
            if (pluginBinaryRecord.isHook()) {
                sdkPluginProjectFolder = sdkPluginProjectFolder.append("hooks");
                try {
                    projectPath = liferaySDK.createNewProject(displayName, arguments, "hook", sdkPluginProjectFolder.toOSString(), (IProgressMonitor)npm);
                }
                catch (CoreException e) {
                    ProjectCore.logError(e);
                }
                webappRootFolder = "docroot";
            } else if (pluginBinaryRecord.isPortlet()) {
                IPortletFramework[] portletFrameworks = ProjectCore.getPortletFrameworks();
                String portletFrameworkName = null;
                int i = 0;
                while (i < portletFrameworks.length) {
                    IPortletFramework portletFramework = portletFrameworks[i];
                    if (portletFramework.isDefault() && !portletFramework.isAdvanced()) {
                        portletFrameworkName = portletFramework.getShortName();
                        break;
                    }
                    ++i;
                }
                sdkPluginProjectFolder = sdkPluginProjectFolder.append("portlets");
                arguments.add(portletFrameworkName);
                try {
                    projectPath = liferaySDK.createNewProject(displayName, arguments, "portlet", sdkPluginProjectFolder.toOSString(), (IProgressMonitor)npm);
                }
                catch (CoreException e) {
                    ProjectCore.logError(e);
                }
                webappRootFolder = "docroot";
            } else if (pluginBinaryRecord.isTheme()) {
                sdkPluginProjectFolder = sdkPluginProjectFolder.append("themes");
                try {
                    projectPath = liferaySDK.createNewProject(displayName, arguments, "theme", sdkPluginProjectFolder.toOSString(), (IProgressMonitor)npm);
                }
                catch (CoreException e) {
                    ProjectCore.logError(e);
                }
                webappRootFolder = "docroot";
            } else if (pluginBinaryRecord.isLayoutTpl()) {
                sdkPluginProjectFolder = sdkPluginProjectFolder.append("layouttpl");
                try {
                    projectPath = liferaySDK.createNewProject(displayName, arguments, "layouttpl", sdkPluginProjectFolder.toOSString(), (IProgressMonitor)npm);
                }
                catch (CoreException e) {
                    ProjectCore.logError(e);
                }
                webappRootFolder = "docroot";
            } else if (pluginBinaryRecord.isExt()) {
                sdkPluginProjectFolder = sdkPluginProjectFolder.append("ext");
                try {
                    projectPath = liferaySDK.createNewProject(displayName, arguments, "ext", sdkPluginProjectFolder.toOSString(), (IProgressMonitor)npm);
                }
                catch (CoreException e) {
                    ProjectCore.logError(e);
                }
                webappRootFolder = "docroot/WEB-INF/ext-web/docroot";
            } else if (pluginBinaryRecord.isWeb()) {
                sdkPluginProjectFolder = sdkPluginProjectFolder.append("webs");
                try {
                    projectPath = liferaySDK.createNewProject(displayName, arguments, "web", sdkPluginProjectFolder.toOSString(), (IProgressMonitor)npm);
                }
                catch (CoreException e) {
                    ProjectCore.logError(e);
                }
                webappRootFolder = "docroot";
            }
            File webappRoot = new File(projectPath.toFile(), webappRootFolder);
            ZipUtil.unzip((File)binaryFile, (File)webappRoot);
            File projectFile = new File(projectPath.toFile(), ".project");
            projectRecord = projectFile.exists() ? new ProjectRecord(projectFile) : new ProjectRecord(projectPath.toFile());
        }
        return projectRecord;
    }

    public static void createWorkspaceProjects(Object[] projects, IRuntime runtime, String sdkLocation, IProgressMonitor monitor) throws CoreException {
        ArrayList<IProject> createdProjects = new ArrayList<IProject>();
        monitor.beginTask(Msgs.creatingSDKWorkspaceProjects, projects.length);
        if (projects != null && projects.length > 0) {
            SDK sdk = SDKManager.getInstance().getSDK((IPath)new Path(sdkLocation));
            if (sdk == null) {
                sdk = SDKUtil.createSDKFromLocation((IPath)new Path(sdkLocation));
            }
            if (sdk != null && sdk.isValid() && !SDKManager.getInstance().containsSDK(sdk)) {
                SDKManager.getInstance().addSDK(sdk);
            }
        }
        int i = 0;
        while (i < projects.length) {
            IProject project;
            if (projects[i] instanceof ProjectRecord && (project = ProjectImportUtil.importProject((ProjectRecord)projects[i], runtime, sdkLocation, monitor)) != null) {
                createdProjects.add(project);
                monitor.worked(createdProjects.size());
            }
            ++i;
        }
    }

    public static final String getConfigFileLocation(String configFile) {
        StringBuilder sb = new StringBuilder("WEB-INF/");
        sb.append(configFile);
        return sb.toString();
    }

    public static IProject importProject(IPath projectdir, IProgressMonitor monitor, NewLiferayPluginProjectOp op) throws CoreException {
        IProject project = null;
        ProjectRecord projectRecord = ProjectUtil.getProjectRecordForDir(projectdir.toPortableString());
        File projectDir = projectRecord.getProjectLocation().toFile();
        SDK sdk = SDKUtil.getSDKFromProjectDir((File)projectDir);
        if (sdk == null) {
            return null;
        }
        if (projectRecord.projectSystemFile != null) {
            try {
                project = ProjectUtil.createExistingProject(projectRecord, sdk.getLocation(), monitor);
            }
            catch (CoreException e) {
                throw new CoreException(ProjectCore.createErrorStatus((Exception)((Object)e)));
            }
        }
        if (projectRecord.liferayProjectDir != null) {
            try {
                project = ProjectUtil.createNewSDKProject(projectRecord, sdk.getLocation(), monitor, op);
            }
            catch (CoreException e) {
                throw new CoreException(ProjectCore.createErrorStatus((Exception)((Object)e)));
            }
        }
        String parentName = projectdir.removeLastSegments(1).toFile().getName();
        IProject sdkProject = CoreUtil.getProject((String)sdk.getName());
        IFolder folder = sdkProject.getFolder(parentName);
        ResourceFilterUtil.addResourceFilter(folder, project.getName(), monitor);
        return project;
    }

    public static IProject importProject(ProjectRecord projectRecord, IRuntime runtime, String sdkLocation, IProgressMonitor monitor) throws CoreException {
        return ProjectImportUtil.importProject(projectRecord, runtime, sdkLocation, null, monitor);
    }

    public static IProject importProject(ProjectRecord projectRecord, IRuntime runtime, String sdkLocation, NewLiferayPluginProjectOp op, IProgressMonitor monitor) throws CoreException {
        IProject project = null;
        if (projectRecord.projectSystemFile != null) {
            try {
                project = ProjectUtil.createExistingProject(projectRecord, runtime, sdkLocation, monitor);
            }
            catch (CoreException e) {
                throw new CoreException(ProjectCore.createErrorStatus((Exception)((Object)e)));
            }
        }
        if (projectRecord.liferayProjectDir != null) {
            try {
                project = ProjectUtil.createNewSDKProject(projectRecord, runtime, sdkLocation, op, monitor);
            }
            catch (CoreException e) {
                throw new CoreException(ProjectCore.createErrorStatus((Exception)((Object)e)));
            }
        }
        return project;
    }

    public static boolean isValidLiferayPlugin(File binaryFile) {
        boolean isValid = false;
        JarFile pluginBinary = null;
        try {
            pluginBinary = new JarFile(binaryFile);
            BinaryProjectRecord tempRecord = new BinaryProjectRecord(binaryFile);
            JarEntry lfrPluginPkgPropsEntry = pluginBinary.getJarEntry(ProjectImportUtil.getConfigFileLocation("liferay-plugin-package.properties"));
            JarEntry lfrPluginPkgXmlEntry = pluginBinary.getJarEntry(ProjectImportUtil.getConfigFileLocation("liferay-plugin-package.xml"));
            if (lfrPluginPkgPropsEntry != null || lfrPluginPkgXmlEntry != null) {
                isValid = true;
            }
            if (tempRecord.isHook()) {
                isValid = isValid && pluginBinary.getJarEntry(ProjectImportUtil.getConfigFileLocation("liferay-hook.xml")) != null;
            } else if (tempRecord.isLayoutTpl()) {
                isValid = isValid || pluginBinary.getJarEntry(ProjectImportUtil.getConfigFileLocation("liferay-layout-templates.xml")) != null;
            } else if (tempRecord.isPortlet()) {
                isValid = isValid && pluginBinary.getJarEntry(ProjectImportUtil.getConfigFileLocation("liferay-portlet.xml")) != null;
            } else if (tempRecord.isTheme()) {
                boolean bl = isValid = isValid || pluginBinary.getJarEntry(ProjectImportUtil.getConfigFileLocation("liferay-look-and-feel.xml")) != null;
            }
            if (!isValid) {
                boolean bl = isValid;
                return bl;
            }
            try {
                isValid = isValid || pluginBinary.getJarEntry(ProjectImportUtil.getConfigFileLocation("web.xml")) != null;
            }
            catch (IOException e) {
                isValid = false;
            }
        }
        finally {
            if (pluginBinary != null) {
                try {
                    pluginBinary.close();
                }
                catch (IOException iOException) {}
            }
        }
        return isValid;
    }

    public static IStatus validateSDKPath(String currentPath) {
        IStatus retVal = ProjectImportUtil.validatePath(currentPath);
        if (retVal.isOK()) {
            IPath osPath = Path.fromOSString((String)currentPath);
            SDK sdk = SDKUtil.createSDKFromLocation((IPath)osPath);
            if (sdk != null) {
                try {
                    IProject workspaceSdkProject = SDKUtil.getWorkspaceSDKProject();
                    if (workspaceSdkProject != null && !workspaceSdkProject.getLocation().equals((Object)sdk.getLocation())) {
                        return ProjectCore.createErrorStatus("This project has different sdk than current workspace sdk");
                    }
                }
                catch (CoreException e) {
                    return ProjectCore.createErrorStatus("Can't find sdk in workspace");
                }
                retVal = sdk.validate();
            } else {
                retVal = ProjectCore.createErrorStatus("SDK does not exist.");
            }
        }
        return retVal;
    }

    public static IStatus validateSDKProjectPath(String currentPath) {
        IStatus retVal = ProjectImportUtil.validatePath(currentPath);
        if (retVal.isOK()) {
            ProjectRecord record = ProjectUtil.getProjectRecordForDir(currentPath);
            if (record != null) {
                String projectName = record.getProjectName();
                IProject existingProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (existingProject != null && existingProject.exists()) {
                    retVal = ProjectCore.createErrorStatus("Project name already exists.");
                } else {
                    File projectDir = record.getProjectLocation().toFile();
                    SDK sdk = SDKUtil.getSDKFromProjectDir((File)projectDir);
                    if (sdk != null) {
                        try {
                            IProject workspaceSdkProject = SDKUtil.getWorkspaceSDKProject();
                            if (workspaceSdkProject != null && !workspaceSdkProject.getLocation().equals((Object)sdk.getLocation())) {
                                return ProjectCore.createErrorStatus("This project has different sdk than current workspace sdk");
                            }
                        }
                        catch (CoreException e) {
                            return ProjectCore.createErrorStatus("Can't find sdk in workspace");
                        }
                        retVal = sdk.validate(true);
                    } else {
                        retVal = ProjectCore.createErrorStatus("Could not determine SDK from project location " + currentPath);
                    }
                }
            } else {
                retVal = ProjectCore.createErrorStatus("Invalid project location");
            }
        }
        return retVal;
    }

    public static IStatus validatePath(String currentPath) {
        if (!Path.EMPTY.isValidPath(currentPath)) {
            return ProjectCore.createErrorStatus("\"" + currentPath + "\" is not a valid path.");
        }
        IPath osPath = Path.fromOSString((String)currentPath);
        if (!osPath.toFile().isAbsolute()) {
            return ProjectCore.createErrorStatus("\"" + currentPath + "\" is not an absolute path.");
        }
        if (!osPath.toFile().exists()) {
            return ProjectCore.createErrorStatus("Directory doesn't exist.");
        }
        return Status.OK_STATUS;
    }

    private static class Msgs
    extends NLS {
        public static String checking;
        public static String creatingSDKWorkspaceProjects;

        static {
            Msgs.initializeMessages((String)ProjectImportUtil.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

