/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.util;

import com.liferay.ide.project.core.ProjectCore;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceFilterDescription;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ResourceFilterUtil {
    public static void addResourceFilter(IFolder folder, String filteredSubFolderName, IProgressMonitor monitor) {
        String pre = "1.0-name-matches-true-false-";
        boolean shouldAdd = true;
        IResourceFilterDescription[] resourceFilterDescriptions = null;
        try {
            resourceFilterDescriptions = folder.getFilters();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (resourceFilterDescriptions != null) {
            IResourceFilterDescription[] iResourceFilterDescriptionArray = resourceFilterDescriptions;
            int n = resourceFilterDescriptions.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceFilterDescription resourceFilterDescription = iResourceFilterDescriptionArray[n2];
                String argument = resourceFilterDescription.getFileInfoMatcherDescription().getArguments().toString();
                String projectName = argument.substring(argument.indexOf(pre) + pre.length(), argument.length());
                if (projectName.equals(filteredSubFolderName)) {
                    shouldAdd = false;
                    break;
                }
                ++n2;
            }
        }
        if (shouldAdd) {
            try {
                FileInfoMatcherDescription fmd = new FileInfoMatcherDescription("org.eclipse.ui.ide.multiFilter", (Object)(String.valueOf(pre) + filteredSubFolderName));
                folder.createFilter(10, fmd, 128, monitor);
            }
            catch (CoreException e) {
                ProjectCore.logError("add " + filteredSubFolderName + " filter error", (Exception)((Object)e));
            }
        }
    }

    public static void deleteResourceFilter(IFolder parentFolder, String filteredSubFolderName) {
        try {
            IResourceFilterDescription[] resourceFilterDescriptions;
            IResourceFilterDescription[] iResourceFilterDescriptionArray = resourceFilterDescriptions = parentFolder.getFilters();
            int n = resourceFilterDescriptions.length;
            int n2 = 0;
            while (n2 < n) {
                final IResourceFilterDescription resourceFilterDescription = iResourceFilterDescriptionArray[n2];
                Object argument = resourceFilterDescription.getFileInfoMatcherDescription().getArguments();
                if (argument.toString().contains(filteredSubFolderName)) {
                    WorkspaceJob job = new WorkspaceJob("delete project resource filter"){

                        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                            try {
                                resourceFilterDescription.delete(128, monitor);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            ProjectCore.logError("delete filter error", (Exception)((Object)e));
        }
    }
}

