/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.workspace;

import com.liferay.ide.project.core.workspace.NewLiferayWorkspaceOp;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class WorkspaceLocationValidationService
extends ValidationService {
    private boolean canCreate(File file) {
        while (!file.exists()) {
            if ((file = file.getParentFile()) != null) continue;
            return false;
        }
        return file.canWrite();
    }

    protected Status compute() {
        Status retval = Status.createOkStatus();
        org.eclipse.sapphire.modeling.Path currentProjectLocation = (org.eclipse.sapphire.modeling.Path)this.op().getLocation().content(true);
        String currentWorkspaceName = (String)this.op().getWorkspaceName().content();
        if (!((Boolean)this.op().getUseDefaultLocation().content(true)).booleanValue() && currentWorkspaceName != null) {
            if (currentProjectLocation != null) {
                String currentPath = currentProjectLocation.append(currentWorkspaceName).toOSString();
                IPath osPath = Path.fromOSString((String)currentPath);
                if (!osPath.toFile().isAbsolute()) {
                    return Status.createErrorStatus((String)("\"" + currentPath + "\" is not an absolute path."));
                }
                if (!this.canCreate(osPath.toFile())) {
                    return Status.createErrorStatus((String)("Cannot create project content at \"" + currentPath + "\"."));
                }
            } else {
                return Status.createErrorStatus((String)"Location must be specified.");
            }
        }
        return retval;
    }

    private NewLiferayWorkspaceOp op() {
        return (NewLiferayWorkspaceOp)this.context(NewLiferayWorkspaceOp.class);
    }
}

