/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.workspace;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import com.liferay.ide.project.core.util.ValidationUtil;
import com.liferay.ide.project.core.workspace.NewLiferayWorkspaceOp;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.services.ValidationService;

public class WorkspaceNameValidationService
extends ValidationService {
    private static final String PROJECT_NAME_REGEX = "[A-Za-z0-9_\\-.]+";
    private Listener listener;

    protected Status compute() {
        Status retval = Status.createOkStatus();
        try {
            if (LiferayWorkspaceUtil.hasWorkspace()) {
                retval = Status.createErrorStatus((String)LiferayWorkspaceUtil.hasLiferayWorkspaceMsg);
                return retval;
            }
        }
        catch (CoreException e) {
            return StatusBridge.create((IStatus)e.getStatus());
        }
        NewLiferayWorkspaceOp op = this.op();
        String currentWorkspaceName = (String)op.getWorkspaceName().content();
        if (CoreUtil.isNullOrEmpty((String)currentWorkspaceName)) {
            return Status.createErrorStatus((String)"Liferay Workspace project name could not be empty.");
        }
        IStatus nameStatus = CoreUtil.getWorkspace().validateName(currentWorkspaceName, 4);
        if (!nameStatus.isOK()) {
            return StatusBridge.create((IStatus)nameStatus);
        }
        if (!this.isValidProjectName(currentWorkspaceName)) {
            return Status.createErrorStatus((String)"The name is invalid for a project.");
        }
        if (ValidationUtil.isExistingProjectName(currentWorkspaceName)) {
            return Status.createErrorStatus((String)"A project with that name(ignore case) already exists.");
        }
        if (this.isExistingFolder(op, currentWorkspaceName)) {
            return Status.createErrorStatus((String)"Target project folder is not empty.");
        }
        return retval;
    }

    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.op().getLocation().detach(this.listener);
            this.listener = null;
        }
    }

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                WorkspaceNameValidationService.this.refresh();
            }
        };
        this.op().getLocation().attach(this.listener);
    }

    private boolean isExistingFolder(NewLiferayWorkspaceOp op, String projectName) {
        File targetDir;
        Path location = (Path)op.getLocation().content();
        return location != null && (targetDir = location.append(projectName).toFile()).exists() && targetDir.list().length > 0;
    }

    private boolean isValidProjectName(String currentProjectName) {
        return currentProjectName.matches(PROJECT_NAME_REGEX);
    }

    private NewLiferayWorkspaceOp op() {
        return (NewLiferayWorkspaceOp)this.context(NewLiferayWorkspaceOp.class);
    }
}

