/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui;

import com.liferay.ide.core.LiferayNature;
import com.liferay.ide.project.ui.ProjectUI;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.osgi.framework.Bundle;

public class LiferayPluginProjectDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    private static final String EXT_FACET = "liferay.ext";
    private static final String HOOK_FACET = "liferay.hook";
    private static final String ICON_DIR = "icons/ovr";
    private static final String LAYOUTTPL_FACET = "liferay.layouttpl";
    private static ImageDescriptor LIFERAY;
    private static final String PORTLET_FACET = "liferay.portlet";
    private static final String THEME_FACET = "liferay.theme";
    private static final String WEB_FACET = "liferay.web";

    private static ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor imageDescriptor = null;
        if (key != null) {
            String gif = "/" + key + ".png";
            IPath path = new Path(ICON_DIR).append(gif);
            URL gifImageURL = FileLocator.find((Bundle)Platform.getBundle((String)"com.liferay.ide.project.ui"), (IPath)path, null);
            if (gifImageURL != null) {
                imageDescriptor = ImageDescriptor.createFromURL((URL)gifImageURL);
            }
        }
        return imageDescriptor;
    }

    private static ImageDescriptor getLiferay() {
        if (LIFERAY == null) {
            LIFERAY = LiferayPluginProjectDecorator.getImageDescriptor("liferay_decoration");
        }
        return LIFERAY;
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            ImageDescriptor overlay = null;
            if (this.hasFacet(project, PORTLET_FACET)) {
                overlay = LiferayPluginProjectDecorator.getLiferay();
            } else if (this.hasFacet(project, HOOK_FACET)) {
                overlay = LiferayPluginProjectDecorator.getLiferay();
            } else if (this.hasFacet(project, EXT_FACET)) {
                overlay = LiferayPluginProjectDecorator.getLiferay();
            } else if (this.hasFacet(project, LAYOUTTPL_FACET)) {
                overlay = LiferayPluginProjectDecorator.getLiferay();
            } else if (this.hasFacet(project, THEME_FACET)) {
                overlay = LiferayPluginProjectDecorator.getLiferay();
            } else if (this.hasFacet(project, WEB_FACET)) {
                overlay = LiferayPluginProjectDecorator.getLiferay();
            } else if (LiferayNature.hasNature((IProject)project)) {
                overlay = LiferayPluginProjectDecorator.getLiferay();
            }
            if (overlay != null) {
                decoration.addOverlay(overlay, 1);
            }
        }
    }

    private boolean hasFacet(IProject project, String facet) {
        try {
            return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)facet);
        }
        catch (CoreException e) {
            ProjectUI.logError((Exception)((Object)e));
            return false;
        }
    }
}

