/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.handlers;

import com.liferay.ide.project.core.ProjectCore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IModificationDate;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractCompareFileHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        IStatus retval = Status.OK_STATUS;
        IFile currentFile = null;
        if (selection instanceof ITreeSelection) {
            Object firstElement = ((ITreeSelection)selection).getFirstElement();
            if (firstElement instanceof IFile) {
                currentFile = (IFile)firstElement;
            }
        } else if (selection instanceof TextSelection) {
            IEditorPart editor = window.getActivePage().getActiveEditor();
            currentFile = (IFile)editor.getEditorInput().getAdapter(IFile.class);
        }
        retval = this.openCompareEditor(window, currentFile);
        return retval;
    }

    private IStatus openCompareEditor(IWorkbenchWindow window, IFile currentFile) {
        IWorkbenchPage workBenchPage = window.getActivePage();
        CompareItem left = null;
        CompareItem right = null;
        IStatus retval = Status.OK_STATUS;
        try {
            File tempFile = this.getTemplateFile(currentFile);
            if (tempFile == null) {
                return ProjectCore.createErrorStatus((String)"Can't find the original file.");
            }
            left = new CompareItem(tempFile);
            right = new CompareItem(currentFile.getLocation().toFile());
            this.openInCompare(left, right, workBenchPage);
        }
        catch (Exception e) {
            retval = ProjectCore.createErrorStatus((Exception)e);
        }
        return retval;
    }

    private void openInCompare(final ITypedElement left, final ITypedElement right, IWorkbenchPage workBenchPage) {
        CompareConfiguration configuration = new CompareConfiguration();
        configuration.setLeftLabel("Template");
        configuration.setRightLabel(((CompareItem)right).getFile().getAbsolutePath());
        CompareUI.openCompareEditor((CompareEditorInput)new CompareEditorInput(configuration){

            protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                DiffNode diffNode = new DiffNode(left, right);
                return diffNode;
            }
        });
    }

    protected abstract File getTemplateFile(IFile var1) throws Exception;

    private class CompareItem
    implements ITypedElement,
    IStreamContentAccessor,
    IModificationDate,
    IEditableContent {
        private File file;

        public CompareItem(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public String getName() {
            return null;
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return null;
        }

        public long getModificationDate() {
            return 0L;
        }

        public InputStream getContents() throws CoreException {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }

        public boolean isEditable() {
            return false;
        }

        public void setContent(byte[] newContent) {
        }

        public ITypedElement replace(ITypedElement dest, ITypedElement src) {
            return null;
        }
    }
}

