/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.migration;

import com.liferay.blade.api.Migration;
import com.liferay.blade.api.Problem;
import com.liferay.blade.api.ProgressMonitor;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.core.util.MarkerUtil;
import com.liferay.ide.project.core.upgrade.FileProblems;
import com.liferay.ide.project.core.upgrade.FileProblemsUtil;
import com.liferay.ide.project.core.upgrade.IgnoredProblemsContainer;
import com.liferay.ide.project.core.upgrade.MigrationProblems;
import com.liferay.ide.project.core.upgrade.UpgradeAssistantSettingsUtil;
import com.liferay.ide.project.core.upgrade.UpgradeProblems;
import com.liferay.ide.project.core.util.ValidationUtil;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.migration.CUCache;
import com.liferay.ide.project.ui.migration.MigrationContentProvider;
import com.liferay.ide.project.ui.migration.MigrationProblemsContainer;
import com.liferay.ide.project.ui.migration.MigrationUtil;
import com.liferay.ide.project.ui.upgrade.animated.FindBreakingChangesPage;
import com.liferay.ide.project.ui.upgrade.animated.Page;
import com.liferay.ide.project.ui.upgrade.animated.UpgradeView;
import com.liferay.ide.ui.util.UIUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class MigrateProjectHandler
extends AbstractHandler {
    private String[] ignoreSuperClasses = new String[]{"com.liferay.portal.service.BaseLocalServiceImpl", "com.liferay.portal.model.CacheModel", "com.liferay.portal.model.impl.BaseModelImpl", "com.liferay.portal.service.BaseServiceImpl", "com.liferay.portal.service.persistence.impl.BasePersistenceImpl", "com.liferay.portal.NoSuchModelException", "com.liferay.portal.model.PersistedModel", "com.liferay.portal.model.BaseModel", "com.liferay.portal.model.StagedGroupedModel", "com.liferay.portal.model.ModelWrapper", "com.liferay.portal.service.BaseLocalService", "com.liferay.portal.service.InvokableLocalService", "com.liferay.portal.service.PersistedModelLocalService", "com.liferay.portal.service.ServiceWrapper", "com.liferay.portal.service.BaseService", "com.liferay.portal.service.InvokableService", "com.liferay.portal.kernel.messaging.BaseMessageListener", "com.liferay.portal.kernel.dao.orm.BaseActionableDynamicQuery", "com.liferay.portal.service.persistence.BasePersistence"};

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            Object element = null;
            element = ((IStructuredSelection)selection).size() > 1 ? ((IStructuredSelection)selection).toArray() : ((IStructuredSelection)selection).getFirstElement();
            IProject project = null;
            IProject[] projects = null;
            if (element instanceof IProject) {
                project = (IProject)element;
            } else if (element instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)element;
                project = (IProject)adaptable.getAdapter(IProject.class);
            } else if (element instanceof Object[]) {
                projects = (IProject[])Arrays.copyOf(element, ((Object[])element).length, IProject[].class);
            }
            if (project != null) {
                if (this.shouldShowMessageDialog(project)) {
                    boolean shouldContinue = this.showMessageDialog(project);
                    if (!shouldContinue) {
                        return null;
                    }
                    MarkerUtil.clearMarkers((IResource)project, (String)"com.liferay.ide.project.core.MigrationProblemMarker", null);
                }
                IPath location = project.getLocation();
                this.findMigrationProblems(new IPath[]{location}, new String[]{project.getName()});
            } else if (projects != null) {
                ArrayList<IPath> locations = new ArrayList<IPath>();
                ArrayList<String> projectNames = new ArrayList<String>();
                boolean shouldContinue = false;
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject iProject = iProjectArray[n2];
                    if (!shouldContinue && this.shouldShowMessageDialog(iProject) && !(shouldContinue = this.showMessageDialog(project))) {
                        return null;
                    }
                    if (shouldContinue && this.shouldShowMessageDialog(iProject)) {
                        MarkerUtil.clearMarkers((IResource)iProject, (String)"com.liferay.ide.project.core.MigrationProblemMarker", null);
                    }
                    locations.add(iProject.getLocation());
                    projectNames.add(iProject.getName());
                    ++n2;
                }
                this.findMigrationProblems(locations.toArray(new IPath[0]), projectNames.toArray(new String[0]));
            }
        }
        return null;
    }

    public void findMigrationProblems(IPath[] locations) {
        this.findMigrationProblems(locations, new String[]{""});
    }

    public void findMigrationProblems(final IPath[] locations, final String[] projectName) {
        WorkspaceJob job = new WorkspaceJob("Finding migration problems..."){

            public IStatus runInWorkspace(final IProgressMonitor monitor) throws CoreException {
                IStatus retval = Status.OK_STATUS;
                BundleContext context = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
                ProgressMonitor override = new ProgressMonitor(){

                    public void worked(int work) {
                        monitor.worked(work);
                    }

                    public void setTaskName(String taskName) {
                        monitor.setTaskName(taskName);
                    }

                    public boolean isCanceled() {
                        return monitor.isCanceled();
                    }

                    public void done() {
                        monitor.done();
                    }

                    public void beginTask(String taskName, int totalWork) {
                        monitor.beginTask(taskName, totalWork);
                    }
                };
                try {
                    ServiceReference sr = context.getServiceReference(Migration.class);
                    Migration m = (Migration)context.getService(sr);
                    ArrayList<Problem> allProblems = null;
                    boolean isSingleFile = locations.length == 1 && locations[0].toFile().exists() && locations[0].toFile().isFile();
                    int j = 0;
                    while (j < locations.length) {
                        allProblems = new ArrayList<Problem>();
                        if (!override.isCanceled()) {
                            List problems = null;
                            if (isSingleFile) {
                                MigrateProjectHandler.this.clearFileMarkers(locations[j].toFile());
                                HashSet<File> files = new HashSet<File>();
                                files.add(locations[j].toFile());
                                problems = m.findProblems(files, override);
                            } else {
                                problems = m.findProblems(locations[j].toFile(), override);
                            }
                            for (Problem problem : problems) {
                                if (!MigrateProjectHandler.this.shouldAdd(problem)) continue;
                                allProblems.add(problem);
                            }
                        }
                        MigrationProblemsContainer container = null;
                        container = (MigrationProblemsContainer)UpgradeAssistantSettingsUtil.getObjectFromStore(MigrationProblemsContainer.class);
                        MigrationProblems[] migrationProblemsArray = null;
                        ArrayList<MigrationProblems> migrationProblemsList = new ArrayList<MigrationProblems>();
                        if (container == null) {
                            container = new MigrationProblemsContainer();
                        }
                        if (container.getProblemsArray() != null) {
                            migrationProblemsArray = container.getProblemsArray();
                        }
                        if (migrationProblemsArray != null) {
                            List<MigrationProblems> mpList = Arrays.asList(migrationProblemsArray);
                            for (MigrationProblems mp : mpList) {
                                migrationProblemsList.add(mp);
                            }
                        }
                        if (allProblems.size() > 0) {
                            MigrateProjectHandler.this.addMarkers(allProblems);
                            MigrationProblems migrationProblems = new MigrationProblems();
                            List fileProblemsList = FileProblemsUtil.newFileProblemsListFrom((Problem[])allProblems.toArray(new Problem[0]));
                            migrationProblems.setProblems(fileProblemsList.toArray(new FileProblems[0]));
                            migrationProblems.setType("Code Problems");
                            migrationProblems.setSuffix(projectName[j]);
                            int index = MigrateProjectHandler.this.isAlreadyExist(migrationProblemsList, projectName, j);
                            if (index != -1) {
                                if (isSingleFile) {
                                    UpgradeProblems up = (UpgradeProblems)migrationProblemsList.get(index);
                                    FileProblems[] problems = up.getProblems();
                                    int n = 0;
                                    while (n < problems.length) {
                                        FileProblems fp = problems[n];
                                        if (fp.getFile().getPath().equals(locations[0].toFile().getPath())) {
                                            problems[n] = (FileProblems)fileProblemsList.get(0);
                                            break;
                                        }
                                        ++n;
                                    }
                                    migrationProblems.setProblems(problems);
                                }
                                migrationProblemsList.set(index, migrationProblems);
                            } else {
                                migrationProblemsList.add(migrationProblems);
                            }
                        } else {
                            int index = MigrateProjectHandler.this.isAlreadyExist(migrationProblemsList, projectName, j);
                            if (index != -1) {
                                if (isSingleFile) {
                                    MigrationProblems mp;
                                    mp = (MigrationProblems)migrationProblemsList.get(index);
                                    FileProblems[] fps = mp.getProblems();
                                    List<FileProblems> fpList = Arrays.asList(fps);
                                    ArrayList<FileProblems> newFPList = new ArrayList<FileProblems>();
                                    for (FileProblems fp : fpList) {
                                        if (fp.getFile().getPath().equals(locations[0].toFile().getPath())) continue;
                                        newFPList.add(fp);
                                    }
                                    mp.setProblems(newFPList.toArray(new FileProblems[0]));
                                    migrationProblemsList.set(index, mp);
                                } else {
                                    migrationProblemsList.remove(index);
                                }
                            }
                        }
                        if (migrationProblemsList.size() > 0) {
                            container.setProblemsArray(migrationProblemsList.toArray(new MigrationProblems[0]));
                            UpgradeAssistantSettingsUtil.setObjectToStore(MigrationProblemsContainer.class, (Object)container);
                        } else {
                            UpgradeAssistantSettingsUtil.setObjectToStore(MigrationProblemsContainer.class, null);
                        }
                        ++j;
                    }
                    if (isSingleFile) {
                        MigrateProjectHandler.this.refreshViewer(allProblems);
                    } else {
                        allProblems.add(new Problem());
                        m.reportProblems(allProblems, 4, "ide", new Object[0]);
                    }
                }
                catch (Exception e) {
                    retval = ProjectUI.createErrorStatus("Error in migrate command", e);
                }
                return retval;
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().showInDialog(Display.getDefault().getActiveShell(), (Job)job);
        }
        catch (Exception exception) {
            // empty catch block
        }
        job.schedule();
    }

    private boolean showMessageDialog(IProject project) {
        Display display = Display.getDefault();
        Shell shell = display.getActiveShell();
        return MessageDialog.openConfirm((Shell)shell, (String)"Migrate Liferay Plugin", (String)"This project already contains migration problem markers.  All existing markers will be deleted.  Do you want to continue to run migration tool?");
    }

    private boolean shouldShowMessageDialog(IProject project) {
        IMarker[] markers = MarkerUtil.findMarkers((IResource)project, (String)"com.liferay.ide.project.core.MigrationProblemMarker", null);
        return markers != null && markers.length > 0;
    }

    private boolean shouldAdd(Problem problem) {
        Set ticketSet;
        File file = problem.getFile();
        String path = file.getAbsolutePath().replaceAll("\\\\", "/");
        if (path.contains("WEB-INF/classes") || path.contains("WEB-INF/service") || ValidationUtil.isProjectTargetDirFile((File)file)) {
            return false;
        }
        IgnoredProblemsContainer ignoredProblemsContainer = MigrationUtil.getIgnoredProblemsContainer();
        if (ignoredProblemsContainer != null && (ticketSet = ignoredProblemsContainer.getProblemMap().keySet()) != null && ticketSet.contains(problem.getTicket())) {
            IResource resource = MigrationUtil.getIResourceFromProblem(problem);
            IMarker marker = resource.getMarker(problem.getMarkerId());
            if (marker.exists()) {
                try {
                    marker.delete();
                }
                catch (CoreException e) {
                    ProjectUI.logError((Exception)((Object)e));
                }
            }
            return false;
        }
        if (path.endsWith("java")) {
            CompilationUnit ast = CUCache.getCU(problem.getFile(), FileUtil.readContents((File)problem.getFile()).toCharArray());
            Name superClass = ((TypeDeclaration)ast.types().get(0)).getSuperclass();
            if (superClass != null) {
                return !this.checkClassIgnore(ast, superClass.toString());
            }
            List interfaces = ((TypeDeclaration)ast.types().get(0)).superInterfaces();
            if (interfaces != null) {
                for (ASTNode n : interfaces) {
                    String name = n.toString();
                    if (!this.checkClassIgnore(ast, name)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkClassIgnore(CompilationUnit ast, String className) {
        List importDeclarationList = ast.imports();
        if (importDeclarationList != null) {
            String fullClassName = "";
            for (ImportDeclaration importDeclaration : importDeclarationList) {
                String importName = importDeclaration.getName().toString();
                if (!importName.endsWith(className)) continue;
                fullClassName = importName;
                break;
            }
            if (!fullClassName.equals("")) {
                String[] stringArray = this.ignoreSuperClasses;
                int n = this.ignoreSuperClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    String ignoreSuperClass = stringArray[n2];
                    if (ignoreSuperClass.equals(fullClassName)) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    private int isAlreadyExist(List<MigrationProblems> migrationProblemsList, String[] projectName, int projectIndex) {
        int index = -1;
        int i = 0;
        while (i < migrationProblemsList.size()) {
            UpgradeProblems upgradeProblems = (UpgradeProblems)migrationProblemsList.get(i);
            if (((MigrationProblems)upgradeProblems).getSuffix().equals(projectName[projectIndex])) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private void clearFileMarkers(File file) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IPath location = Path.fromOSString((String)file.getAbsolutePath());
        IFile projectFile = ws.getRoot().getFileForLocation(location);
        if (projectFile.exists() && projectFile != null) {
            MarkerUtil.clearMarkers((IResource)projectFile, (String)"com.liferay.ide.project.core.MigrationProblemMarker", null);
        }
    }

    protected void refreshViewer(final List<Problem> allProblems) {
        FindBreakingChangesPage page = UpgradeView.getPage(Page.FINDBREACKINGCHANGES_PAGE_ID, FindBreakingChangesPage.class);
        final TableViewer problemsViewer = page.get_problemsViewer();
        final TreeViewer treeViewer = page.getTreeViewer();
        UIUtil.async((Runnable)new Runnable(){

            @Override
            public void run() {
                problemsViewer.setInput((Object)allProblems);
                Object currentTreeNode = treeViewer.getStructuredSelection().getFirstElement();
                String currentPath = null;
                if (currentTreeNode instanceof FileProblems) {
                    FileProblems currentNode = (FileProblems)currentTreeNode;
                    currentPath = currentNode.getFile().getAbsolutePath().toString();
                }
                MigrationContentProvider contentProvider = (MigrationContentProvider)treeViewer.getContentProvider();
                MigrationProblemsContainer mc = (MigrationProblemsContainer)contentProvider._problems.get(0);
                MigrationProblems[] migrationProblemsArray = mc.getProblemsArray();
                int n = migrationProblemsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MigrationProblems project = migrationProblemsArray[n2];
                    for (FileProblems fileProblem : new LinkedList<FileProblems>(Arrays.asList(project.getProblems()))) {
                        if (!fileProblem.getFile().getAbsolutePath().toString().equals(currentPath)) continue;
                        fileProblem.getProblems().clear();
                        fileProblem.getProblems().addAll(allProblems);
                        break;
                    }
                    ++n2;
                }
            }
        });
    }

    private void addMarkers(List<Problem> problems) {
        IWorkspaceRoot ws = ResourcesPlugin.getWorkspace().getRoot();
        for (Problem problem : problems) {
            IContainer workspaceResource = null;
            File file = problem.file;
            IContainer[] containers = ws.findContainersForLocationURI(file.toURI());
            if (containers != null && containers.length > 0) {
                IContainer container;
                IContainer[] iContainerArray = containers;
                int n = containers.length;
                int n2 = 0;
                while (n2 < n) {
                    container = iContainerArray[n2];
                    if (container.exists()) {
                        if (container.getType() == 4) {
                            workspaceResource = container;
                            break;
                        }
                        IProject project = container.getProject();
                        if (CoreUtil.isLiferayProject((IProject)project)) {
                            workspaceResource = container;
                            break;
                        }
                    }
                    ++n2;
                }
                if (workspaceResource == null) {
                    IFile[] files;
                    IFile[] iFileArray = files = ws.findFilesForLocationURI(file.toURI());
                    int n3 = files.length;
                    n = 0;
                    while (n < n3) {
                        IFile ifile = iFileArray[n];
                        if (ifile.exists()) {
                            if (workspaceResource == null) {
                                if (CoreUtil.isLiferayProject((IProject)ifile.getProject())) {
                                    workspaceResource = ifile;
                                }
                            } else if (ifile.getFullPath().segmentCount() < workspaceResource.getFullPath().segmentCount()) {
                                workspaceResource = ifile;
                            }
                        }
                        ++n;
                    }
                }
                if (workspaceResource == null) {
                    iContainerArray = containers;
                    n = containers.length;
                    int n4 = 0;
                    while (n4 < n) {
                        container = iContainerArray[n4];
                        if (workspaceResource == null) {
                            workspaceResource = container;
                        } else if (container.getLocation().segmentCount() < workspaceResource.getLocation().segmentCount()) {
                            workspaceResource = container;
                        }
                        ++n4;
                    }
                }
            }
            if (workspaceResource == null || !workspaceResource.exists()) continue;
            try {
                IMarker marker = workspaceResource.createMarker("com.liferay.ide.project.core.MigrationProblemMarker");
                problem.setMarkerId(marker.getId());
                MigrationUtil.problemToMarker(problem, marker);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }
}

