/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.modules.fragment.action;

import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.fragment.NewModuleFragmentOp;
import com.liferay.ide.project.core.modules.fragment.OverrideFilePath;
import com.liferay.ide.project.ui.modules.fragment.action.OSGiBundleFileSelectionDialog;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.core.portal.PortalBundle;
import com.liferay.ide.server.util.ServerUtil;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.forms.PropertyEditorActionHandler;
import org.eclipse.wst.server.core.IRuntime;

public class AddFilesFromOSGiBundleAction
extends PropertyEditorActionHandler {
    protected boolean computeEnablementState() {
        boolean enabled = false;
        NewModuleFragmentOp op = (NewModuleFragmentOp)this.getModelElement().nearest(NewModuleFragmentOp.class);
        String hostOsgiBundle = (String)op.getHostOsgiBundle().content();
        if (hostOsgiBundle != null) {
            enabled = true;
        }
        return enabled;
    }

    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        final Element element = this.getModelElement();
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                AddFilesFromOSGiBundleAction.this.refreshEnablementState();
            }
        };
        element.attach((Listener)listener, NewModuleFragmentOp.PROP_HOST_OSGI_BUNDLE.name());
        this.attach(new Listener((Listener)listener){
            private final /* synthetic */ Listener val$listener;
            {
                this.val$listener = listener;
            }

            public void handle(Event event) {
                if (event instanceof DisposeEvent) {
                    element.detach(this.val$listener, NewModuleFragmentOp.PROP_HOST_OSGI_BUNDLE.name());
                }
            }
        });
    }

    protected Object run(Presentation context) {
        NewModuleFragmentOp op = (NewModuleFragmentOp)context.part().getModelElement().nearest(NewModuleFragmentOp.class);
        ElementList currentFiles = op.getOverrideFiles();
        String projectName = (String)op.getProjectName().content();
        OSGiBundleFileSelectionDialog dialog = new OSGiBundleFileSelectionDialog(null, (ElementList<OverrideFilePath>)currentFiles, projectName);
        String runtimeName = (String)op.getLiferayRuntimeName().content();
        IRuntime runtime = ServerUtil.getRuntime((String)runtimeName);
        IPath temp = ProjectCore.getDefault().getStateLocation();
        dialog.setTitle("Add files from OSGi bundle to override");
        PortalBundle portalBundle = LiferayServerCore.newPortalBundle((IPath)runtime.getLocation());
        String currentOSGiBundle = (String)op.getHostOsgiBundle().content();
        if (!currentOSGiBundle.endsWith("jar")) {
            currentOSGiBundle = String.valueOf(currentOSGiBundle) + ".jar";
        }
        ServerUtil.getModuleFileFrom70Server((IRuntime)runtime, (String)currentOSGiBundle, (IPath)temp);
        if (portalBundle != null) {
            try {
                File module = portalBundle.getOSGiBundlesDir().append("modules").append(currentOSGiBundle).toFile();
                if (!module.exists()) {
                    module = ProjectCore.getDefault().getStateLocation().append(currentOSGiBundle).toFile();
                }
                dialog.setInput(module);
            }
            catch (Exception module) {
                // empty catch block
            }
        }
        if (dialog.open() == 0) {
            Object[] selected = dialog.getResult();
            int i = 0;
            while (i < selected.length) {
                OverrideFilePath file = (OverrideFilePath)op.getOverrideFiles().insert();
                file.setValue(selected[i].toString());
                ++i;
            }
        }
        return Status.createOkStatus();
    }
}

