/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.pref;

import com.liferay.blade.api.Problem;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.upgrade.IgnoredProblemsContainer;
import com.liferay.ide.project.core.upgrade.UpgradeAssistantSettingsUtil;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.migration.MigrationUtil;
import com.liferay.ide.ui.util.UIUtil;
import java.io.IOException;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MigrationProblemPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.liferay.ide.project.ui.migrationProblemPreferencePage";
    private TableViewer _ignoredProblemTable;
    private Button _removeButton;
    private Label _detailInfoLabel;
    private Browser _browser;
    private IgnoredProblemsContainer mpContainer;

    public Control createContents(Composite parent) {
        Composite pageComponent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pageComponent.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        pageComponent.setLayoutData((Object)data);
        data = new GridData(768);
        Label label = new Label(pageComponent, 16384);
        label.setText("These are ignored breaking change problems.\n You can remove them if you want to show this type of problem next time.");
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this._ignoredProblemTable = new TableViewer(pageComponent, 67586);
        data = new GridData(768);
        this.createColumns(this._ignoredProblemTable);
        Table table = this._ignoredProblemTable.getTable();
        table.setHeaderVisible(true);
        data.heightHint = 200;
        this._ignoredProblemTable.getTable().setLayoutData((Object)data);
        this._ignoredProblemTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Composite groupComponent = new Composite(pageComponent, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.marginWidth = 0;
        groupLayout.marginHeight = 0;
        groupComponent.setLayout((Layout)groupLayout);
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        this._removeButton = new Button(groupComponent, 8);
        this._removeButton.setText("Remove");
        this._removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                StructuredSelection selection = (StructuredSelection)MigrationProblemPreferencePage.this._ignoredProblemTable.getSelection();
                if (selection != null && selection.getFirstElement() instanceof Problem) {
                    try {
                        Problem problem = (Problem)selection.getFirstElement();
                        MigrationProblemPreferencePage.this.mpContainer.remove(problem);
                        MigrationProblemPreferencePage.this._ignoredProblemTable.setInput((Object)MigrationProblemPreferencePage.this.mpContainer.getProblemMap().values().toArray(new Problem[0]));
                    }
                    catch (Exception e) {
                        ProjectUI.logError(e);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.setButtonLayoutData(this._removeButton);
        label = new Label(pageComponent, 16384);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this._detailInfoLabel = new Label(pageComponent, 16384);
        this._detailInfoLabel.setText("Detail Information");
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        this._detailInfoLabel.setLayoutData((Object)data);
        this._browser = new Browser(pageComponent, 2048);
        data = new GridData(1808);
        this._browser.setLayoutData((Object)data);
        groupComponent = new Composite(pageComponent, 0);
        groupLayout = new GridLayout();
        groupLayout.marginWidth = 0;
        groupLayout.marginHeight = 0;
        groupComponent.setLayout((Layout)groupLayout);
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        this.fillIgnoredProblemTable();
        this._ignoredProblemTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(final SelectionChangedEvent event) {
                UIUtil.async((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MigrationProblemPreferencePage.this.updateForm(event);
                    }
                }, (long)50L);
            }
        });
        return pageComponent;
    }

    public void init(IWorkbench arg0) {
        this.mpContainer = MigrationUtil.getIgnoredProblemsContainer();
    }

    public boolean performOk() {
        try {
            UpgradeAssistantSettingsUtil.setObjectToStore(IgnoredProblemsContainer.class, (Object)this.mpContainer);
        }
        catch (IOException e) {
            ProjectUI.logError(e);
        }
        return super.performOk();
    }

    private void fillIgnoredProblemTable() {
        try {
            IgnoredProblemsContainer mpContainer = (IgnoredProblemsContainer)UpgradeAssistantSettingsUtil.getObjectFromStore(IgnoredProblemsContainer.class);
            if (mpContainer != null) {
                Problem[] problems = mpContainer.getProblemMap().values().toArray(new Problem[0]);
                this._ignoredProblemTable.setInput((Object)problems);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createColumns(final TableViewer _problemsViewer) {
        String[] titles = new String[]{"Tickets", "Problem"};
        int[] bounds = new int[]{65, 55};
        TableViewerColumn col = this.createTableViewerColumn(titles[0], bounds[0], _problemsViewer);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Problem p = (Problem)element;
                return p.getTicket();
            }
        });
        col = this.createTableViewerColumn(titles[1], bounds[1], _problemsViewer);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Problem p = (Problem)element;
                return p.getTitle();
            }

            public void update(ViewerCell cell) {
                super.update(cell);
                Table table = _problemsViewer.getTable();
                table.getColumn(1).pack();
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, TableViewer viewer) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    private void updateForm(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        Problem problem = MigrationUtil.getProblemFromSelection(selection);
        if (problem != null) {
            if (CoreUtil.isNullOrEmpty((String)problem.html)) {
                this._browser.setText(this.generateFormText(problem));
            } else {
                this._browser.setText(problem.html);
            }
        } else {
            this._browser.setUrl("about:blank");
        }
    }

    private String generateFormText(Problem problem) {
        StringBuilder sb = new StringBuilder();
        sb.append("<form><p>");
        sb.append("<b>Problem:</b> " + problem.title + "<br/><br/>");
        sb.append("<b>Description:</b><br/>");
        sb.append("\t" + problem.summary + "<br/><br/>");
        if (problem.getAutoCorrectContext() != null && problem.autoCorrectContext.length() > 0) {
            sb.append("<a href='autoCorrect'>Correct this problem automatically</a><br/><br/>");
        }
        if (problem.html != null && problem.html.length() > 0) {
            sb.append("<a href='html'>See documentation for how to correct this problem.</a><br/><br/>");
        }
        if (problem.ticket != null && problem.ticket.length() > 0) {
            sb.append("<b>Tickets:</b> " + this.getLinkTags(problem.ticket) + "<br/><br/>");
        }
        sb.append("</p></form>");
        return sb.toString();
    }

    private String getLinkTags(String ticketNumbers) {
        String[] ticketNumberArray = ticketNumbers.split(",");
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < ticketNumberArray.length) {
            String ticketNumber = ticketNumberArray[i];
            sb.append("<a href='https://issues.liferay.com/browse/");
            sb.append(ticketNumber);
            sb.append("'>");
            sb.append(ticketNumber);
            sb.append("</a>");
            if (ticketNumberArray.length > 1 && i != ticketNumberArray.length - 1) {
                sb.append(",");
            }
            ++i;
        }
        return sb.toString();
    }
}

