/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.quickfix;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.project.core.IProjectBuilder;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.ServiceContainer;
import com.liferay.ide.project.core.util.TargetPlatformUtil;
import com.liferay.ide.project.ui.ProjectUI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.jdt.ui.text.java.correction.CUCorrectionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Version;

public class LiferayDependencyQuickFix
implements IQuickFixProcessor {
    public boolean hasCorrections(ICompilationUnit unit, int problemId) {
        switch (problemId) {
            case 0x1000002: 
            case 268435846: {
                return true;
            }
        }
        return false;
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        if (locations == null || locations.length == 0) {
            return null;
        }
        ArrayList<IJavaCompletionProposal> resultingCollections = new ArrayList<IJavaCompletionProposal>();
        int i = 0;
        while (i < locations.length) {
            IProblemLocation curr = locations[i];
            List<IJavaCompletionProposal> newProposals = this.process(context, curr);
            for (IJavaCompletionProposal newProposal : newProposals) {
                boolean existed = false;
                for (IJavaCompletionProposal existedProposal : resultingCollections) {
                    if (!existedProposal.getDisplayString().equals(newProposal.getDisplayString())) continue;
                    existed = true;
                }
                if (existed) continue;
                resultingCollections.add(newProposal);
            }
            ++i;
        }
        return resultingCollections.toArray(new IJavaCompletionProposal[resultingCollections.size()]);
    }

    private List<IJavaCompletionProposal> process(IInvocationContext context, IProblemLocation problem) {
        int id = problem.getProblemId();
        if (id == 0) {
            return null;
        }
        List<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        switch (id) {
            case 268435846: {
                proposals = this.processImportNotFoundProposals(context, problem);
                break;
            }
            case 0x1000002: {
                proposals = this.processUndefinedTypeProposals(context, problem);
            }
        }
        return proposals;
    }

    private List<IJavaCompletionProposal> processImportNotFoundProposals(IInvocationContext context, IProblemLocation problem) {
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode == null) {
            return null;
        }
        ImportDeclaration importDeclaration = (ImportDeclaration)ASTNodes.getParent((ASTNode)selectedNode, (int)26);
        if (importDeclaration == null) {
            return null;
        }
        String importName = importDeclaration.getName().toString();
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        try {
            ServiceContainer bundle;
            List serviceWrapperList = TargetPlatformUtil.getServiceWrapperList().getServiceList();
            List servicesList = TargetPlatformUtil.getServicesList().getServiceList();
            if (serviceWrapperList.contains(importName)) {
                bundle = TargetPlatformUtil.getServiceWrapperBundle((String)importName);
                proposals.add(this.createDepProposal(context, bundle));
            }
            if (servicesList.contains(importName)) {
                bundle = TargetPlatformUtil.getServiceBundle((String)importName);
                proposals.add(this.createDepProposal(context, bundle));
            }
            if (TargetPlatformUtil.getThirdPartyBundleList((String)importName) != null) {
                bundle = TargetPlatformUtil.getThirdPartyBundleList((String)importName);
                proposals.add(this.createDepProposal(context, bundle));
            }
        }
        catch (Exception e) {
            ProjectCore.logError((String)"Error processing import not found proposals", (Exception)e);
        }
        return proposals;
    }

    private List<IJavaCompletionProposal> processUndefinedTypeProposals(IInvocationContext context, IProblemLocation problem) {
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        String fullyQualifiedName = null;
        if (selectedNode instanceof Name) {
            Name node = (Name)selectedNode;
            fullyQualifiedName = node.getFullyQualifiedName();
        }
        boolean depWrapperCanFixed = false;
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        try {
            ServiceContainer bundle;
            List serviceWrapperList = TargetPlatformUtil.getServiceWrapperList().getServiceList();
            List servicesList = TargetPlatformUtil.getServicesList().getServiceList();
            for (String wrapper : serviceWrapperList) {
                if (!wrapper.endsWith(fullyQualifiedName)) continue;
                bundle = TargetPlatformUtil.getServiceWrapperBundle((String)wrapper);
                proposals.add(this.createDepProposal(context, bundle));
            }
            if (!depWrapperCanFixed) {
                for (String service : servicesList) {
                    if (!service.endsWith(fullyQualifiedName)) continue;
                    bundle = TargetPlatformUtil.getServiceBundle((String)service);
                    proposals.add(this.createDepProposal(context, bundle));
                }
            }
        }
        catch (Exception e) {
            ProjectCore.logError((String)"Error processing undefined type proposals", (Exception)e);
        }
        return proposals;
    }

    private IJavaCompletionProposal createDepProposal(final IInvocationContext context, ServiceContainer bundle) {
        final String bundleGroup = bundle.getBundleGroup();
        final String bundleName = bundle.getBundleName();
        final String bundleVersion = bundle.getBundleVersion();
        return new CUCorrectionProposal("Add module dependency " + bundleName, context.getCompilationUnit(), null, 0){

            public void apply(IDocument document) {
                try {
                    IJavaProject javaProject = context.getCompilationUnit().getJavaProject();
                    IProject project = javaProject.getProject();
                    ILiferayProject liferayProject = LiferayCore.create((Object)project);
                    IProjectBuilder builder = (IProjectBuilder)liferayProject.adapt(IProjectBuilder.class);
                    if (builder != null) {
                        Version retriveVersion = new Version(bundleVersion);
                        String[] dependency = new String[]{bundleGroup, bundleName, String.valueOf(retriveVersion.getMajor()) + "." + retriveVersion.getMinor() + ".0"};
                        ArrayList<String[]> dependencyList = new ArrayList<String[]>();
                        dependencyList.add(dependency);
                        builder.updateProjectDependency(project, dependencyList);
                    }
                }
                catch (Exception e) {
                    ProjectUI.logError("Error adding module dependency", e);
                }
            }

            public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
                return "Add module dependency";
            }

            public Image getImage() {
                return ProjectUI.getDefault().getImageRegistry().get("module.dependency.image");
            }
        };
    }
}

