/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.upgrade.CodeUpgradeOp;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.ui.dialog.CustomProjectSelectionDialog;
import com.liferay.ide.project.ui.upgrade.CustomJspConverter;
import com.liferay.ide.server.util.ServerUtil;
import com.liferay.ide.ui.util.SWTUtil;
import com.liferay.ide.ui.util.UIUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.BufferedContent;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IModificationDate;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntime;

public class ConvertedProjectTreesPart
extends FormComponentPart {
    public FormComponentPresentation createPresentation(SwtPresentation parent, Composite composite) {
        return new ConvertedProjectTreesPresentation(this, parent, composite);
    }

    public class ConvertedProjectTreesPresentation
    extends FormComponentPresentation {
        private String compareType70;
        private String compareType62;
        private Image imageFile;
        private Image imageFolder;
        private Image imageProject;
        private TreeViewer leftTreeViewer;
        private TreeViewer rightTreeViewer;
        private String staticPath;

        public ConvertedProjectTreesPresentation(FormComponentPart part, SwtPresentation parent, Composite composite) {
            super(part, parent, composite);
            this.compareType70 = "7.x";
            this.compareType62 = "6.2";
            this.staticPath = "/src/main/resources/META-INF/resources/";
        }

        public void compare(String originalFile, String changedFile, String compareType) {
            CompareConfiguration config = new CompareConfiguration();
            config.setLeftEditable(false);
            config.setLeftLabel(String.valueOf(compareType) + " original jsp");
            config.setRightEditable(true);
            config.setRightLabel("custom jsp");
            CompareEditorInput editorInput = new CompareEditorInput(config, originalFile, changedFile){
                CompareItem originalItem;
                CompareItem changedItem;
                {
                    this.originalItem = new CompareItem(string);
                    this.changedItem = new CompareItem(string2);
                }

                protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    return new DiffNode((ITypedElement)this.originalItem, (ITypedElement)this.changedItem);
                }

                public void saveChanges(IProgressMonitor pm) throws CoreException {
                    super.saveChanges(pm);
                    this.changedItem.writeFile();
                }
            };
            editorInput.setTitle("Jsp File Compare");
            CompareUI.openCompareEditor((CompareEditorInput)editorInput);
        }

        private void createChildren(Composite container) {
            this.createImages();
            this.createLeftPart(container);
            this.createRightPart(container);
        }

        private Image createImage(String symbolicName) {
            Image image = PlatformUI.getWorkbench().getSharedImages().getImage(symbolicName);
            if (image.isDisposed()) {
                image = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(symbolicName).createImage();
            }
            return image;
        }

        private void createImages() {
            this.imageProject = this.createImage("IMG_OBJ_PROJECT");
            this.imageFolder = this.createImage("IMG_OBJ_FOLDER");
            this.imageFile = this.createImage("IMG_OBJ_FILE");
        }

        private void createLeftPart(Composite parent) {
            ScrolledComposite leftContainer = new ScrolledComposite(parent, 768);
            Composite leftPart = SWTUtil.createComposite((Composite)leftContainer, (int)1, (int)0, (int)1808);
            leftContainer.setLayout((Layout)new FillLayout());
            leftContainer.setMinSize(410, 200);
            leftContainer.setExpandHorizontal(true);
            leftContainer.setExpandVertical(true);
            leftContainer.setContent((Control)leftPart);
            Label leftLabel = new Label(leftPart, 0);
            leftLabel.setText("6.2 Custom JSPs (double-click to compare with original)");
            this.leftTreeViewer = new TreeViewer(leftPart, 2816);
            GridData gd = new GridData(4, 4, true, true);
            this.leftTreeViewer.getTree().setLayoutData((Object)gd);
            this.leftTreeViewer.setContentProvider((IContentProvider)new ViewContentProvider());
            this.leftTreeViewer.setLabelProvider((IBaseLabelProvider)new LeftViewLabelProvider());
            this.leftTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    ISelection selection = event.getSelection();
                    File file = (File)((ITreeSelection)selection).getFirstElement();
                    if (file.isDirectory()) {
                        return;
                    }
                    if (ConvertedProjectTreesPresentation.this.is62FileFound(file)) {
                        String[] paths = ConvertedProjectTreesPresentation.this.get62FilePaths(file);
                        ConvertedProjectTreesPresentation.this.compare(paths[0], paths[1], ConvertedProjectTreesPresentation.this.compareType62);
                    } else {
                        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"file not found", (String)"there is no such file in liferay 62");
                    }
                }
            });
            this.leftTreeViewer.setSorter(new ViewerSorter(){

                public int category(Object element) {
                    File file = (File)element;
                    if (file.isDirectory()) {
                        return -1;
                    }
                    return super.category(element);
                }
            });
        }

        private void createRightPart(Composite parent) {
            ScrolledComposite rightContainer = new ScrolledComposite(parent, 768);
            Composite rightPart = SWTUtil.createComposite((Composite)rightContainer, (int)1, (int)0, (int)1808);
            rightContainer.setLayout((Layout)new FillLayout());
            rightContainer.setMinSize(410, 200);
            rightContainer.setExpandHorizontal(true);
            rightContainer.setExpandVertical(true);
            rightContainer.setContent((Control)rightPart);
            Label rightLabel = new Label(rightPart, 0);
            rightLabel.setText("New JSP (double-click to compare with original)");
            this.rightTreeViewer = new TreeViewer(rightPart, 2816);
            GridData gd = new GridData(4, 4, true, true);
            this.rightTreeViewer.getTree().setLayoutData((Object)gd);
            this.rightTreeViewer.setContentProvider((IContentProvider)new ViewContentProvider());
            this.rightTreeViewer.setLabelProvider((IBaseLabelProvider)new RightViewLabelProvider());
            this.rightTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    ISelection selection = event.getSelection();
                    File file = (File)((ITreeSelection)selection).getFirstElement();
                    if (file.isDirectory()) {
                        return;
                    }
                    if (ConvertedProjectTreesPresentation.this.is70FileFound(file)) {
                        String[] paths = ConvertedProjectTreesPresentation.this.get70FilePaths(file);
                        ConvertedProjectTreesPresentation.this.compare(paths[0], paths[1], ConvertedProjectTreesPresentation.this.compareType70);
                    } else {
                        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"file not found", (String)"there is no such file in liferay 7");
                    }
                }
            });
            this.rightTreeViewer.setSorter(new ViewerSorter(){

                public int category(Object element) {
                    File file = (File)element;
                    if (file.isDirectory()) {
                        return -1;
                    }
                    return super.category(element);
                }
            });
        }

        private String[] get62FilePaths(File file) {
            String filePath = file.getAbsolutePath();
            IFile iFile = CoreUtil.getWorkspaceRoot().getFileForLocation(Path.fromOSString((String)filePath));
            IProject project = iFile.getProject();
            String projectPath = project.getLocation().toOSString();
            String customJsp = CustomJspConverter.getCustomJspPath(projectPath);
            java.nio.file.Path customJspPath = project.getFolder("docroot/" + customJsp).getLocation().toFile().toPath();
            java.nio.file.Path relativePath = customJspPath.relativize(file.toPath());
            String[] paths = new String[]{null, filePath};
            File original62JspFile = new File(String.valueOf(this.getLiferay62ServerLocation()) + "/tomcat-7.0.42/webapps/ROOT/" + relativePath.toString());
            if (original62JspFile.exists()) {
                paths[0] = original62JspFile.getAbsolutePath();
            }
            return paths;
        }

        private String[] get70FilePaths(File file) {
            String filePath = file.getAbsolutePath();
            IFile iFile = CoreUtil.getWorkspaceRoot().getFileForLocation(Path.fromOSString((String)filePath));
            IFolder resourceFolder = iFile.getProject().getFolder(this.staticPath);
            java.nio.file.Path resourcePath = resourceFolder.getLocation().toFile().toPath();
            java.nio.file.Path relativePath = resourcePath.relativize(file.toPath());
            String[] paths = new String[]{null, filePath};
            IFile original70File = resourceFolder.getFile("/.ignore/" + relativePath.toString());
            if (original70File.exists()) {
                paths[0] = original70File.getLocation().toOSString();
            }
            return paths;
        }

        private List<IProject> getHookProjects() {
            IProject[] projects;
            ArrayList<IProject> results = new ArrayList<IProject>();
            IProject[] iProjectArray = projects = CoreUtil.getAllProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (ProjectUtil.isHookProject((IProject)project)) {
                    results.add(project);
                }
                ++n2;
            }
            return results;
        }

        private File[] getLeftTreeInputs() {
            String[] results = CustomJspConverter.getConvertResult(CustomJspConverter.sourcePrefix);
            if (results == null) {
                return null;
            }
            int size = results.length;
            File[] files = new File[size];
            int i = 0;
            while (i < size) {
                String[] contents = results[i].split(":");
                IProject project = CoreUtil.getProject((String)contents[0]);
                String customJspPath = contents[1];
                files[i] = project.getFolder("docroot/" + customJspPath).getLocation().toFile();
                ++i;
            }
            return files;
        }

        private String getLiferay62ServerLocation() {
            return (String)this.op().getLiferay62ServerLocation().content(true);
        }

        private IRuntime getLiferay70Runtime() {
            String serverName = (String)this.op().getLiferayServerName().content();
            return ServerUtil.getServer((String)serverName).getRuntime();
        }

        private File[] getRightTreeInputs() {
            String[] results = CustomJspConverter.getConvertResult(CustomJspConverter.resultPrefix);
            if (results == null) {
                return null;
            }
            int size = results.length;
            File[] files = new File[size];
            int i = 0;
            while (i < size) {
                File file;
                files[i] = file = new File(results[i], this.staticPath);
                ++i;
            }
            return files;
        }

        private boolean is62FileFound(File file) {
            String[] paths = this.get62FilePaths(file);
            return paths[0] != null;
        }

        private boolean is70FileFound(File file) {
            String[] paths = this.get70FilePaths(file);
            return paths[0] != null;
        }

        private CodeUpgradeOp op() {
            return (CodeUpgradeOp)ConvertedProjectTreesPart.this.getLocalModelElement().nearest(CodeUpgradeOp.class);
        }

        public void refreshTreeViews() {
            File[] leftInputs = this.getLeftTreeInputs();
            this.leftTreeViewer.setInput((Object)leftInputs);
            File[] rightInputs = this.getRightTreeInputs();
            this.rightTreeViewer.setInput((Object)rightInputs);
        }

        public void render() {
            Composite container = new Composite(this.composite(), 0);
            GridLayout gridLayout = new GridLayout(1, true);
            container.setLayout((Layout)gridLayout);
            GridData layoutData = new GridData(4, 4, true, true);
            layoutData.widthHint = 800;
            layoutData.heightHint = 600;
            container.setLayoutData((Object)layoutData);
            Composite buttonContainer = new Composite(container, 0);
            buttonContainer.setLayout((Layout)new GridLayout(2, true));
            Button selectButton = SWTUtil.createButton((Composite)buttonContainer, (String)"select projects");
            GridData buttonGridData = new GridData(16384, 16384, false, false);
            buttonGridData.widthHint = 130;
            buttonGridData.heightHint = 40;
            selectButton.setLayoutData((Object)buttonGridData);
            Button clearButton = SWTUtil.createButton((Composite)buttonContainer, (String)"clear results");
            clearButton.setLayoutData((Object)buttonGridData);
            selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConvertedProjectTreesPresentation.this.runConvertAction();
                }
            });
            clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CustomJspConverter.clearConvertResults();
                    ConvertedProjectTreesPresentation.this.refreshTreeViews();
                }
            });
            SashForm sashForm = new SashForm(container, 256);
            sashForm.setLayout((Layout)new GridLayout(1, false));
            GridData sashFormLayoutData = new GridData(1808);
            sashForm.setLayoutData((Object)sashFormLayoutData);
            this.createChildren((Composite)sashForm);
            sashForm.setWeights(new int[]{1, 1});
            this.refreshTreeViews();
        }

        private void runConvertAction() {
            int size;
            Object[] selectedProjects;
            CustomProjectSelectionDialog dialog = new CustomProjectSelectionDialog(UIUtil.getActiveShell());
            dialog.setProjects(this.getHookProjects());
            ArrayList<IProject> hookProjects = new ArrayList<IProject>();
            if (dialog.open() == 0 && (selectedProjects = dialog.getResult()) != null) {
                Object[] objectArray = selectedProjects;
                int n = selectedProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object project = objectArray[n2];
                    if (project instanceof IJavaProject) {
                        IJavaProject p = (IJavaProject)project;
                        hookProjects.add(p.getProject());
                    }
                    ++n2;
                }
            }
            if ((size = hookProjects.size()) < 1) {
                return;
            }
            String[] sourcePaths = new String[size];
            int i = 0;
            while (i < size) {
                sourcePaths[i] = ((IProject)hookProjects.get(i)).getLocation().toOSString();
                ++i;
            }
            CustomJspConverter converter = new CustomJspConverter();
            IRuntime liferay70Runtime = this.getLiferay70Runtime();
            String liferay62ServerLocation = this.getLiferay62ServerLocation();
            if (liferay70Runtime == null || CoreUtil.isNullOrEmpty((String)liferay62ServerLocation)) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"could not convert", (String)"countn't find liferay 70 or 62 server location");
                return;
            }
            converter.setLiferay70Runtime(liferay70Runtime);
        }

        private class CompareItem
        extends BufferedContent
        implements ITypedElement,
        IModificationDate,
        IEditableContent {
            private String fileName;
            private long time;

            public CompareItem(String fileName) {
                this.fileName = fileName;
                this.time = System.currentTimeMillis();
            }

            protected InputStream createStream() throws CoreException {
                try {
                    return new FileInputStream(new File(this.fileName));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return new ByteArrayInputStream(new byte[0]);
                }
            }

            public Image getImage() {
                return CompareUI.DESC_CTOOL_NEXT.createImage();
            }

            public long getModificationDate() {
                return this.time;
            }

            public String getName() {
                return this.fileName;
            }

            public String getType() {
                return "txt";
            }

            public boolean isEditable() {
                return true;
            }

            public ITypedElement replace(ITypedElement dest, ITypedElement src) {
                return null;
            }

            public void writeFile() {
                this.writeFile(this.fileName, this.getContent());
            }

            private void writeFile(String fileName, byte[] newContent) {
                FileOutputStream fos = null;
                try {
                    try {
                        File file = new File(fileName);
                        if (file.exists()) {
                            file.delete();
                        }
                        file.createNewFile();
                        fos = new FileOutputStream(file);
                        fos.write(newContent);
                        fos.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        try {
                            fos.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        fos = null;
                    }
                }
                finally {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    fos = null;
                }
            }
        }

        class LeftViewLabelProvider
        extends StyledCellLabelProvider {
            LeftViewLabelProvider() {
            }

            private String getFileName(File file) {
                String name = file.getName();
                File html = new File(file, "html");
                if (html.exists() && html.isDirectory()) {
                    IPath location = Path.fromOSString((String)file.getAbsolutePath());
                    IFile ifile = CoreUtil.getWorkspaceRoot().getFileForLocation(location);
                    return ifile.getProject().getName();
                }
                return name.isEmpty() ? file.getPath() : name;
            }

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                StyledString text = new StyledString();
                File file = (File)element;
                if (file.isDirectory()) {
                    text.append(this.getFileName(file));
                    File html = new File(file, "html");
                    if (html.exists() && html.isDirectory()) {
                        cell.setImage(ConvertedProjectTreesPresentation.this.imageProject);
                    } else {
                        cell.setImage(ConvertedProjectTreesPresentation.this.imageFolder);
                    }
                    String[] files = file.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return !name.startsWith(".");
                        }
                    });
                    if (files != null) {
                        text.append(" (" + files.length + ") ", StyledString.COUNTER_STYLER);
                    }
                } else {
                    cell.setImage(ConvertedProjectTreesPresentation.this.imageFile);
                    text.append(this.getFileName(file));
                    if (ConvertedProjectTreesPresentation.this.is62FileFound(file)) {
                        text.append("(found)", StyledString.COUNTER_STYLER);
                    } else {
                        text.append("(unfound)", StyledString.DECORATIONS_STYLER);
                    }
                }
                cell.setText(text.toString());
                cell.setStyleRanges(text.getStyleRanges());
                super.update(cell);
            }
        }

        class RightViewLabelProvider
        extends StyledCellLabelProvider {
            RightViewLabelProvider() {
            }

            private String getFileName(File file) {
                String name = file.getName();
                if (name.equals("resources")) {
                    IPath location = Path.fromOSString((String)file.getAbsolutePath());
                    IFile ifile = CoreUtil.getWorkspaceRoot().getFileForLocation(location);
                    return ifile.getProject().getName();
                }
                return name.isEmpty() ? file.getPath() : name;
            }

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                StyledString text = new StyledString();
                File file = (File)element;
                if (file.isDirectory()) {
                    text.append(this.getFileName(file));
                    if (file.getName().endsWith("resources")) {
                        cell.setImage(ConvertedProjectTreesPresentation.this.imageProject);
                    } else {
                        cell.setImage(ConvertedProjectTreesPresentation.this.imageFolder);
                    }
                    String[] files = file.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return !name.startsWith(".");
                        }
                    });
                    if (files != null) {
                        text.append(" (" + files.length + ") ", StyledString.COUNTER_STYLER);
                    }
                } else {
                    cell.setImage(ConvertedProjectTreesPresentation.this.imageFile);
                    text.append(this.getFileName(file));
                    if (ConvertedProjectTreesPresentation.this.is70FileFound(file)) {
                        text.append("(found)", StyledString.COUNTER_STYLER);
                    } else {
                        text.append("(unfound)", StyledString.DECORATIONS_STYLER);
                    }
                }
                cell.setText(text.toString());
                cell.setStyleRanges(text.getStyleRanges());
                super.update(cell);
            }
        }

        class ViewContentProvider
        implements ITreeContentProvider {
            ViewContentProvider() {
            }

            public void dispose() {
            }

            public Object[] getChildren(Object parentElement) {
                File file = (File)parentElement;
                Object[] files = file.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return !name.startsWith(".");
                    }
                });
                return files;
            }

            public Object[] getElements(Object inputElement) {
                return (File[])inputElement;
            }

            public Object getParent(Object element) {
                File file = (File)element;
                return file.getParentFile();
            }

            public boolean hasChildren(Object element) {
                File file = (File)element;
                return file.isDirectory();
            }

            public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            }
        }
    }
}

