/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade;

import com.liferay.ide.project.ui.ProjectUI;
import java.lang.reflect.Method;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetExpandRestoreAction;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetViewer;
import org.eclipse.ui.part.ViewPart;

public class UpgradeAssistantView
extends ViewPart {
    protected static final String ID = "com.liferay.ide.project.ui.upgradeView";
    private CheatSheetViewer _viewer;
    private boolean _actionBarContributed;
    private IMemento _memento;
    private CheatSheetExpandRestoreAction _expandRestoreAction;
    private Action _copyAction;

    void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager tbmanager = bars.getToolBarManager();
        this._expandRestoreAction = new CheatSheetExpandRestoreAction(Messages.COLLAPSE_ALL_BUT_CURRENT_TOOLTIP, false, this._viewer);
        this._copyAction = new Action("copy"){

            public void run() {
                UpgradeAssistantView.this._viewer.copy();
            }
        };
        this._copyAction.setEnabled(false);
        tbmanager.add((IAction)this._expandRestoreAction);
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this._copyAction);
        try {
            Method setExpandRestoreAction = CheatSheetViewer.class.getDeclaredMethod("setExpandRestoreAction", CheatSheetExpandRestoreAction.class);
            setExpandRestoreAction.setAccessible(true);
            setExpandRestoreAction.invoke((Object)this._viewer, this._expandRestoreAction);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._viewer.setCopyAction(this._copyAction);
    }

    public void createPartControl(Composite parent) {
        this._viewer = new CheatSheetViewer(false);
        this._viewer.createPartControl(parent);
        if (!this._actionBarContributed) {
            this._actionBarContributed = true;
        }
        if (this._memento != null) {
            this.restoreState(this._memento);
        } else {
            this.loadUpgradeSheet();
        }
    }

    private void loadUpgradeSheet() {
        this._viewer.setInput("liferay_7_upgrade", "Liferay 7.0 Upgrade", ProjectUI.getDefault().getBundle().getEntry("cheatsheets/liferay_7_upgrade/liferay_7_upgrade.xml"));
    }

    private void restoreState(IMemento memento) {
        IMemento input = memento.getChild("input");
        if (input == null) {
            this.loadUpgradeSheet();
        }
    }

    public void saveState(IMemento memento) {
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site);
        this._memento = memento;
    }

    public void setFocus() {
        if (this._viewer != null) {
            this._viewer.setFocus();
        }
    }
}

