/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade.animated;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.dialog.CustomProjectSelectionDialog;
import com.liferay.ide.project.ui.upgrade.CustomJspConverter;
import com.liferay.ide.project.ui.upgrade.animated.ConvertedProjectLocationValidationService;
import com.liferay.ide.project.ui.upgrade.animated.LiferayUpgradeDataModel;
import com.liferay.ide.project.ui.upgrade.animated.Page;
import com.liferay.ide.project.ui.upgrade.animated.PageValidateEvent;
import com.liferay.ide.server.util.ServerUtil;
import com.liferay.ide.ui.util.SWTUtil;
import com.liferay.ide.ui.util.UIUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.compare.BufferedContent;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IModificationDate;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.ValuePropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.ServerUIUtil;

public class CustomJspPage
extends Page {
    private static String defaultLocation;
    private Image imageFile;
    private Image imageFolder;
    private Image imageProject;
    private TreeViewer leftTreeViewer;
    private TreeViewer rightTreeViewer;
    private String staticPath = "/src/main/resources/META-INF/resources/";
    private boolean hasLiferayWorkspace = false;
    private Text projectLocation = null;
    private ConvertedProjectLocationValidationService convertedProjectLocationValidation = (ConvertedProjectLocationValidationService)this.dataModel.getConvertedProjectLocation().service(ConvertedProjectLocationValidationService.class);

    public CustomJspPage(Composite parent, int style, final LiferayUpgradeDataModel dataModel) {
        super(parent, style, dataModel, CUSTOMJSP_PAGE_ID, true);
        Composite container = new Composite((Composite)this, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(768));
        Label label = new Label(container, 0);
        label.setText("Converted Project Location:");
        this.projectLocation = new Text(container, 2048);
        this.projectLocation.setLayoutData((Object)new GridData(768));
        this.projectLocation.setForeground(this.getDisplay().getSystemColor(16));
        this.updateDefaultLocation();
        this.projectLocation.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                String input = ((Text)e.getSource()).getText();
                if (input.equals(defaultLocation)) {
                    CustomJspPage.this.projectLocation.setText("");
                }
                CustomJspPage.this.projectLocation.setForeground(CustomJspPage.this.getDisplay().getSystemColor(2));
            }

            public void focusLost(FocusEvent e) {
                String input = ((Text)e.getSource()).getText();
                if (CoreUtil.isNullOrEmpty((String)input)) {
                    CustomJspPage.this.projectLocation.setForeground(CustomJspPage.this.getDisplay().getSystemColor(16));
                    CustomJspPage.this.projectLocation.setText(defaultLocation);
                }
            }
        });
        this.projectLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                dataModel.setConvertedProjectLocation(CustomJspPage.this.projectLocation.getText());
            }
        });
        dataModel.setConvertedProjectLocation(this.projectLocation.getText());
        Button browseButton = new Button(container, 8);
        browseButton.setText("Browse...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(CustomJspPage.this.getShell());
                dd.setMessage("Select Converted Project Location");
                String selectedDir = dd.open();
                if (selectedDir != null) {
                    CustomJspPage.this.projectLocation.setText(selectedDir);
                }
            }
        });
        Composite buttonContainer = new Composite((Composite)this, 0);
        buttonContainer.setLayout((Layout)new GridLayout(3, false));
        GridData buttonGridData = new GridData(0x1000000, 0x1000000, true, true);
        buttonGridData.widthHint = 130;
        buttonGridData.heightHint = 35;
        dataModel.getConvertedProjectLocation().attach((Listener)new CustomJspFieldListener());
        dataModel.getConvertLiferayWorkspace().attach((Listener)new CustomJspFieldListener());
        Button selectButton = new Button(buttonContainer, 8);
        selectButton.setText("Select Projects");
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomJspPage.this.runConvertAction();
            }
        });
        Button refreshButton = new Button(buttonContainer, 8);
        refreshButton.setText("Refresh Results");
        refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomJspPage.this.refreshTreeViews();
            }
        });
        Button clearButton = new Button(buttonContainer, 8);
        clearButton.setText("Clear Results");
        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomJspConverter.clearConvertResults();
                CustomJspPage.this.refreshTreeViews();
            }
        });
        SashForm sashForm = new SashForm((Composite)this, 256);
        GridLayout sashLayout = new GridLayout(1, false);
        sashLayout.marginHeight = 0;
        sashLayout.marginWidth = 0;
        sashForm.setLayout((Layout)sashLayout);
        GridData sashFormLayoutData = new GridData(1808);
        sashForm.setLayoutData((Object)sashFormLayoutData);
        this.createChildren((Composite)sashForm);
        sashForm.setWeights(new int[]{1, 1});
        this.refreshTreeViews();
    }

    public void compare(String originalFilePath, String changedFilePath, String leftLabel, String rightLabel) {
        CompareConfiguration config = new CompareConfiguration();
        config.setLeftEditable(false);
        config.setLeftLabel(leftLabel);
        config.setRightEditable(false);
        config.setRightLabel(rightLabel);
        CompareEditorInput editorInput = new CompareEditorInput(config, originalFilePath, changedFilePath){
            CompareItem originalItem;
            CompareItem changedItem;
            {
                this.originalItem = new CompareItem(string);
                this.changedItem = new CompareItem(string2);
            }

            protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                return new DiffNode((ITypedElement)this.originalItem, (ITypedElement)this.changedItem);
            }

            public void saveChanges(IProgressMonitor pm) throws CoreException {
                super.saveChanges(pm);
                this.changedItem.writeFile();
            }
        };
        editorInput.setTitle("Compare ('" + originalFilePath + "'-'" + changedFilePath + "')");
        CompareUI.openCompareEditor((CompareEditorInput)editorInput);
    }

    private void createChildren(Composite container) {
        this.createImages();
        this.createLeftPart(container);
        this.createRightPart(container);
    }

    private Image createImage(String symbolicName) {
        Image image = PlatformUI.getWorkbench().getSharedImages().getImage(symbolicName);
        if (image.isDisposed()) {
            image = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(symbolicName).createImage();
        }
        return image;
    }

    private void createImages() {
        this.imageProject = this.createImage("IMG_OBJ_PROJECT");
        this.imageFolder = this.createImage("IMG_OBJ_FOLDER");
        this.imageFile = this.createImage("IMG_OBJ_FILE");
    }

    private void createLeftPart(Composite parent) {
        ScrolledComposite leftContainer = new ScrolledComposite(parent, 768);
        Composite leftPart = SWTUtil.createComposite((Composite)leftContainer, (int)1, (int)1, (int)1808, (int)0, (int)0);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        leftContainer.setLayout((Layout)layout);
        leftContainer.setMinSize(410, 200);
        leftContainer.setExpandHorizontal(true);
        leftContainer.setExpandVertical(true);
        leftContainer.setContent((Control)leftPart);
        Label leftLabel = new Label(leftPart, 0);
        leftLabel.setText("6.2 Custom JSPs (double-click to compare with 6.2)");
        this.leftTreeViewer = new TreeViewer(leftPart, 2816);
        GridData gd = new GridData(4, 4, true, true);
        this.leftTreeViewer.getTree().setLayoutData((Object)gd);
        this.leftTreeViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.leftTreeViewer.setLabelProvider((IBaseLabelProvider)new LeftViewLabelProvider());
        this.leftTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                File file = (File)((ITreeSelection)selection).getFirstElement();
                if (file.isDirectory()) {
                    return;
                }
                if (CustomJspPage.this.is62FileFound(file)) {
                    String[] paths = CustomJspPage.this.get62FilePaths(file);
                    CustomJspPage.this.compare(paths[0], paths[1], "6.2 original JSP", "custom JSP");
                } else {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"File not found", (String)"There is no such file in liferay 62");
                }
            }
        });
        this.leftTreeViewer.setSorter(new ViewerSorter(){

            public int category(Object element) {
                File file = (File)element;
                if (file.isDirectory()) {
                    return -1;
                }
                return super.category(element);
            }
        });
    }

    private void createRightPart(Composite parent) {
        ScrolledComposite rightContainer = new ScrolledComposite(parent, 768);
        Composite rightPart = SWTUtil.createComposite((Composite)rightContainer, (int)1, (int)1, (int)1808, (int)0, (int)0);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        rightContainer.setLayout((Layout)layout);
        rightContainer.setMinSize(410, 200);
        rightContainer.setExpandHorizontal(true);
        rightContainer.setExpandVertical(true);
        rightContainer.setContent((Control)rightPart);
        Label rightLabel = new Label(rightPart, 0);
        rightLabel.setText("New JSP (double-click to compare 6.2 with 7.x)");
        this.rightTreeViewer = new TreeViewer(rightPart, 2816);
        GridData gd = new GridData(4, 4, true, true);
        this.rightTreeViewer.getTree().setLayoutData((Object)gd);
        this.rightTreeViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.rightTreeViewer.setLabelProvider((IBaseLabelProvider)new RightViewLabelProvider());
        this.rightTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                File file = (File)((ITreeSelection)selection).getFirstElement();
                if (file.isDirectory()) {
                    return;
                }
                if (CustomJspPage.this.is70FileFound(file)) {
                    String[] paths = CustomJspPage.this.get70FilePaths(file);
                    CustomJspPage.this.compare(paths[0], paths[1], "6.2 original JSP", "New 7.x JSP in " + CoreUtil.getProject((File)file).getName());
                } else {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"file not found", (String)"there is no such file in liferay 7");
                }
            }
        });
        this.rightTreeViewer.setSorter(new ViewerSorter(){

            public int category(Object element) {
                File file = (File)element;
                if (file.isDirectory()) {
                    return -1;
                }
                return super.category(element);
            }
        });
    }

    private String[] get62FilePaths(File file) {
        String projectPath;
        String customJsp;
        String filePath = file.getAbsolutePath();
        IProject project = CoreUtil.getProject((File)file);
        IFolder folder = project.getFolder("docroot/" + (customJsp = CustomJspConverter.getCustomJspPath(projectPath = project.getLocation().toOSString())));
        if (!folder.exists()) {
            folder = project.getFolder("src/main/webapp/" + customJsp);
        }
        Path customJspPath = folder.getLocation().toFile().toPath();
        Path relativePath = customJspPath.relativize(file.toPath());
        String[] paths = new String[]{null, filePath};
        File original62JspFile = new File(String.valueOf(this.getLiferay62ServerRootDirPath(this.getLiferay62ServerLocation())) + relativePath.toString());
        if (original62JspFile.exists()) {
            paths[0] = original62JspFile.getAbsolutePath();
        }
        return paths;
    }

    private String[] get70FilePaths(File file) {
        IFolder resourceFolder = CoreUtil.getProject((File)file).getFolder(this.staticPath);
        Path resourcePath = resourceFolder.getLocation().toFile().toPath();
        Path relativePath = resourcePath.relativize(file.toPath());
        String[] paths = new String[2];
        IFile original62File = resourceFolder.getFile("/.ignore/" + relativePath.toString() + ".62");
        IFile original70File = resourceFolder.getFile(relativePath.toString());
        if (original62File.exists() && original70File.exists()) {
            paths[0] = original62File.getLocation().toPortableString();
            paths[1] = original70File.getLocation().toPortableString();
        }
        return paths;
    }

    private List<IProject> getHookProjects() {
        IProject[] projects;
        ArrayList<IProject> results = new ArrayList<IProject>();
        IProject[] iProjectArray = projects = CoreUtil.getAllProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            String projectLocation = project.getLocation().toPortableString();
            String customJsp = CustomJspConverter.getCustomJspPath(projectLocation);
            if (!CoreUtil.empty((String)customJsp)) {
                results.add(project);
            }
            ++n2;
        }
        return results;
    }

    private File[] getLeftTreeInputs() {
        String[] results = CustomJspConverter.getConvertResult(CustomJspConverter.sourcePrefix);
        if (results == null) {
            return null;
        }
        int size = results.length;
        ArrayList<File> list = new ArrayList<File>();
        int i = 0;
        while (i < size) {
            IPath location;
            String customJspPath;
            String[] contents = results[i].split(":");
            IProject project = CoreUtil.getProject((String)contents[0]);
            IFolder folder = project.getFolder("docroot/" + (customJspPath = contents[1]));
            if (!folder.exists()) {
                folder = project.getFolder("src/main/webapp/" + customJspPath);
            }
            if ((location = folder.getLocation()) != null) {
                list.add(location.toFile());
            }
            ++i;
        }
        if (!list.isEmpty()) {
            return list.toArray(new File[0]);
        }
        return null;
    }

    private String getLiferay62ServerLocation() {
        String liferay62ServerLocation = (String)this.dataModel.getLiferay62ServerLocation().content(true);
        if (liferay62ServerLocation == null) {
            Boolean openAddLiferaryServerDialog;
            Set liferayRuntimes = ServerUtil.getAvailableLiferayRuntimes();
            for (IRuntime liferayRuntime : liferayRuntimes) {
                if (!liferayRuntime.getRuntimeType().getId().startsWith("com.liferay.ide.server.62.")) continue;
                liferay62ServerLocation = liferayRuntime.getLocation().removeLastSegments(1).toString();
                return liferay62ServerLocation;
            }
            if (liferay62ServerLocation == null && (openAddLiferaryServerDialog = Boolean.valueOf(MessageDialog.openConfirm((Shell)UIUtil.getActiveShell(), (String)"Could not find Liferay 6.2 Runtime", (String)"This process requires Liferay 6.2 Runtime. Click OK to add Liferay 6.2 Runtime."))).booleanValue()) {
                ServerUIUtil.showNewRuntimeWizard((Shell)UIUtil.getActiveShell(), null, null, (String)"com.liferay.");
                return this.getLiferay62ServerLocation();
            }
        }
        return liferay62ServerLocation;
    }

    private String getLiferay62ServerRootDirPath(String serverLocation) {
        if (CoreUtil.empty((String)serverLocation)) {
            return null;
        }
        File bundleDir = new File(serverLocation);
        String[] names = bundleDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("tomcat-");
            }
        });
        if (names != null && names.length == 1) {
            return String.valueOf(serverLocation) + "/" + names[0] + "/webapps/ROOT/";
        }
        return null;
    }

    private IRuntime getLiferay70Runtime() {
        String serverName = (String)this.dataModel.getLiferay70ServerName().content();
        IServer server = ServerUtil.getServer((String)serverName);
        if (server != null) {
            return server.getRuntime();
        }
        IRuntime liferay70Runtime = this.getExistLiferay70Runtime();
        if (liferay70Runtime != null) {
            return liferay70Runtime;
        }
        Boolean openAddLiferaryServerDialog = MessageDialog.openConfirm((Shell)UIUtil.getActiveShell(), (String)"Could not find Liferay 7.x Runtime", (String)"This process requires 7.x Runtime. Click OK to add Liferay 7.x Runtime.");
        if (openAddLiferaryServerDialog.booleanValue()) {
            ServerUIUtil.showNewRuntimeWizard((Shell)UIUtil.getActiveShell(), (String)"liferay.bundle", null, (String)"com.liferay.");
            return this.getExistLiferay70Runtime();
        }
        return null;
    }

    private IRuntime getExistLiferay70Runtime() {
        Set liferayRuntimes = ServerUtil.getAvailableLiferayRuntimes();
        for (IRuntime liferayRuntime : liferayRuntimes) {
            if (!liferayRuntime.getRuntimeType().getId().equals("com.liferay.ide.server.portal.runtime") || !liferayRuntime.getLocation().toFile().exists()) continue;
            return liferayRuntime;
        }
        return null;
    }

    private File[] getRightTreeInputs() {
        String[] results = CustomJspConverter.getConvertResult(CustomJspConverter.resultPrefix);
        if (results == null) {
            return null;
        }
        int size = results.length;
        ArrayList<File> list = new ArrayList<File>();
        int i = 0;
        while (i < size) {
            File file = new File(results[i], this.staticPath);
            if (file.exists()) {
                list.add(file);
            }
            ++i;
        }
        if (!list.isEmpty()) {
            return list.toArray(new File[0]);
        }
        return null;
    }

    private boolean is62FileFound(File file) {
        String[] paths = this.get62FilePaths(file);
        return paths[0] != null;
    }

    private boolean is70FileFound(File file) {
        String[] paths = this.get70FilePaths(file);
        return paths[0] != null;
    }

    private void updateDefaultLocation() {
        defaultLocation = CoreUtil.getWorkspaceRoot().getLocation().toPortableString();
        try {
            this.hasLiferayWorkspace = LiferayWorkspaceUtil.hasWorkspace();
            if (this.hasLiferayWorkspace) {
                IProject ws = LiferayWorkspaceUtil.getWorkspaceProject();
                String modulesDir = LiferayWorkspaceUtil.getModulesDir((IProject)ws);
                defaultLocation = ws.getLocation().append(modulesDir).toPortableString();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        UIUtil.async((Runnable)new Runnable(){

            @Override
            public void run() {
                CustomJspPage.this.projectLocation.setText(defaultLocation);
            }
        });
    }

    public void refreshTreeViews() {
        File[] leftInputs = this.getLeftTreeInputs();
        this.leftTreeViewer.setInput((Object)leftInputs);
        File[] rightInputs = this.getRightTreeInputs();
        this.rightTreeViewer.setInput((Object)rightInputs);
    }

    private void runConvertAction() {
        int size;
        Object[] selectedProjects;
        CustomProjectSelectionDialog dialog = new CustomProjectSelectionDialog(UIUtil.getActiveShell());
        dialog.setProjects(this.getHookProjects());
        URL imageUrl = ProjectUI.getDefault().getBundle().getEntry("/icons/e16/hook.png");
        Image hookImage = ImageDescriptor.createFromURL((URL)imageUrl).createImage();
        dialog.setImage(hookImage);
        dialog.setTitle("Custom JSP Hook Project");
        dialog.setMessage("Select Custom JSP Hook Project");
        ArrayList<IProject> hookProjects = new ArrayList<IProject>();
        if (dialog.open() == 0 && (selectedProjects = dialog.getResult()) != null) {
            Object[] objectArray = selectedProjects;
            int n = selectedProjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object project = objectArray[n2];
                if (project instanceof IJavaProject) {
                    IJavaProject p = (IJavaProject)project;
                    hookProjects.add(p.getProject());
                }
                ++n2;
            }
        }
        if ((size = hookProjects.size()) < 1) {
            return;
        }
        String[] sourcePaths = new String[size];
        int i = 0;
        while (i < size) {
            sourcePaths[i] = ((IProject)hookProjects.get(i)).getLocation().toOSString();
            ++i;
        }
        CustomJspConverter converter = new CustomJspConverter();
        IRuntime liferay70Runtime = this.getLiferay70Runtime();
        if (liferay70Runtime == null) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Convert Error", (String)"Couldn't find Liferay 7.x Runtime.");
            return;
        }
        String liferay62ServerLocation = this.getLiferay62ServerLocation();
        if (liferay62ServerLocation == null) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Convert Error", (String)"Couldn't find Liferay 6.2 Runtime.");
            return;
        }
        converter.setLiferay70Runtime(liferay70Runtime);
        converter.setLiferay62ServerLocation(liferay62ServerLocation);
        converter.setUi(this);
        String targetPath = ((org.eclipse.sapphire.modeling.Path)this.dataModel.getConvertedProjectLocation().content()).toPortableString();
        boolean isLiferayWorkapce = false;
        if (targetPath.equals(defaultLocation) && this.hasLiferayWorkspace) {
            isLiferayWorkapce = true;
        }
        converter.doExecute(sourcePaths, targetPath, isLiferayWorkapce);
    }

    @Override
    public void createSpecialDescriptor(Composite parent, int style) {
        String descriptor = "This step will help you to convert projects with custom jsp hooks to modules or fragments.";
        String url = "";
        Link link = SWTUtil.createHyperLink((Composite)this, (int)style, (String)"This step will help you to convert projects with custom jsp hooks to modules or fragments.", (int)1, (String)url);
        link.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
    }

    @Override
    public String getPageTitle() {
        return "Convert Custom JSP Hooks";
    }

    private class CompareItem
    extends BufferedContent
    implements ITypedElement,
    IModificationDate,
    IEditableContent {
        private String fileName;
        private long time;

        public CompareItem(String fileName) {
            this.fileName = fileName;
            this.time = System.currentTimeMillis();
        }

        protected InputStream createStream() throws CoreException {
            try {
                return new FileInputStream(new File(this.fileName));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return new ByteArrayInputStream(new byte[0]);
            }
        }

        public Image getImage() {
            return CompareUI.DESC_CTOOL_NEXT.createImage();
        }

        public long getModificationDate() {
            return this.time;
        }

        public String getName() {
            return this.fileName;
        }

        public String getType() {
            return "txt";
        }

        public boolean isEditable() {
            return true;
        }

        public ITypedElement replace(ITypedElement dest, ITypedElement src) {
            return null;
        }

        public void writeFile() {
            this.writeFile(this.fileName, this.getContent());
        }

        private void writeFile(String fileName, byte[] newContent) {
            FileOutputStream fos = null;
            try {
                try {
                    File file = new File(fileName);
                    if (file.exists()) {
                        file.delete();
                    }
                    file.createNewFile();
                    fos = new FileOutputStream(file);
                    fos.write(newContent);
                    fos.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        fos.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    fos = null;
                }
            }
            finally {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                fos = null;
            }
        }
    }

    private class CustomJspFieldListener
    extends Listener {
        private CustomJspFieldListener() {
        }

        public void handle(Event event) {
            if (event instanceof ValuePropertyContentEvent) {
                ValuePropertyContentEvent propertyEvetn = (ValuePropertyContentEvent)event;
                Property property = propertyEvetn.property();
                Status validationStatus = Status.createOkStatus();
                if (property.name().equals("ConvertedProjectLocation")) {
                    validationStatus = CustomJspPage.this.convertedProjectLocationValidation.compute();
                    String message = "ok";
                    if (!validationStatus.ok()) {
                        message = validationStatus.message();
                    }
                    PageValidateEvent pe = new PageValidateEvent();
                    pe.setMessage(message);
                    pe.setType(PageValidateEvent.ERROR);
                    CustomJspPage.this.triggerValidationEvent(pe);
                } else if (property.name().equals("ConvertLiferayWorkspace") && ((Boolean)CustomJspPage.this.dataModel.getConvertLiferayWorkspace().content(true)).booleanValue()) {
                    CustomJspPage.this.updateDefaultLocation();
                }
            }
        }
    }

    class LeftViewLabelProvider
    extends StyledCellLabelProvider {
        LeftViewLabelProvider() {
        }

        private String getFileName(File file) {
            String name = file.getName();
            File html = new File(file, "html");
            if (html.exists() && html.isDirectory()) {
                return CoreUtil.getProject((File)html).getName();
            }
            return name.isEmpty() ? file.getPath() : name;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            StyledString text = new StyledString();
            File file = (File)element;
            if (file.isDirectory()) {
                text.append(this.getFileName(file));
                File html = new File(file, "html");
                if (html.exists() && html.isDirectory()) {
                    cell.setImage(CustomJspPage.this.imageProject);
                } else {
                    cell.setImage(CustomJspPage.this.imageFolder);
                }
                String[] files = file.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return !name.startsWith(".");
                    }
                });
                if (files != null) {
                    text.append(" (" + files.length + ") ", StyledString.COUNTER_STYLER);
                }
            } else {
                cell.setImage(CustomJspPage.this.imageFile);
                text.append(this.getFileName(file));
                if (CustomJspPage.this.is62FileFound(file)) {
                    text.append("(found)", StyledString.COUNTER_STYLER);
                } else {
                    text.append("(unfound)", StyledString.DECORATIONS_STYLER);
                }
            }
            cell.setText(text.toString());
            cell.setStyleRanges(text.getStyleRanges());
            super.update(cell);
        }
    }

    class RightViewLabelProvider
    extends StyledCellLabelProvider {
        RightViewLabelProvider() {
        }

        private String getFileName(File file) {
            String name = file.getName();
            if (name.equals("resources")) {
                return file.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getName();
            }
            return name.isEmpty() ? file.getPath() : name;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            StyledString text = new StyledString();
            File file = (File)element;
            if (file.isDirectory()) {
                text.append(this.getFileName(file));
                if (file.getName().endsWith("resources")) {
                    cell.setImage(CustomJspPage.this.imageProject);
                } else {
                    cell.setImage(CustomJspPage.this.imageFolder);
                }
                String[] files = file.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return !name.startsWith(".");
                    }
                });
                if (files != null) {
                    text.append(" (" + files.length + ") ", StyledString.COUNTER_STYLER);
                }
            } else {
                cell.setImage(CustomJspPage.this.imageFile);
                text.append(this.getFileName(file));
                if (CustomJspPage.this.is70FileFound(file)) {
                    text.append("(found)", StyledString.COUNTER_STYLER);
                } else {
                    text.append("(unfound)", StyledString.DECORATIONS_STYLER);
                }
            }
            cell.setText(text.toString());
            cell.setStyleRanges(text.getStyleRanges());
            super.update(cell);
        }
    }

    class ViewContentProvider
    implements ITreeContentProvider {
        ViewContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            File file = (File)parentElement;
            Object[] files = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return !name.startsWith(".");
                }
            });
            return files;
        }

        public Object[] getElements(Object inputElement) {
            return (File[])inputElement;
        }

        public Object getParent(Object element) {
            File file = (File)element;
            return file.getParentFile();
        }

        public boolean hasChildren(Object element) {
            File file = (File)element;
            return file.isDirectory();
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }
    }
}

