/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade.animated;

import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.core.util.SearchFilesVisitor;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.dialog.JavaProjectSelectionDialog;
import com.liferay.ide.project.ui.upgrade.animated.AbstractLiferayTableViewCustomPart;
import com.liferay.ide.project.ui.upgrade.animated.LiferayUpgradeDataModel;
import com.liferay.ide.ui.util.SWTUtil;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;

public class LayoutTemplatePage
extends AbstractLiferayTableViewCustomPart {
    public LayoutTemplatePage(Composite parent, int style, LiferayUpgradeDataModel dataModel) {
        super(parent, style, dataModel, LAYOUTTEMPLATE_PAGE_ID, true);
    }

    @Override
    public String getPageTitle() {
        return "Upgrade Layout Templates";
    }

    @Override
    public void createSpecialDescriptor(Composite parent, int style) {
        String descriptor = "This step will upgrade layout template files from 6.2 to 7.0.\nThe layout template's rows and columns are affected by the new grid system syntax of Bootstrap.\nFor more details, please see <a>Upgrading Layout Templates</a>.";
        String url = "https://dev.liferay.com/develop/tutorials/-/knowledge_base/7-0/upgrading-layout-templates";
        Link link = SWTUtil.createHyperLink((Composite)this, (int)style, (String)"This step will upgrade layout template files from 6.2 to 7.0.\nThe layout template's rows and columns are affected by the new grid system syntax of Bootstrap.\nFor more details, please see <a>Upgrading Layout Templates</a>.", (int)1, (String)url);
        link.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
    }

    @Override
    public int getGridLayoutCount() {
        return 2;
    }

    @Override
    public boolean getGridLayoutEqualWidth() {
        return false;
    }

    @Override
    protected void createTempFile(File srcFile, File templateFile, String projectName) {
        try {
            String content = this.upgradeLayouttplContent(FileUtil.readContents((File)srcFile, (boolean)true));
            if (templateFile.exists()) {
                templateFile.delete();
            }
            templateFile.createNewFile();
            FileUtil.writeFile((File)templateFile, (String)content, (String)projectName);
        }
        catch (Exception e) {
            ProjectUI.logError(e);
        }
    }

    @Override
    protected void doUpgrade(File srcFile, IProject project) {
        try {
            String content = this.upgradeLayouttplContent(FileUtil.readContents((File)srcFile, (boolean)true));
            FileUtils.writeStringToFile((File)srcFile, (String)content, (String)"UTF-8");
        }
        catch (Exception e) {
            ProjectUI.logError(e);
        }
    }

    @Override
    protected IFile[] getAvaiableUpgradeFiles(IProject project) {
        ArrayList files = new ArrayList();
        List searchFiles = new LayoutSearchFilesVistor().searchFiles((IResource)project, ".tpl");
        files.addAll(searchFiles);
        return files.toArray(new IFile[files.size()]);
    }

    @Override
    protected DelegatingStyledCellLabelProvider.IStyledLabelProvider getLableProvider() {
        return new AbstractLiferayTableViewCustomPart.LiferayUpgradeTabeViewLabelProvider(this, "Upgrade Layouttpl"){

            @Override
            public Image getImage(Object element) {
                return this.getImageRegistry().get("layout");
            }

            @Override
            protected void initalizeImageRegistry(ImageRegistry imageRegistry) {
                imageRegistry.put("layout", ProjectUI.imageDescriptorFromPlugin((String)"com.liferay.ide.project.ui", (String)"/icons/e16/layout.png"));
            }
        };
    }

    @Override
    protected List<IProject> getSelectedProjects() {
        Object[] selectedProjects;
        ArrayList<IProject> projects = new ArrayList<IProject>();
        JavaProjectSelectionDialog dialog = new JavaProjectSelectionDialog(Display.getCurrent().getActiveShell(), new LayoutProjectViewerFilter());
        URL imageUrl = ProjectUI.getDefault().getBundle().getEntry("/icons/e16/layout.png");
        Image layouttplImage = ImageDescriptor.createFromURL((URL)imageUrl).createImage();
        dialog.setImage(layouttplImage);
        dialog.setTitle("Layout Template Project");
        dialog.setMessage("Select Layout Template Project");
        if (dialog.open() == 0 && (selectedProjects = dialog.getResult()) != null) {
            Object[] objectArray = selectedProjects;
            int n = selectedProjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object project = objectArray[n2];
                if (project instanceof IJavaProject) {
                    IJavaProject p = (IJavaProject)project;
                    projects.add(p.getProject());
                }
                ++n2;
            }
        }
        return projects;
    }

    @Override
    protected boolean isNeedUpgrade(File srcFile) {
        String content = FileUtil.readContents((File)srcFile);
        return content != null && !content.equals("") && (content.contains("row-fluid") || content.contains("span"));
    }

    private String upgradeLayouttplContent(String content) {
        if (content != null && !content.equals("")) {
            if (content.contains("row-fluid")) {
                content = content.replaceAll("row-fluid", "row");
            }
            if (content.contains("span")) {
                content = content.replaceAll("span", "col-md-");
            }
        }
        return content;
    }

    private class LayoutProjectViewerFilter
    extends ViewerFilter {
        private LayoutProjectViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IJavaProject) {
                IProject project = ((IJavaProject)element).getProject();
                if (project.getName().equals("External Plug-in Libraries")) {
                    return false;
                }
                return ProjectUtil.isLayoutTplProject((IProject)project);
            }
            return false;
        }
    }

    private class LayoutSearchFilesVistor
    extends SearchFilesVisitor {
        private LayoutSearchFilesVistor() {
        }

        public boolean visit(IResourceProxy resourceProxy) {
            IResource resource;
            if (resourceProxy.getType() == 1 && resourceProxy.getName().endsWith(this.searchFileName) && (resource = resourceProxy.requestResource()).exists()) {
                this.resources.add((IFile)resource);
            }
            return true;
        }
    }
}

