/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade.animated;

import com.liferay.ide.project.ui.ProjectUI;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public abstract class PageAction {
    protected Image[] images = new Image[5];
    protected String pageActionName;

    public PageAction(String pageActionName) {
        this.pageActionName = pageActionName;
    }

    public Rectangle drawImage(GC gc, Image image, int cX, int cY) {
        Rectangle bounds = image.getBounds();
        gc.drawImage(image, cX -= bounds.width / 2, cY -= bounds.height / 2);
        return new Rectangle(cX, cY, bounds.width, bounds.height);
    }

    public Image getBageImage() {
        return this.images[4];
    }

    public Image[] getImages() {
        return this.images;
    }

    public Point getSize() {
        Rectangle bounds = this.images[2].getBounds();
        return new Point(bounds.width, bounds.height);
    }

    public final Image loadImage(String name) {
        URL url = null;
        try {
            url = ProjectUI.getDefault().getBundle().getEntry("images/" + name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ImageDescriptor imagedesc = ImageDescriptor.createFromURL(url);
        Image image = imagedesc.createImage();
        return image;
    }

    public final String getPageActionName() {
        return this.pageActionName;
    }
}

