/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.workspace;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import com.liferay.ide.project.core.workspace.ImportLiferayWorkspaceOp;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.modules.BaseProjectWizard;
import com.liferay.ide.ui.util.ProjectExplorerLayoutUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.WizardDef;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizardPage;
import org.eclipse.ui.IWorkbench;

public class ImportLiferayWorkspaceWizard
extends BaseProjectWizard<ImportLiferayWorkspaceOp> {
    private boolean firstErrorMessageRemoved = false;

    public ImportLiferayWorkspaceWizard() {
        super(ImportLiferayWorkspaceWizard.createDefaultOp(), (DefinitionLoader.Reference<WizardDef>)DefinitionLoader.sdef(ImportLiferayWorkspaceWizard.class).wizard());
    }

    @Override
    public IWizardPage[] getPages() {
        IWizardPage[] wizardPages = super.getPages();
        if (!this.firstErrorMessageRemoved && wizardPages != null) {
            SapphireWizardPage wizardPage = (SapphireWizardPage)wizardPages[0];
            try {
                if (LiferayWorkspaceUtil.hasWorkspace()) {
                    wizardPage.setMessage(LiferayWorkspaceUtil.hasLiferayWorkspaceMsg, 3);
                } else {
                    wizardPage.setMessage("Please select the workspace location.", 0);
                }
            }
            catch (CoreException e) {
                wizardPage.setMessage(LiferayWorkspaceUtil.multiWorkspaceErrorMsg, 3);
            }
            this.firstErrorMessageRemoved = true;
        }
        return wizardPages;
    }

    protected void performPostFinish() {
        super.performPostFinish();
        ImportLiferayWorkspaceOp op = (ImportLiferayWorkspaceOp)((ImportLiferayWorkspaceOp)this.element()).nearest(ImportLiferayWorkspaceOp.class);
        IProject newProject = CoreUtil.getProject((String)((Path)op.getWorkspaceLocation().content()).lastSegment());
        try {
            this.addToWorkingSets(newProject);
        }
        catch (Exception ex) {
            ProjectUI.logError("Unable to add project to working set", ex);
        }
        this.openLiferayPerspective(newProject);
        ProjectExplorerLayoutUtil.setNested((boolean)true);
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    private static ImportLiferayWorkspaceOp createDefaultOp() {
        return (ImportLiferayWorkspaceOp)ImportLiferayWorkspaceOp.TYPE.instantiate();
    }
}

