/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.workspace;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import com.liferay.ide.project.core.workspace.NewLiferayWorkspaceOp;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.modules.BaseProjectWizard;
import com.liferay.ide.ui.util.ProjectExplorerLayoutUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.WizardDef;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizardPage;
import org.eclipse.ui.IWorkbench;

public class NewLiferayWorkspaceWizard
extends BaseProjectWizard<NewLiferayWorkspaceOp> {
    private boolean firstErrorMessageRemoved = false;

    public NewLiferayWorkspaceWizard() {
        super(NewLiferayWorkspaceWizard.createDefaultOp(), (DefinitionLoader.Reference<WizardDef>)DefinitionLoader.sdef(NewLiferayWorkspaceWizard.class).wizard());
    }

    @Override
    public IWizardPage[] getPages() {
        IWizardPage[] wizardPages = super.getPages();
        if (!this.firstErrorMessageRemoved && wizardPages != null) {
            SapphireWizardPage wizardPage = (SapphireWizardPage)wizardPages[0];
            try {
                if (LiferayWorkspaceUtil.hasWorkspace()) {
                    wizardPage.setMessage(LiferayWorkspaceUtil.hasLiferayWorkspaceMsg, 3);
                } else {
                    wizardPage.setMessage("Please enter the workspace project name.", 0);
                }
            }
            catch (CoreException e) {
                wizardPage.setMessage(LiferayWorkspaceUtil.multiWorkspaceErrorMsg, 3);
            }
            this.firstErrorMessageRemoved = true;
        }
        return wizardPages;
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    protected void performPostFinish() {
        super.performPostFinish();
        NewLiferayWorkspaceOp op = (NewLiferayWorkspaceOp)((NewLiferayWorkspaceOp)this.element()).nearest(NewLiferayWorkspaceOp.class);
        IProject newProject = CoreUtil.getProject((String)((String)op.getWorkspaceName().content()));
        try {
            this.addToWorkingSets(newProject);
        }
        catch (Exception ex) {
            ProjectUI.logError("Unable to add project to working set", ex);
        }
        this.openLiferayPerspective(newProject);
        ProjectExplorerLayoutUtil.setNested((boolean)true);
    }

    private static NewLiferayWorkspaceOp createDefaultOp() {
        return (NewLiferayWorkspaceOp)NewLiferayWorkspaceOp.TYPE.instantiate();
    }
}

