/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.dialogs;

import javax.inject.Inject;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.SendModeLabelProvider;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.UI;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Browsers;
import org.eclipse.epp.logging.aeri.core.IModelPackage;
import org.eclipse.epp.logging.aeri.core.ISystemSettings;
import org.eclipse.epp.logging.aeri.core.SendMode;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SystemSettingsPage
extends WizardPage {
    private ISystemSettings systemSettings;
    private DataBindingContext context;

    @Inject
    public SystemSettingsPage(ISystemSettings systemSettings) {
        super(SystemSettingsPage.class.getName());
        this.systemSettings = systemSettings;
        this.context = new DataBindingContext();
        this.setTitle(Messages.WIZPAGE_TITLE_SYSTEM_SETTINGS);
        this.setDescription(Messages.WIZPAGE_DESCRIPTION_SYSTEM_SETTINGS);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        Composite personalGroup = this.createPersonalGroup(container);
        Group anonymizeDefaults = this.createAnonymizeGroup(container);
        Composite sendModeDefaults = this.createSendModeControl(container);
        Composite links = this.createLinksControl(container);
        UI.gl().margins(5, 5).applyTo(container);
        UI.gd().applyTo((Control)container);
        UI.gdGrabH().indent(0, 10).applyTo((Control)personalGroup);
        UI.gd().indent(0, 10).applyTo((Control)anonymizeDefaults);
        UI.gd().align(131072, 0x1000000).applyTo((Control)sendModeDefaults);
        UI.gdGrabV().align(1, 0x1000008).applyTo((Control)links);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    private Composite createLinksControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        UI.gl().numColumns(2).applyTo(container);
        Link learnMore = new Link(container, 0);
        learnMore.setText(Messages.LINK_TEXT_LEARN_MORE);
        learnMore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Browsers.openInExternalBrowser("https://wiki.eclipse.org/EPP/Logging");
            }
        });
        return container;
    }

    private Composite createPersonalGroup(Composite parent) {
        Group personalGroup = new Group(parent, 0);
        personalGroup.setText(Messages.GROUP_TEXT_CONTACT_INFORMATION);
        UI.gl().margins(5, 5).numColumns(2).applyTo((Composite)personalGroup);
        Text name = UI.createLabelWithText((Composite)personalGroup, Messages.FIELD_LABEL_NAME, Messages.FIELD_MESSAGE_NAME, Messages.FIELD_MESSAGE_NAME);
        ISWTObservableValue swt = WidgetProperties.text((int)16).observe((Widget)name);
        IObservableValue emf = EMFProperties.value((EStructuralFeature)IModelPackage.Literals.USER_SETTINGS__REPORTER_NAME).observe((Object)this.systemSettings);
        this.context.bindValue((IObservableValue)swt, emf);
        String tooltip = String.valueOf(Messages.FIELD_MESSAGE_EMAIL) + '\n' + Messages.TOOLTIP_SETTINGS_EMAIL;
        Text email = UI.createLabelWithText((Composite)personalGroup, Messages.FIELD_LABEL_EMAIL, Messages.FIELD_MESSAGE_EMAIL, tooltip);
        ISWTObservableValue swt2 = WidgetProperties.text((int)24).observe((Widget)email);
        IObservableValue emf2 = EMFProperties.value((EStructuralFeature)IModelPackage.Literals.USER_SETTINGS__REPORTER_EMAIL).observe((Object)this.systemSettings);
        this.context.bindValue((IObservableValue)swt2, emf2);
        return personalGroup;
    }

    private Group createAnonymizeGroup(Composite parent) {
        Group container = new Group(parent, 92);
        container.setLayout((Layout)new RowLayout(512));
        container.setText(Messages.GROUP_TEXT_ANONYMIZATION);
        Button stackTraces = UI.createCheckButton((Composite)container, Messages.FIELD_LABEL_ANONYMIZE_STACKTRACES, Messages.TOOLTIP_SETTINGS_MAKE_STACKTRACE_ANONYMOUS);
        stackTraces.setFocus();
        ISWTObservableValue swt = WidgetProperties.selection().observe((Widget)stackTraces);
        IObservableValue emf = EMFProperties.value((EStructuralFeature)IModelPackage.Literals.USER_SETTINGS__ANONYMIZE_STACK_TRACES).observe((Object)this.systemSettings);
        this.context.bindValue((IObservableValue)swt, emf);
        Button messages = UI.createCheckButton((Composite)container, Messages.FIELD_LABEL_ANONYMIZE_MESSAGES, Messages.TOOLTIP_SETTINGS_MAKE_MESSAGES_ANONYMOUS);
        swt = WidgetProperties.selection().observe((Widget)messages);
        emf = EMFProperties.value((EStructuralFeature)IModelPackage.Literals.USER_SETTINGS__ANONYMIZE_MESSAGES).observe((Object)this.systemSettings);
        this.context.bindValue((IObservableValue)swt, emf);
        Button disableWiringAnalysis = UI.createCheckButton((Composite)container, Messages.FIELD_LABEL_DISABLE_AUTOMATIC_WIRING_ANALYSIS, Messages.TOOLTIP_DISABLE_AUTOMATIC_WIRING_ANALYSIS);
        swt = WidgetProperties.selection().observe((Widget)disableWiringAnalysis);
        emf = EMFProperties.value((EStructuralFeature)IModelPackage.Literals.USER_SETTINGS__DISABLE_AUTOMATIC_WIRING_ANALYSIS).observe((Object)this.systemSettings);
        this.context.bindValue((IObservableValue)swt, emf);
        return container;
    }

    private Composite createSendModeControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        ComboViewer sendMode = new ComboViewer(container);
        sendMode.getControl().setToolTipText(Messages.TOOLTIP_SEND_MODE);
        sendMode.setContentProvider((IContentProvider)new ArrayContentProvider());
        sendMode.setInput((Object)SendMode.VALUES);
        sendMode.setLabelProvider((IBaseLabelProvider)new SendModeLabelProvider());
        IViewerObservableValue jface = ViewersObservables.observeSinglePostSelection((StructuredViewer)sendMode);
        IObservableValue emf = EMFProperties.value((EStructuralFeature)IModelPackage.Literals.SYSTEM_SETTINGS__SEND_MODE).observe((Object)this.systemSettings);
        this.context.bindValue((IObservableValue)jface, emf);
        UI.gl().numColumns(2).applyTo(container);
        UI.gdGrabH().align(0x1000008, 0x1000000).span(2, 1).applyTo((Control)container);
        return container;
    }

    public void dispose() {
        this.context.dispose();
        super.dispose();
    }
}

