/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.wizard;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.remote.IRemoteServer;
import com.liferay.ide.server.remote.IRemoteServerWorkingCopy;
import com.liferay.ide.server.remote.RemoteServer;
import com.liferay.ide.server.remote.RemoteUtil;
import com.liferay.ide.server.ui.LiferayServerUI;
import com.liferay.ide.server.ui.wizard.RemoteServerWizardFragment;
import com.liferay.ide.ui.LiferayUIPlugin;
import com.liferay.ide.ui.util.SWTUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class RemoteServerComposite
extends Composite
implements ModifyListener,
PropertyChangeListener {
    protected boolean disableValidation;
    protected RemoteServerWizardFragment fragment;
    protected boolean ignoreModifyEvents;
    protected Label labelHttpPort;
    protected Label labelLiferayPortalContextPath;
    protected Label labelPassword;
    protected Label labelServerManagerContextPath;
    protected Label labelUsername;
    protected IRemoteServerWorkingCopy remoteServerWC;
    protected IServerWorkingCopy serverWC;
    protected Text textHostname;
    protected Text textHTTP;
    protected Text textLiferayPortalContextPath;
    protected Text textPassword;
    protected Text textServerManagerContextPath;
    protected Text textUsername;
    protected IWizardHandle wizard;
    private String initialServerName;
    private String initialHostName;

    public RemoteServerComposite(Composite parent, RemoteServerWizardFragment fragment, IWizardHandle wizard) {
        super(parent, 0);
        this.fragment = fragment;
        this.wizard = wizard;
        this.createControl(parent);
    }

    public void modifyText(ModifyEvent e) {
        Object src = e.getSource();
        if (src == null || this.ignoreModifyEvents) {
            return;
        }
        if (src.equals(this.textHostname)) {
            this.serverWC.setHost(this.textHostname.getText());
            if (this.initialServerName != null && this.initialHostName.contains(this.initialHostName)) {
                this.serverWC.setName(this.initialServerName.replaceAll(this.initialHostName, this.textHostname.getText()));
            }
        } else if (src.equals(this.textHTTP)) {
            this.remoteServerWC.setHTTPPort(this.textHTTP.getText());
        } else if (src.equals(this.textServerManagerContextPath)) {
            this.remoteServerWC.setServerManagerContextPath(this.textServerManagerContextPath.getText());
        } else if (src.equals(this.textLiferayPortalContextPath)) {
            this.remoteServerWC.setLiferayPortalContextPath(this.textLiferayPortalContextPath.getText());
        } else if (src.equals(this.textUsername)) {
            this.remoteServerWC.setUsername(this.textUsername.getText());
        } else if (src.equals(this.textPassword)) {
            this.remoteServerWC.setPassword(this.textPassword.getText());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("hostname".equals(evt.getPropertyName()) || "http-port".equals(evt.getPropertyName()) || "username".equals(evt.getPropertyName()) || "password".equals(evt.getPropertyName()) || "liferay-portal-context-path".equals(evt.getPropertyName()) || "server-manager-context-path".equals(evt.getPropertyName())) {
            LiferayServerCore.updateConnectionSettings((IRemoteServer)((IRemoteServer)this.serverWC.loadAdapter(IRemoteServer.class, null)));
        }
    }

    public void setServer(IServerWorkingCopy newServer) {
        if (newServer == null) {
            this.serverWC = null;
            this.remoteServerWC = null;
        } else {
            this.serverWC = newServer;
            this.remoteServerWC = (IRemoteServerWorkingCopy)this.serverWC.loadAdapter(IRemoteServerWorkingCopy.class, null);
            this.serverWC.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.disableValidation = true;
        this.initialize();
        this.disableValidation = false;
        this.validate();
    }

    protected void createControl(Composite parent) {
        this.setLayout((Layout)new GridLayout(1, false));
        this.setBackground(parent.getBackground());
        this.disableValidation = true;
        Group connectionGroup = SWTUtil.createGroup((Composite)this, (String)Msgs.connectionSettings, (int)2);
        connectionGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        Label labelHostname = new Label((Composite)connectionGroup, 0);
        labelHostname.setText(Msgs.hostname);
        this.textHostname = new Text((Composite)connectionGroup, 2048);
        this.textHostname.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textHostname.addModifyListener((ModifyListener)this);
        this.labelHttpPort = new Label((Composite)connectionGroup, 0);
        this.labelHttpPort.setText(Msgs.httpPortLabel);
        this.textHTTP = new Text((Composite)connectionGroup, 2048);
        this.textHTTP.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.textHTTP.addModifyListener((ModifyListener)this);
        this.labelUsername = new Label((Composite)connectionGroup, 0);
        this.labelUsername.setText(Msgs.username);
        this.textUsername = new Text((Composite)connectionGroup, 2048);
        this.textUsername.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.textUsername.addModifyListener((ModifyListener)this);
        this.labelPassword = new Label((Composite)connectionGroup, 0);
        this.labelPassword.setText(Msgs.password);
        this.textPassword = new Text((Composite)connectionGroup, 0x400800);
        this.textPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textPassword.addModifyListener((ModifyListener)this);
        this.labelLiferayPortalContextPath = new Label((Composite)connectionGroup, 0);
        this.labelLiferayPortalContextPath.setText(Msgs.liferayPortalContextPath);
        this.labelLiferayPortalContextPath.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.textLiferayPortalContextPath = new Text((Composite)connectionGroup, 2048);
        this.textLiferayPortalContextPath.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textLiferayPortalContextPath.addModifyListener((ModifyListener)this);
        this.labelServerManagerContextPath = new Label((Composite)connectionGroup, 0);
        this.labelServerManagerContextPath.setText(Msgs.serverManagerContextPath);
        this.labelServerManagerContextPath.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.textServerManagerContextPath = new Text((Composite)connectionGroup, 2048);
        this.textServerManagerContextPath.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textServerManagerContextPath.addModifyListener((ModifyListener)this);
        String marketplaceLinkLabel = Msgs.installRemoteIDEConnector;
        String appUrl = "http://www.liferay.com/marketplace/-/mp/application/15193785";
        SWTUtil.createHyperLink((Composite)this, (int)0, (String)marketplaceLinkLabel, (int)1, (String)"http://www.liferay.com/marketplace/-/mp/application/15193785");
        String installLabel = NLS.bind((String)"<a>{0}</a>", (Object)Msgs.clickHereLink);
        String installUrl = "{0}/group/control_panel/manage?p_p_id=1_WAR_marketplaceportlet&p_p_lifecycle=0&p_p_state=maximized&p_p_mode=view&appId=15193785";
        Link installLink = SWTUtil.createLink((Composite)this, (int)0, (String)installLabel, (int)1);
        installLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    String url = MessageFormat.format("{0}/group/control_panel/manage?p_p_id=1_WAR_marketplaceportlet&p_p_lifecycle=0&p_p_state=maximized&p_p_mode=view&appId=15193785", "http://" + RemoteServerComposite.this.textHostname.getText() + ":" + RemoteServerComposite.this.textHTTP.getText());
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(url));
                }
                catch (Exception e1) {
                    LiferayUIPlugin.logError((String)"Could not open external browser.", (Exception)e1);
                }
            }
        });
        Composite validateComposite = new Composite((Composite)this, 0);
        validateComposite.setLayoutData((Object)new GridData(16384, 1024, false, true));
        validateComposite.setLayout((Layout)new GridLayout(1, false));
        Button validateButton = new Button(validateComposite, 8);
        validateButton.setText(Msgs.validateConnection);
        validateButton.setLayoutData((Object)new GridData(16384, 1024, false, false));
        validateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteServerComposite.this.validate();
            }
        });
        this.disableValidation = false;
        this.validate();
    }

    protected RemoteServer getRemoteServer() {
        if (this.serverWC != null) {
            return (RemoteServer)this.serverWC.loadAdapter(RemoteServer.class, null);
        }
        return null;
    }

    protected void initialize() {
        if (this.serverWC != null && this.remoteServerWC != null) {
            this.ignoreModifyEvents = true;
            this.textHostname.setText(this.serverWC.getHost());
            this.textHTTP.setText(this.remoteServerWC.getHTTPPort());
            this.textLiferayPortalContextPath.setText(this.remoteServerWC.getLiferayPortalContextPath());
            this.textServerManagerContextPath.setText(this.remoteServerWC.getServerManagerContextPath());
            this.textUsername.setText(this.remoteServerWC.getUsername());
            this.textPassword.setText(this.remoteServerWC.getPassword());
            this.initialServerName = this.serverWC.getName();
            this.initialHostName = this.serverWC.getHost();
            this.ignoreModifyEvents = false;
        }
    }

    protected void validate() {
        if (this.disableValidation) {
            return;
        }
        if (this.serverWC == null) {
            this.wizard.setMessage("", 3);
            return;
        }
        try {
            IRunnableWithProgress validateRunnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    final IStatus updateStatus = RemoteServerComposite.this.validateServer(monitor);
                    if (updateStatus.isOK()) {
                        String contextPath = RemoteUtil.detectServerManagerContextPath((RemoteServer)RemoteServerComposite.this.getRemoteServer(), (IProgressMonitor)monitor);
                        RemoteServerComposite.this.remoteServerWC.setServerManagerContextPath(contextPath);
                    }
                    RemoteServerComposite.this.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (updateStatus == null || updateStatus.isOK()) {
                                (this).RemoteServerComposite.this.wizard.setMessage(null, 0);
                            } else if (updateStatus.getSeverity() == 2 || updateStatus.getSeverity() == 4) {
                                if (updateStatus.getMessage().contains("Your license key has expired") || updateStatus.getMessage().contains("Register Your Server or Application")) {
                                    (this).RemoteServerComposite.this.wizard.setMessage("Server is not registered or license key has expired ", 2);
                                } else {
                                    (this).RemoteServerComposite.this.wizard.setMessage(updateStatus.getMessage(), 2);
                                }
                            }
                            (this).RemoteServerComposite.this.wizard.update();
                        }
                    });
                }
            };
            this.wizard.run(true, true, validateRunnable);
            this.wizard.update();
            if (this.fragment.lastServerStatus != null && this.fragment.lastServerStatus.isOK()) {
                this.ignoreModifyEvents = true;
                this.textServerManagerContextPath.setText(this.remoteServerWC.getServerManagerContextPath());
                this.textLiferayPortalContextPath.setText(this.remoteServerWC.getLiferayPortalContextPath());
                this.ignoreModifyEvents = false;
            }
        }
        catch (Exception e) {
            this.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    RemoteServerComposite.this.wizard.setMessage(e.getMessage(), 2);
                    RemoteServerComposite.this.wizard.update();
                }
            });
        }
    }

    protected IStatus validateServer(IProgressMonitor monitor) {
        String host = this.serverWC.getHost();
        if (CoreUtil.isNullOrEmpty((String)host)) {
            return LiferayServerUI.createErrorStatus(Msgs.specifyHostname);
        }
        String username = this.remoteServerWC.getUsername();
        if (CoreUtil.isNullOrEmpty((String)username)) {
            return LiferayServerUI.createErrorStatus(Msgs.specifyUsernamePassword);
        }
        String port = this.remoteServerWC.getHTTPPort();
        if (CoreUtil.isNullOrEmpty((String)port)) {
            return LiferayServerUI.createErrorStatus(Msgs.specifyHTTPPort);
        }
        IStatus status = this.remoteServerWC.validate(monitor);
        this.fragment.lastServerStatus = status != null && status.getSeverity() == 4 ? new Status(2, status.getPlugin(), status.getMessage(), status.getException()) : status;
        return status;
    }

    private static class Msgs
    extends NLS {
        public static String clickHereLink;
        public static String connectionSettings;
        public static String hostname;
        public static String httpPortLabel;
        public static String installRemoteIDEConnector;
        public static String liferayPortalContextPath;
        public static String password;
        public static String serverManagerContextPath;
        public static String specifyHostname;
        public static String specifyHTTPPort;
        public static String specifyUsernamePassword;
        public static String username;
        public static String validateConnection;

        static {
            Msgs.initializeMessages((String)RemoteServerComposite.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

