/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.maven.core.MavenUtil;
import com.liferay.ide.maven.core.ThemePluginBuildParticipant;
import java.util.Set;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.osgi.util.NLS;

public class BuildThumbnailBuildParticipant
extends ThemePluginBuildParticipant {
    @Override
    public Set<IProject> build(int kind, IProgressMonitor monitor) throws Exception {
        IProgressMonitor sub = CoreUtil.newSubMonitor((IProgressMonitor)monitor, (int)100);
        sub.beginTask(Msgs.thumbnailBuilder, 100);
        Set<IProject> retval = super.build(kind, monitor);
        sub.done();
        return retval;
    }

    @Override
    protected void configureExecution(IMavenProjectFacade facade, Xpp3Dom config) {
    }

    @Override
    protected String getGoal() {
        return "liferay:build-thumbnail";
    }

    @Override
    protected boolean shouldBuild(int kind, IMavenProjectFacade facade) {
        boolean retval = false;
        IResourceDelta delta = this.getDelta(facade.getProject());
        String warSourceDirectory = MavenUtil.getWarSourceDirectory(facade);
        if (!CoreUtil.isNullOrEmpty((String)warSourceDirectory)) {
            IPath screenshotPath = facade.getProject().getFolder(String.valueOf(warSourceDirectory) + "/images/screenshot.png").getProjectRelativePath();
            if (delta != null && delta.findMember(screenshotPath) != null) {
                retval = true;
            }
        }
        return retval;
    }

    private static class Msgs
    extends NLS {
        public static String thumbnailBuilder;

        static {
            Msgs.initializeMessages((String)BuildThumbnailBuildParticipant.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

