/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.IBundleProject;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.maven.core.LiferayMavenCore;
import com.liferay.ide.maven.core.LiferayMavenProject;
import com.liferay.ide.maven.core.MavenProjectBuilder;
import com.liferay.ide.maven.core.MavenProjectRemoteServerPublisher;
import com.liferay.ide.maven.core.MavenUtil;
import com.liferay.ide.maven.core.util.DefaultMaven2OsgiConverter;
import com.liferay.ide.project.core.IProjectBuilder;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.server.remote.IRemoteServerPublisher;
import java.io.File;
import java.io.InputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2e.core.project.IMavenProjectFacade;

public class MavenBundlePluginProject
extends LiferayMavenProject
implements IBundleProject {
    private final String[] ignorePaths = new String[]{"target"};

    public MavenBundlePluginProject(IProject project) {
        super(project);
    }

    @Override
    public <T> T adapt(Class<T> adapterType) {
        T adapter = super.adapt(adapterType);
        if (adapter != null) {
            return adapter;
        }
        IMavenProjectFacade facade = MavenUtil.getProjectFacade(this.getProject(), (IProgressMonitor)new NullProgressMonitor());
        if (facade != null) {
            if (IProjectBuilder.class.equals(adapterType)) {
                MavenProjectBuilder projectBuilder = new MavenProjectBuilder(this.getProject());
                return adapterType.cast((Object)projectBuilder);
            }
            if (IRemoteServerPublisher.class.equals(adapterType)) {
                MavenProjectRemoteServerPublisher remoteServerPublisher = new MavenProjectRemoteServerPublisher(this.getProject());
                return adapterType.cast((Object)remoteServerPublisher);
            }
            if (IBundleProject.class.equals(adapterType)) {
                return adapterType.cast(this);
            }
        }
        return null;
    }

    public String getBundleShape() {
        return "jar";
    }

    public IFile getDescriptorFile(String name) {
        return this.getProject().getFile(name);
    }

    public IPath getOutputBundle(boolean cleanBuild, IProgressMonitor monitor) throws CoreException {
        IPath targetFile;
        IPath outputJar = null;
        IMavenProjectFacade projectFacade = MavenUtil.getProjectFacade(this.getProject(), monitor);
        MavenProjectBuilder mavenProjectBuilder = new MavenProjectBuilder(this.getProject());
        IFile manifest = this.getProject().getFile("target/classes/META-INF/MANIFEST.MF");
        if (manifest.exists()) {
            manifest.delete(true, monitor);
        }
        if (cleanBuild || !this.isAutoBuild()) {
            this.getProject().build(15, monitor);
            this.getProject().build(6, monitor);
        } else {
            this.getProject().build(10, monitor);
        }
        mavenProjectBuilder.execJarMojo(projectFacade, monitor);
        MavenProject mavenProject = projectFacade.getMavenProject(monitor);
        String targetName = String.valueOf(mavenProject.getBuild().getFinalName()) + "." + this.getBundleShape();
        String buildDirectory = mavenProject.getBuild().getDirectory();
        File baseDirectory = mavenProject.getBasedir();
        Path buildDirPath = new Path(buildDirectory);
        Path baseDirPath = new Path(baseDirectory.toString());
        IPath relativePath = buildDirPath.makeRelativeTo((IPath)baseDirPath);
        IFolder targetFolder = this.getTargetFolder(this.getProject(), relativePath);
        if (targetFolder.exists() && (targetFile = targetFolder.getRawLocation().append(targetName)).toFile().exists()) {
            outputJar = targetFile;
        }
        return outputJar;
    }

    public IPath getOutputBundlePath() {
        IPath outputJar = null;
        try {
            IPath targetFile;
            IMavenProjectFacade projectFacade = MavenUtil.getProjectFacade(this.getProject(), null);
            MavenProject mavenProject = projectFacade.getMavenProject(null);
            String targetName = String.valueOf(mavenProject.getBuild().getFinalName()) + "." + this.getBundleShape();
            IFolder targetFolder = this.getProject().getFolder("target");
            if (targetFolder.exists() && (targetFile = targetFolder.getRawLocation().append(targetName)).toFile().exists()) {
                outputJar = targetFile;
            }
        }
        catch (Exception e) {
            LiferayMavenCore.logError(e);
        }
        return outputJar;
    }

    private boolean isAutoBuild() {
        return ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
    }

    private IFolder getTargetFolder(IProject project, IPath relativePath) {
        IFolder targetFolder = project.getFolder(relativePath);
        if (!targetFolder.exists()) {
            targetFolder = project.getFolder("target");
        }
        return targetFolder;
    }

    public String getSymbolicName() throws CoreException {
        String bsn = ProjectUtil.getBundleSymbolicNameFromBND((IProject)this.getProject());
        if (!CoreUtil.empty((String)bsn)) {
            return bsn;
        }
        String retval = null;
        NullProgressMonitor monitor = new NullProgressMonitor();
        IMavenProjectFacade projectFacade = MavenUtil.getProjectFacade(this.getProject(), (IProgressMonitor)monitor);
        MavenProject mavenProject = projectFacade.getMavenProject((IProgressMonitor)monitor);
        Artifact artifact = mavenProject.getArtifact();
        File file = artifact.getFile();
        retval = file != null && file.exists() && !artifact.getFile().getName().equals("classes") ? new DefaultMaven2OsgiConverter().getBundleSymbolicName(artifact) : this.getProject().getLocation().lastSegment();
        return retval;
    }

    public boolean filterResource(IPath resourcePath) {
        return this.filterResource(resourcePath, this.ignorePaths);
    }

    public boolean isFragmentBundle() {
        IFile bndFile = this.getProject().getFile("bnd.bnd");
        if (bndFile.exists()) {
            try {
                String content = FileUtil.readContents((InputStream)bndFile.getContents());
                if (content.contains("Fragment-Host")) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

