/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.LaunchHelper;
import com.liferay.ide.maven.core.MavenUtil;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.core.util.SearchFilesVisitor;
import com.liferay.ide.server.remote.AbstractRemoteServerPublisher;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;

public class MavenProjectRemoteServerPublisher
extends AbstractRemoteServerPublisher {
    private final String ATTR_GOALS = "M2_GOALS";
    private final String ATTR_POM_DIR = IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY;
    private final String ATTR_PROFILES = "M2_PROFILES";
    private final String ATTR_SKIP_TESTS = "M2_SKIP_TESTS";
    private final String ATTR_UPDATE_SNAPSHOTS = "M2_UPDATE_SNAPSHOTS";
    private final String ATTR_WORKSPACE_RESOLUTION = "M2_WORKSPACE_RESOLUTION";
    private final String LAUNCH_CONFIGURATION_TYPE_ID = "org.eclipse.m2e.Maven2LaunchConfigurationType";

    public MavenProjectRemoteServerPublisher(IProject project) {
        super(project);
    }

    private boolean execMavenLaunch(IProject project, String goal, IMavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.m2e.Maven2LaunchConfigurationType");
        IPath basedirLocation = project.getLocation();
        String newName = launchManager.generateLaunchConfigurationName(basedirLocation.lastSegment());
        ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance(null, newName);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "-Dmaven.multiModuleProjectDirectory");
        workingCopy.setAttribute(this.ATTR_POM_DIR, basedirLocation.toString());
        workingCopy.setAttribute("M2_GOALS", goal);
        workingCopy.setAttribute("M2_UPDATE_SNAPSHOTS", true);
        workingCopy.setAttribute("M2_WORKSPACE_RESOLUTION", true);
        workingCopy.setAttribute("M2_SKIP_TESTS", true);
        if (facade != null) {
            ResolverConfiguration configuration = facade.getResolverConfiguration();
            String selectedProfiles = configuration.getSelectedProfiles();
            if (selectedProfiles != null && selectedProfiles.length() > 0) {
                workingCopy.setAttribute("M2_PROFILES", selectedProfiles);
            }
            new LaunchHelper().launch((ILaunchConfiguration)workingCopy, "run", monitor);
            return true;
        }
        return false;
    }

    private String getMavenDeployGoals() {
        return "package war:war";
    }

    private boolean isServiceBuilderProject(IProject project, String pluginType, MavenProject parentProject) {
        List serviceXmls = new SearchFilesVisitor().searchFiles((IResource)project, "service.xml");
        return serviceXmls != null && serviceXmls.size() > 0 && pluginType.equalsIgnoreCase("portlet") && parentProject != null;
    }

    public void processResourceDeltas(IModuleResourceDelta[] deltas, ZipOutputStream zip, Map<ZipEntry, String> deleteEntries, String deletePrefix, String deltaPrefix, boolean adjustGMTOffset) throws IOException, CoreException {
        IModuleResourceDelta[] iModuleResourceDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleResourceDelta delta = iModuleResourceDeltaArray[n2];
            IResource deltaResource = (IResource)delta.getModuleResource().getAdapter(IResource.class);
            IProject deltaProject = deltaResource.getProject();
            IWebProject lrproject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)deltaProject);
            if (lrproject != null && lrproject.getDefaultDocrootFolder() != null) {
                IPath containerFullPath;
                IFolder webappRoot = lrproject.getDefaultDocrootFolder();
                int deltaKind = delta.getKind();
                IPath deltaFullPath = deltaResource.getFullPath();
                boolean deltaZip = false;
                IPath deltaPath = null;
                if (webappRoot != null && webappRoot.exists() && (containerFullPath = webappRoot.getFullPath()).isPrefixOf(deltaFullPath)) {
                    deltaZip = true;
                    deltaPath = new Path(String.valueOf(deltaPrefix) + deltaFullPath.makeRelativeTo(containerFullPath));
                }
                if (!deltaZip && new Path("WEB-INF").isPrefixOf(delta.getModuleRelativePath())) {
                    List folders = CoreUtil.getSourceFolders((IJavaProject)JavaCore.create((IProject)deltaProject));
                    for (IFolder folder : folders) {
                        IPath folderPath = folder.getFullPath();
                        if (!folderPath.isPrefixOf(deltaFullPath)) continue;
                        deltaZip = true;
                        break;
                    }
                }
                if (!(deltaZip || deltaKind != 1 && deltaKind != 2 && deltaKind != 3)) {
                    IPath targetPath = JavaCore.create((IProject)deltaProject).getOutputLocation();
                    deltaZip = true;
                    deltaPath = new Path("WEB-INF/classes").append(deltaFullPath.makeRelativeTo(targetPath));
                }
                if (deltaZip) {
                    if (deltaKind == 1 || deltaKind == 2) {
                        this.addToZip(deltaPath, deltaResource, zip, adjustGMTOffset);
                    } else if (deltaKind == 3) {
                        this.addRemoveProps(deltaPath, deltaResource, zip, deleteEntries, deletePrefix);
                    } else if (deltaKind == 0) {
                        IModuleResourceDelta[] children = delta.getAffectedChildren();
                        this.processResourceDeltas(children, zip, deleteEntries, deletePrefix, deltaPrefix, adjustGMTOffset);
                    }
                }
            }
            ++n2;
        }
    }

    public IPath publishModuleFull(IProgressMonitor monitor) throws CoreException {
        IPath retval = null;
        if (this.runMavenGoal(this.getProject(), monitor)) {
            IMavenProjectFacade projectFacade = MavenUtil.getProjectFacade(this.getProject(), monitor);
            MavenProject mavenProject = projectFacade.getMavenProject(monitor);
            String targetFolder = mavenProject.getBuild().getDirectory();
            String targetWar = String.valueOf(mavenProject.getBuild().getFinalName()) + "." + mavenProject.getPackaging();
            retval = new Path(targetFolder).append(targetWar);
        }
        return retval;
    }

    private boolean runMavenGoal(IProject project, IProgressMonitor monitor) throws CoreException {
        boolean retval = false;
        IMavenProjectFacade facade = MavenUtil.getProjectFacade(project, monitor);
        String pluginType = MavenUtil.getLiferayMavenPluginType(facade.getMavenProject(monitor));
        if (pluginType == null) {
            pluginType = "portlet";
        }
        MavenProject parentProject = facade.getMavenProject(monitor).getParent();
        String goal = this.getMavenDeployGoals();
        retval = this.isServiceBuilderProject(project, pluginType, parentProject) ? this.execMavenLaunch(ProjectUtil.getProject((String)parentProject.getName()), " package -am -pl " + project.getName(), MavenUtil.getProjectFacade(project, monitor), monitor) : this.execMavenLaunch(project, goal, facade, monitor);
        return retval;
    }
}

