/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.ILiferayProjectImporter;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.maven.core.NewMavenJSFModuleProjectProvider;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.jsf.NewLiferayJSFModuleProjectOp;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class NewGradleJSFModuleProjectProvider
extends NewMavenJSFModuleProjectProvider {
    private static final Pattern PATTERN_LIFERAY_WAR_PLUGIN = Pattern.compile(".*apply.*plugin.*:.*['\"]((com\\.liferay)|(war))['\"].*", 40);

    @Override
    public IStatus createNewProject(NewLiferayJSFModuleProjectOp op, IProgressMonitor monitor) throws CoreException {
        IStatus retval = Status.OK_STATUS;
        try {
            ILiferayProjectImporter importer;
            IStatus canImport;
            IPath buildPom;
            IPath projectLocation = this.createArchetypeProject(op, monitor);
            IPath buildGradlePath = projectLocation.append("build.gradle");
            if (buildGradlePath.toFile().exists()) {
                try {
                    boolean hasLiferayWorkspace;
                    File workspaceDir = LiferayWorkspaceUtil.getWorkspaceDir((File)buildGradlePath.toFile());
                    if (workspaceDir != null && workspaceDir.exists() && (hasLiferayWorkspace = LiferayWorkspaceUtil.isValidWorkspaceLocation((String)workspaceDir.getAbsolutePath()))) {
                        List<String> buildGradleContents = Files.readAllLines(Paths.get(buildGradlePath.toFile().toURI()), StandardCharsets.UTF_8);
                        ArrayList<String> modifyContents = new ArrayList<String>();
                        for (String line : buildGradleContents) {
                            if (PATTERN_LIFERAY_WAR_PLUGIN.matcher(line).matches()) continue;
                            modifyContents.add(line);
                        }
                        Files.write(buildGradlePath.toFile().toPath(), modifyContents, StandardCharsets.UTF_8, new OpenOption[0]);
                    }
                }
                catch (Exception e) {
                    ProjectCore.logError((String)"Failed to check LiferayWorkspace project. ");
                }
            }
            if ((buildPom = projectLocation.append("pom.xml")).toFile().exists()) {
                buildPom.toFile().delete();
            }
            if ((canImport = (importer = LiferayCore.getImporter((String)"gradle")).canImport(projectLocation.toOSString())).getCode() != 4) {
                importer.importProjects(projectLocation.toOSString(), monitor);
            }
        }
        catch (Exception e) {
            throw new CoreException(LiferayCore.createErrorStatus((Exception)e));
        }
        return retval;
    }
}

