/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.ui.dialog;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.ChooseWorkspaceDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.preferences.SettingsTransfer;

public class ChooseWorkspaceWithPreferenceDialog
extends ChooseWorkspaceDialog {
    private static final String WORKBENCH_SETTINGS = "WORKBENCH_SETTINGS";
    private static final String ENABLED_TRANSFERS = "ENABLED_TRANSFERS";
    private static final String ATT_CLASS = "class";
    private static final String ATT_NAME = "name";
    private static final String ATT_ID = "id";
    private static final String ATT_HELP_CONTEXT = "helpContext";
    private Collection selectedSettings = new HashSet();

    public ChooseWorkspaceWithPreferenceDialog(Shell parentShell, ChooseWorkspaceData launchData, boolean suppressAskAgain, boolean centerOnMonitor) {
        super(parentShell, launchData, suppressAskAgain, centerOnMonitor);
    }

    protected Control createDialogArea(Composite parent) {
        Control top = super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.ide.switch_workspace_dialog_context");
        this.createButtons((Composite)top);
        ChooseWorkspaceWithPreferenceDialog.applyDialogFont((Control)parent);
        return top;
    }

    private boolean createButtons(Composite parent) {
        IConfigurationElement[] settings = SettingsTransfer.getSettingsTransfers();
        String[] enabledSettings = this.getEnabledSettings(IDEWorkbenchPlugin.getDefault().getDialogSettings().getSection(WORKBENCH_SETTINGS));
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        panel.setLayout((Layout)layout);
        panel.setFont(parent.getFont());
        Group group = new Group(panel, 0);
        group.setText("Copy Settings");
        group.setLayout((Layout)layout);
        group.setFont(parent.getFont());
        int i = 0;
        while (i < settings.length) {
            final IConfigurationElement settingsTransfer = settings[i];
            final Button button = new Button((Composite)group, 32);
            button.setText(settings[i].getAttribute(ATT_NAME));
            String helpId = settings[i].getAttribute(ATT_HELP_CONTEXT);
            if (helpId != null) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)button, helpId);
            }
            if (enabledSettings != null && enabledSettings.length > 0) {
                String id = settings[i].getAttribute(ATT_ID);
                int j = 0;
                while (j < enabledSettings.length) {
                    if (enabledSettings[j] != null && enabledSettings[j].equals(id)) {
                        button.setSelection(true);
                        this.selectedSettings.add(settingsTransfer);
                        break;
                    }
                    ++j;
                }
            }
            button.setBackground(parent.getBackground());
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (button.getSelection()) {
                        ChooseWorkspaceWithPreferenceDialog.this.selectedSettings.add(settingsTransfer);
                    } else {
                        ChooseWorkspaceWithPreferenceDialog.this.selectedSettings.remove(settingsTransfer);
                    }
                }
            });
            ++i;
        }
        return enabledSettings != null && enabledSettings.length > 0;
    }

    private String[] getEnabledSettings(IDialogSettings section) {
        if (section == null) {
            return null;
        }
        return section.getArray(ENABLED_TRANSFERS);
    }

    protected void okPressed() {
        Iterator settingsIterator = this.selectedSettings.iterator();
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, IDEWorkbenchMessages.ChooseWorkspaceWithSettingsDialog_ProblemsTransferTitle, null);
        Path path = new Path(this.getWorkspaceLocation());
        String[] selectionIDs = new String[this.selectedSettings.size()];
        int index = 0;
        while (settingsIterator.hasNext()) {
            IConfigurationElement elem = (IConfigurationElement)settingsIterator.next();
            result.add(this.transferSettings(elem, (IPath)path));
            selectionIDs[index++] = elem.getAttribute(ATT_ID);
        }
        if (result.getSeverity() != 0) {
            ErrorDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.ChooseWorkspaceWithSettingsDialog_TransferFailedMessage, (String)IDEWorkbenchMessages.ChooseWorkspaceWithSettingsDialog_SaveSettingsFailed, (IStatus)result);
            return;
        }
        this.saveSettings(selectionIDs);
        super.okPressed();
    }

    private void saveSettings(String[] selectionIDs) {
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings().getSection(WORKBENCH_SETTINGS);
        if (settings == null) {
            settings = IDEWorkbenchPlugin.getDefault().getDialogSettings().addNewSection(WORKBENCH_SETTINGS);
        }
        settings.put(ENABLED_TRANSFERS, selectionIDs);
    }

    private IStatus transferSettings(final IConfigurationElement element, final IPath path) {
        final IStatus[] exceptions = new IStatus[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                try {
                    SettingsTransfer transfer = (SettingsTransfer)WorkbenchPlugin.createExtension((IConfigurationElement)element, (String)ChooseWorkspaceWithPreferenceDialog.ATT_CLASS);
                    ChooseWorkspaceWithPreferenceDialog.this.patchWorkingSets(element, path);
                    transfer.transferSettings(path);
                }
                catch (CoreException exception) {
                    exceptions[0] = exception.getStatus();
                }
            }

            public void handleException(Throwable exception) {
                exceptions[0] = StatusUtil.newStatus((int)4, (String)NLS.bind((String)IDEWorkbenchMessages.ChooseWorkspaceWithSettingsDialog_ClassCreationFailed, (Object)element.getAttribute(ChooseWorkspaceWithPreferenceDialog.ATT_CLASS)), (Throwable)exception);
            }
        });
        if (exceptions[0] != null) {
            return exceptions[0];
        }
        return Status.OK_STATUS;
    }

    protected int getDialogBoundsStrategy() {
        return 1;
    }

    private IPath getNewWorkbenchStateLocation(IPath newWorkspaceRoot) {
        IPath currentWorkspaceRoot = Platform.getLocation();
        IPath dataLocation = WorkbenchPlugin.getDefault().getDataLocation();
        if (dataLocation == null) {
            return null;
        }
        int segmentsToRemove = dataLocation.matchingFirstSegments(currentWorkspaceRoot);
        dataLocation = dataLocation.removeFirstSegments(segmentsToRemove);
        dataLocation = newWorkspaceRoot.append(dataLocation);
        return dataLocation;
    }

    private void patchWorkingSets(IConfigurationElement element, IPath path) {
        String name = element.getAttribute(ATT_NAME);
        if (name.trim().equals("Working Sets")) {
            IPath dataLocation = this.getNewWorkbenchStateLocation(path);
            if (dataLocation == null) {
                return;
            }
            File dir = new File(dataLocation.toOSString());
            dir.mkdirs();
        }
    }
}

