/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.xml.search.ui;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.portlet.core.dd.PortletDescriptorHelper;
import com.liferay.ide.xml.search.ui.AbstractResourceBundleMarkerResolution;
import com.liferay.ide.xml.search.ui.LiferayXMLSearchUI;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class AddResourceBundleFileMarkerResolution
extends AbstractResourceBundleMarkerResolution {
    private String resourceBundlePackage = "content";
    private String resourceBundleName = "Language";
    private String portletName = "";

    public AddResourceBundleFileMarkerResolution(IMarker marker, String portletName) {
        super(marker);
        this.portletName = portletName;
    }

    private void checkResourceBundleElement(IProject project) {
        PortletDescriptorHelper portletDescriptorHelper = new PortletDescriptorHelper(project);
        String[] resouceBundles = portletDescriptorHelper.getAllResourceBundles();
        if (resouceBundles.length == 0) {
            portletDescriptorHelper.addResourceBundle(String.valueOf(this.resourceBundlePackage) + "." + this.resourceBundleName, this.portletName);
        } else {
            String[] stringArray = resouceBundles;
            int n = resouceBundles.length;
            int n2 = 0;
            while (n2 < n) {
                String resouceBundle = stringArray[n2];
                if (!CoreUtil.isNullOrEmpty((String)resouceBundle)) {
                    String[] paths = resouceBundle.split("\\.");
                    if (paths.length > 2) {
                        StringBuffer sb = new StringBuffer();
                        int i = 0;
                        while (i < paths.length - 1) {
                            sb.append(paths[i]);
                            sb.append("/");
                            ++i;
                        }
                        this.resourceBundlePackage = sb.toString();
                        this.resourceBundleName = paths[paths.length - 1];
                        break;
                    }
                    if (paths.length == 2) {
                        this.resourceBundlePackage = paths[0];
                        this.resourceBundleName = paths[1];
                        break;
                    }
                    if (paths.length != 1) break;
                    this.resourceBundlePackage = "";
                    this.resourceBundleName = paths[0];
                    break;
                }
                ++n2;
            }
        }
    }

    public String getLabel() {
        return "Create a new default resource bundle add it to " + this.portletName + " portlet";
    }

    public Image getImage() {
        URL url = LiferayXMLSearchUI.getDefault().getBundle().getEntry("/icons/resource-bundle-new.png");
        return ImageDescriptor.createFromURL((URL)url).createImage();
    }

    @Override
    protected void resolve(IMarker marker) {
        IProject project = marker.getResource().getProject();
        if (this.getResourceKey(marker) == null || project == null) {
            return;
        }
        try {
            this.checkResourceBundleElement(project);
            ILiferayProject liferayProject = LiferayCore.create((Object)project);
            if (liferayProject == null) {
                return;
            }
            IFolder folder = liferayProject.getSourceFolder("resources").getFolder(this.resourceBundlePackage);
            if (!folder.exists()) {
                CoreUtil.makeFolders((IFolder)folder);
            }
            IFile resourceBundle = folder.getFile(String.valueOf(this.resourceBundleName) + ".properties");
            String resourceKey = this.getResourceKey(marker);
            if (CoreUtil.isNullOrEmpty((String)resourceKey)) {
                return;
            }
            String resourceValue = this.getDefaultResourceValue(resourceKey);
            String resourcePropertyLine = String.valueOf(resourceKey) + "=" + resourceValue + "\n";
            int contentOffset = 0;
            int resourcePropertyLineOffset = resourcePropertyLine.getBytes().length;
            if (!resourceBundle.exists()) {
                IFolder parent = (IFolder)resourceBundle.getParent();
                CoreUtil.prepareFolder((IFolder)parent);
                resourceBundle.create((InputStream)new ByteArrayInputStream(resourcePropertyLine.getBytes("UTF-8")), 1, null);
                contentOffset = resourcePropertyLineOffset;
            } else {
                String contents = CoreUtil.readStreamToString((InputStream)resourceBundle.getContents());
                StringBuffer sb = new StringBuffer();
                sb.append(contents);
                sb.append(resourcePropertyLine);
                byte[] bytes = sb.toString().trim().getBytes("UTF-8");
                contentOffset = bytes.length;
                resourceBundle.setContents((InputStream)new ByteArrayInputStream(bytes), 1, (IProgressMonitor)new NullProgressMonitor());
            }
            this.openEditor(resourceBundle, contentOffset - resourcePropertyLineOffset, contentOffset - 1);
        }
        catch (Exception e) {
            LiferayXMLSearchUI.logError(e);
        }
    }
}

