/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.xml.search.ui;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.xml.search.ui.AbstractResourceBundleMarkerResolution;
import com.liferay.ide.xml.search.ui.LiferayXMLSearchUI;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class AddResourceKeyMarkerResolution
extends AbstractResourceBundleMarkerResolution {
    private IFile resourceBundle = null;

    public AddResourceKeyMarkerResolution(IMarker marker, IFile languageFile) {
        super(marker);
        this.resourceBundle = languageFile;
    }

    public String getLabel() {
        StringBuffer sb = new StringBuffer();
        sb.append("Add missing key to ");
        sb.append(this.resourceBundle.getProjectRelativePath().toString());
        return sb.toString();
    }

    public Image getImage() {
        URL url = LiferayXMLSearchUI.getDefault().getBundle().getEntry("/icons/resource-bundle.png");
        return ImageDescriptor.createFromURL((URL)url).createImage();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void resolve(IMarker marker) {
        String message = marker.getAttribute("message", "");
        if (message == null) return;
        if (this.resourceBundle == null) {
            return;
        }
        InputStream is = null;
        try {
            is = this.resourceBundle.getContents();
            String languageKey = this.getResourceKey(marker);
            if (CoreUtil.isNullOrEmpty((String)languageKey)) {
                return;
            }
            Properties properties = new Properties();
            properties.load(is);
            if (properties.get(languageKey) != null) {
                return;
            }
            String resourceValue = this.getDefaultResourceValue(languageKey);
            String resourcePropertyLine = String.valueOf(languageKey) + "=" + resourceValue;
            String contents = CoreUtil.readStreamToString((InputStream)this.resourceBundle.getContents());
            StringBuffer contentSb = new StringBuffer();
            contentSb.append(contents);
            if (!contents.endsWith("\n")) {
                contentSb.append("\n");
            }
            contentSb.append(resourcePropertyLine);
            byte[] bytes = contentSb.toString().trim().getBytes("UTF-8");
            int contentOffset = bytes.length;
            int resourcePropertyLineOffset = resourcePropertyLine.getBytes().length;
            this.resourceBundle.setContents((InputStream)new ByteArrayInputStream(bytes), 1, (IProgressMonitor)new NullProgressMonitor());
            this.openEditor(this.resourceBundle, contentOffset - resourcePropertyLineOffset, contentOffset - 1);
            return;
        }
        catch (Exception e) {
            LiferayXMLSearchUI.logError(e);
            return;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

