/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.xml.search.ui.editor;

import com.liferay.ide.xml.search.ui.TempMarker;
import com.liferay.ide.xml.search.ui.editor.CompoundRegion;
import com.liferay.ide.xml.search.ui.editor.InfoRegion;
import com.liferay.ide.xml.search.ui.editor.MarkerRegion;
import com.liferay.ide.xml.search.ui.editor.TemporaryRegion;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;

public class LiferayCustomXmlHoverControl
extends AbstractInformationControl
implements IInformationControlExtension2,
IInformationControlExtension3,
IInformationControlExtension5 {
    private static final String ONE_QUICK_FIX = "1 quick fix available:";
    private static final String MULTIPLE_QUICK_FIXES = "{0} quick fixes available:";
    private CompoundRegion region;
    private Control focusControl;
    private Composite parent;
    private final DefaultMarkerAnnotationAccess markerAccess = new DefaultMarkerAnnotationAccess();

    public LiferayCustomXmlHoverControl(Shell shell) {
        super(shell, EditorsUI.getTooltipAffordanceString());
        this.create();
    }

    private void apply(ICompletionProposal p, ITextViewer viewer, int offset, boolean isMultiFix) {
        this.dispose();
        IRewriteTarget target = null;
        try {
            try {
                ICompletionProposalExtension2 e;
                IDocument document = viewer.getDocument();
                if (viewer instanceof ITextViewerExtension) {
                    ITextViewerExtension extension = (ITextViewerExtension)viewer;
                    target = extension.getRewriteTarget();
                }
                if (target != null) {
                    target.beginCompoundChange();
                }
                if (p instanceof ICompletionProposalExtension2) {
                    e = (ICompletionProposalExtension2)p;
                    e.apply(viewer, '\u0000', isMultiFix ? 262144 : 0, offset);
                } else if (p instanceof ICompletionProposalExtension) {
                    e = (ICompletionProposalExtension)p;
                    e.apply(document, '\u0000', offset);
                } else {
                    p.apply(document);
                }
                Point selection = p.getSelection(document);
                if (selection != null) {
                    viewer.setSelectedRange(selection.x, selection.y);
                    viewer.revealRange(selection.x, selection.y);
                }
            }
            catch (Exception exception) {
                if (target != null) {
                    target.endCompoundChange();
                }
            }
        }
        finally {
            if (target != null) {
                target.endCompoundChange();
            }
        }
    }

    private void apply(IMarkerResolution res, IMarker mark, ITextViewer viewer, int offset) {
        if (res instanceof ICompletionProposal) {
            this.apply((ICompletionProposal)res, viewer, offset, false);
        } else {
            this.dispose();
            res.run(mark);
        }
    }

    public Point computeSizeHint() {
        Point preferedSize = this.getShell().computeSize(-1, -1, true);
        Point constrains = this.getSizeConstraints();
        if (constrains == null) {
            return preferedSize;
        }
        Point constrainedSize = this.getShell().computeSize(constrains.x, -1, true);
        int width = Math.min(preferedSize.x, constrainedSize.x);
        int height = Math.max(preferedSize.y, constrainedSize.y);
        return new Point(width, height);
    }

    private void createAnnotationInformation(Composite parent, final Annotation annotation) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        final Canvas canvas = new Canvas(composite, 524288);
        GridData gridData = new GridData(1, 1, false, false);
        gridData.widthHint = 17;
        gridData.heightHint = 16;
        canvas.setLayoutData((Object)gridData);
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setFont(null);
                LiferayCustomXmlHoverControl.this.markerAccess.paint(annotation, e.gc, canvas, new Rectangle(0, 0, 16, 16));
            }
        });
        StyledText text = new StyledText(composite, 74);
        GridData data = new GridData(4, 4, true, true);
        text.setLayoutData((Object)data);
        String annotationText = annotation.getText();
        if (annotationText != null) {
            text.setText(annotationText);
        }
    }

    private Link createCompletionProposalLink(Composite parent, final IMarker mark, final IMarkerResolution proposal, int count) {
        boolean isMultiFix;
        boolean bl = isMultiFix = count > 1;
        if (isMultiFix) {
            new Label(parent, 0);
            parent = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            parent.setLayout((Layout)layout);
        }
        Label proposalImage = new Label(parent, 0);
        proposalImage.setLayoutData((Object)new GridData(1, 128, false, false));
        Image image = null;
        if (proposal instanceof ICompletionProposal) {
            image = ((ICompletionProposal)proposal).getImage();
        } else if (proposal instanceof IMarkerResolution2) {
            image = ((IMarkerResolution2)proposal).getImage();
        }
        if (image != null) {
            proposalImage.setImage(image);
            proposalImage.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (e.button == 1) {
                        LiferayCustomXmlHoverControl.this.apply(proposal, mark, ((LiferayCustomXmlHoverControl)LiferayCustomXmlHoverControl.this).region.textViewer, ((LiferayCustomXmlHoverControl)LiferayCustomXmlHoverControl.this).region.textOffset);
                    }
                }
            });
        }
        Link proposalLink = new Link(parent, 64);
        GridData layoutData = new GridData(1, 128, false, false);
        String linkText = proposal.getLabel();
        proposalLink.setText("<a>" + linkText + "</a>");
        proposalLink.setLayoutData((Object)layoutData);
        proposalLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LiferayCustomXmlHoverControl.this.apply(proposal, mark, ((LiferayCustomXmlHoverControl)LiferayCustomXmlHoverControl.this).region.textViewer, ((LiferayCustomXmlHoverControl)LiferayCustomXmlHoverControl.this).region.textOffset);
            }
        });
        return proposalLink;
    }

    protected void createContent(Composite parent) {
        this.parent = parent;
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
    }

    private void createResolutionsControl(Composite parent, IMarker marker, IMarkerResolution[] resolutions) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.verticalSpacing = 2;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Label quickFixLabel = new Label(composite, 0);
        GridData layoutData = new GridData(1, 128, false, false);
        layoutData.horizontalIndent = 4;
        quickFixLabel.setLayoutData((Object)layoutData);
        String text = resolutions.length == 1 ? ONE_QUICK_FIX : NLS.bind((String)MULTIPLE_QUICK_FIXES, (Object)String.valueOf(resolutions.length));
        quickFixLabel.setText(text);
        Composite composite2 = new Composite(parent, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginLeft = 5;
        layout2.verticalSpacing = 2;
        composite2.setLayout((Layout)layout2);
        ArrayList<Link> list = new ArrayList<Link>();
        IMarkerResolution[] iMarkerResolutionArray = resolutions;
        int n = resolutions.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerResolution resolution = iMarkerResolutionArray[n2];
            list.add(this.createCompletionProposalLink(composite2, marker, resolution, 1));
            ++n2;
        }
        final Link[] links = list.toArray(new Link[0]);
        this.focusControl = links[0];
        int i = 0;
        while (i < links.length) {
            final int index = i++;
            Link link = links[index];
            link.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    switch (e.keyCode) {
                        case 0x1000002: {
                            if (index + 1 >= links.length) break;
                            links[index + 1].setFocus();
                            break;
                        }
                        case 0x1000001: {
                            if (index <= 0) break;
                            links[index - 1].setFocus();
                            break;
                        }
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
        }
    }

    protected void deferredCreateContent() {
        if (this.region != null) {
            ScrolledComposite scrolledComposite = new ScrolledComposite(this.parent, 512);
            GridData gridData = new GridData(4, 4, true, true);
            scrolledComposite.setLayoutData((Object)gridData);
            scrolledComposite.setExpandVertical(false);
            scrolledComposite.setExpandHorizontal(false);
            Composite composite = new Composite((Composite)scrolledComposite, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout layout = new GridLayout(1, false);
            composite.setLayout((Layout)layout);
            scrolledComposite.setContent((Control)composite);
            for (IRegion reg : this.region.getRegions()) {
                String text;
                IMarkerResolution[] resolutions;
                IMarker marker;
                if (reg instanceof MarkerRegion) {
                    MarkerRegion markerReg = (MarkerRegion)reg;
                    this.createAnnotationInformation(composite, (Annotation)markerReg.getAnnotation());
                    marker = markerReg.getAnnotation().getMarker();
                    resolutions = IDE.getMarkerHelpRegistry().getResolutions(marker);
                    if (resolutions.length <= 0) continue;
                    this.createResolutionsControl(composite, marker, resolutions);
                    continue;
                }
                if (reg instanceof TemporaryRegion) {
                    TemporaryRegion tempReg = (TemporaryRegion)reg;
                    this.createAnnotationInformation(composite, (Annotation)tempReg.getAnnotation());
                    marker = new TempMarker(tempReg.getAnnotation());
                    resolutions = IDE.getMarkerHelpRegistry().getResolutions(marker);
                    if (resolutions.length <= 0) continue;
                    this.createResolutionsControl(composite, marker, resolutions);
                    continue;
                }
                if (!(reg instanceof InfoRegion) || (text = ((InfoRegion)reg).getInfo()) == null) continue;
                this.setInformation(composite, text);
            }
            Point constraints = this.getSizeConstraints();
            Point contentSize = composite.computeSize(constraints != null ? constraints.x : -1, -1);
            composite.setSize(new Point(contentSize.x, contentSize.y));
        }
        this.setColorAndFont((Control)this.parent, this.parent.getForeground(), this.parent.getBackground(), JFaceResources.getDialogFont());
        this.parent.layout(true);
    }

    protected void disposeDeferredCreatedContent() {
        Control[] children;
        Control[] controlArray = children = this.parent.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        ToolBarManager toolBarManager = this.getToolBarManager();
        if (toolBarManager != null) {
            toolBarManager.removeAll();
        }
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new LiferayCustomXmlHoverControl(parent);
            }
        };
    }

    Shell getMyShell() {
        return super.getShell();
    }

    Control getRoot() {
        return this.parent;
    }

    public boolean hasContents() {
        return this.region != null;
    }

    private void setColorAndFont(Control control, Color foreground, Color background, Font font) {
        control.setForeground(foreground);
        control.setBackground(background);
        control.setFont(font);
        if (control instanceof Composite) {
            Control[] children;
            Control[] controlArray = children = ((Composite)control).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.setColorAndFont(child, foreground, background, font);
                ++n2;
            }
        }
    }

    public void setFocus() {
        super.setFocus();
        if (this.focusControl != null) {
            this.focusControl.setFocus();
        }
    }

    private void setInformation(Composite composite, String content) {
        HTMLTextPresenter presenter = new HTMLTextPresenter(true);
        TextPresentation presentation = new TextPresentation();
        int maxWidth = -1;
        int maxHeight = -1;
        Point constraints = this.getSizeConstraints();
        StyledText styledText = new StyledText(composite, 74);
        int innerBorder = 1;
        if (constraints != null) {
            maxWidth = constraints.x;
            maxHeight = constraints.y;
            if (styledText.getWordWrap()) {
                maxWidth -= innerBorder * 2;
                maxHeight -= innerBorder * 2;
            } else {
                maxWidth -= innerBorder;
            }
            Rectangle trim = this.computeTrim();
            maxWidth -= trim.width;
            maxHeight -= trim.height;
            maxWidth -= styledText.getCaret().getSize().x;
        }
        if (this.isResizable()) {
            maxHeight = Integer.MAX_VALUE;
        }
        if (presenter instanceof DefaultInformationControl.IInformationPresenterExtension) {
            content = presenter.updatePresentation((Drawable)styledText, content, presentation, maxWidth, maxHeight);
        }
        if (content != null) {
            styledText.setText(content);
            TextPresentation.applyTextPresentation((TextPresentation)presentation, (StyledText)styledText);
        } else {
            styledText.setText("");
        }
    }

    public void setInput(Object input) {
        if (!(input instanceof CompoundRegion)) {
            return;
        }
        this.region = (CompoundRegion)input;
        this.disposeDeferredCreatedContent();
        this.deferredCreateContent();
    }

    public final void setVisible(boolean visible) {
        if (!visible) {
            this.disposeDeferredCreatedContent();
        }
        super.setVisible(visible);
    }
}

