/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.tomcat.core;

import com.liferay.ide.core.ILiferayConstants;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.tomcat.core.ILiferayTomcatConfiguration;
import com.liferay.ide.server.tomcat.core.ILiferayTomcatConstants;
import com.liferay.ide.server.tomcat.core.ILiferayTomcatHandler;
import com.liferay.ide.server.tomcat.core.ILiferayTomcatServer;
import com.liferay.ide.server.tomcat.core.ILiferayTomcatServerWC;
import com.liferay.ide.server.tomcat.core.LiferayTomcat60Configuration;
import com.liferay.ide.server.tomcat.core.LiferayTomcat70Configuration;
import com.liferay.ide.server.tomcat.core.LiferayTomcatPlugin;
import com.liferay.ide.server.tomcat.core.LiferayTomcatRuntime;
import com.liferay.ide.server.tomcat.core.util.LiferayTomcatUtil;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatVersionHandler;
import org.eclipse.jst.server.tomcat.core.internal.TomcatConfiguration;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.osgi.framework.Version;

public class LiferayTomcatServer
extends TomcatServer
implements ILiferayTomcatConstants,
ILiferayTomcatServer,
ILiferayTomcatServerWC {
    public String getId() {
        return this.getServer().getId();
    }

    public String getHost() {
        return this.getServer().getHost();
    }

    @Override
    public String getAutoDeployDirectory() {
        return this.getAttribute("autoDeployDir", "../deploy");
    }

    @Override
    public String getAutoDeployInterval() {
        return this.getAttribute("autoDeployInterval", ILiferayTomcatConstants.DEFAULT_AUTO_DEPLOY_INTERVAL);
    }

    public int getDefaultServerMode() {
        int defaultServerMode = 1;
        try {
            String version = LiferayTomcatUtil.getVersion((ILiferayRuntime)this.getServer().getRuntime());
            Version portalVersion = Version.parseVersion((String)version);
            if (CoreUtil.compareVersions((Version)portalVersion, (Version)ILiferayConstants.V620) < 0) {
                defaultServerMode = 2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultServerMode;
    }

    @Override
    public String getExternalProperties() {
        return this.getAttribute("externalProperties", "");
    }

    @Override
    public String getMemoryArgs() {
        return this.getAttribute("memoryArgs", ILiferayTomcatConstants.DEFAULT_MEMORY_ARGS);
    }

    public URL getPluginContextURL(String context) {
        try {
            return new URL(this.getPortalHomeUrl(), "/" + context);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getHttpPort() {
        try {
            return String.valueOf(this.getTomcatConfiguration().getMainPort().getPort());
        }
        catch (CoreException e) {
            return null;
        }
    }

    public URL getPortalHomeUrl() {
        TomcatConfiguration config;
        block4: {
            try {
                config = this.getTomcatConfiguration();
                if (config != null) break block4;
                return null;
            }
            catch (Exception ex) {
                return null;
            }
        }
        String url = "http://" + this.getServer().getHost();
        int port = config.getMainPort().getPort();
        port = ServerUtil.getMonitoredPort((IServer)this.getServer(), (int)port, (String)"web");
        if (port != 80) {
            url = String.valueOf(url) + ":" + port;
        }
        return new URL(url);
    }

    public String getPassword() {
        return this.getAttribute("password", DEFAULT_PASSWORD);
    }

    public ILiferayTomcatConfiguration getLiferayTomcatConfiguration() throws CoreException {
        return (ILiferayTomcatConfiguration)this.getTomcatConfiguration();
    }

    @Override
    public boolean getUseDefaultPortalServerSettings() {
        return this.getAttribute("useDefaultPortalServerSettings", false);
    }

    @Override
    public int getServerMode() {
        return this.getAttribute("serverMode", this.getDefaultServerMode());
    }

    public TomcatConfiguration getTomcatConfiguration() throws CoreException {
        if (this.configuration == null) {
            IFolder folder = this.getServer().getServerConfiguration();
            if (folder == null || !folder.exists()) {
                String path = null;
                if (folder != null) {
                    path = folder.getFullPath().toOSString();
                    IProject project = folder.getProject();
                    if (project != null && project.exists() && !project.isOpen()) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Msgs.errorConfigurationProjectClosed, (Object)path, (Object)project.getName()), null));
                    }
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Msgs.errorNoConfiguration, (Object)path), null));
            }
            String id = this.getServer().getServerType().getId();
            if (id.endsWith("60")) {
                this.configuration = new LiferayTomcat60Configuration(folder);
            } else if (id.endsWith("70") || id.endsWith("7062")) {
                this.configuration = new LiferayTomcat70Configuration(folder);
            }
            try {
                ((ILiferayTomcatConfiguration)this.configuration).load(folder, null);
            }
            catch (CoreException ce) {
                this.configuration = null;
                throw ce;
            }
        }
        return this.configuration;
    }

    public ITomcatVersionHandler getTomcatVersionHandler() {
        ITomcatVersionHandler handler = super.getTomcatVersionHandler();
        if (handler instanceof ILiferayTomcatHandler) {
            ((ILiferayTomcatHandler)handler).setCurrentServer(this.getServer());
        }
        return handler;
    }

    public String getUsername() {
        return this.getAttribute("username", DEFAULT_USERNAME);
    }

    @Override
    public String getUserTimezone() {
        return this.getAttribute("userTimezone", ILiferayTomcatConstants.DEFAULT_USER_TIMEZONE);
    }

    public URL getWebServicesListURL() {
        try {
            return new URL(this.getPortalHomeUrl(), "/tunnel-web/axis");
        }
        catch (MalformedURLException e) {
            LiferayTomcatPlugin.logError("Unable to get web services list URL", e);
            return null;
        }
    }

    public void importRuntimeConfiguration(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        if (runtime == null) {
            this.configuration = null;
            return;
        }
        IPath path = runtime.getLocation().append("conf");
        String id = this.getServer().getServerType().getId();
        IFolder folder = this.getServer().getServerConfiguration();
        if (id.endsWith("60")) {
            this.configuration = new LiferayTomcat60Configuration(folder);
        } else if (id.endsWith("70") || id.endsWith("7062")) {
            this.configuration = new LiferayTomcat70Configuration(folder);
        }
        if (path.toFile().exists()) {
            try {
                this.configuration.importFromPath(path, this.isTestEnvironment(), monitor);
            }
            catch (CoreException ce) {
                this.configuration = null;
                throw ce;
            }
        }
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
        boolean addingExt = false;
        boolean removingExt = false;
        if (!CoreUtil.isNullOrEmpty((Object[])add)) {
            IModule[] iModuleArray = add;
            int n = add.length;
            int n2 = 0;
            while (n2 < n) {
                IModule m = iModuleArray[n2];
                if (m.getProject() != null && ProjectUtil.isExtProject((IProject)m.getProject())) {
                    addingExt = true;
                    break;
                }
                ++n2;
            }
        } else if (!CoreUtil.isNullOrEmpty((Object[])remove)) {
            IModule[] iModuleArray = remove;
            int n = remove.length;
            int n3 = 0;
            while (n3 < n) {
                IModule m = iModuleArray[n3];
                if (m.getProject() != null && ProjectUtil.isExtProject((IProject)m.getProject())) {
                    removingExt = true;
                    break;
                }
                ++n3;
            }
        }
        if (!addingExt && removingExt) {
            LiferayTomcatUtil.displayToggleMessage(Msgs.removingExtPlugin, "REMOVE_EXT_PLUGIN_TOGGLE_KEY");
        }
        super.modifyModules(add, remove, monitor);
    }

    public void saveConfiguration(IProgressMonitor monitor) throws CoreException {
        LiferayTomcatRuntime portalRuntime = (LiferayTomcatRuntime)this.getServer().getRuntime().loadAdapter(LiferayTomcatRuntime.class, monitor);
        String serverInfo = portalRuntime.getServerInfo();
        String expectedServerInfo = portalRuntime.getExpectedServerInfo();
        if (serverInfo != null && expectedServerInfo != null && serverInfo.contains(Msgs.enterpriseEdition) && !expectedServerInfo.contains(Msgs.enterpriseEdition)) {
            LiferayTomcatUtil.displayToggleMessage(Msgs.switchRuntimeType, "EE_UPGRADE_MSG_TOGGLE_KEY");
        }
        super.saveConfiguration(monitor);
    }

    public void setAutoDeployDirectory(String dir) {
        this.setAttribute("autoDeployDir", dir);
    }

    public void setAutoDeployInterval(String interval) {
        this.setAttribute("autoDeployInterval", interval);
    }

    public void setDefaults(IProgressMonitor monitor) {
        super.setDefaults(monitor);
        this.setTestEnvironment(false);
        this.setDeployDirectory("webapps");
        this.setSaveSeparateContextFiles(false);
    }

    public void setExternalProperties(String externalProperties) {
        this.setAttribute("externalProperties", externalProperties);
    }

    @Override
    public void setMemoryArgs(String memoryArgs) {
        this.setAttribute("memoryArgs", memoryArgs);
    }

    public void setPassword(String password) {
        this.setAttribute("password", password);
    }

    public void setUseDefaultPortalServerSettings(boolean useDefaultPortalServerSettings) {
        this.setAttribute("useDefaultPortalServerSettings", useDefaultPortalServerSettings);
    }

    public void setServerMode(int serverMode) {
        this.setAttribute("serverMode", serverMode);
    }

    public void setUsername(String username) {
        this.setAttribute("username", username);
    }

    @Override
    public void setUserTimezone(String userTimezone) {
        this.setAttribute("userTimezone", userTimezone);
    }

    protected IEclipsePreferences getPrefStore() {
        return LiferayTomcatPlugin.getPreferenceStore();
    }

    private static class Msgs
    extends NLS {
        public static String enterpriseEdition;
        public static String errorConfigurationProjectClosed;
        public static String errorNoConfiguration;
        public static String removingExtPlugin;
        public static String switchRuntimeType;

        static {
            Msgs.initializeMessages((String)LiferayTomcatServer.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

