/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.tomcat.core.util;

import com.liferay.ide.core.ILiferayConstants;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileListing;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.core.IPluginPublisher;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.tomcat.core.ILiferayTomcatConstants;
import com.liferay.ide.server.tomcat.core.ILiferayTomcatRuntime;
import com.liferay.ide.server.tomcat.core.ILiferayTomcatServer;
import com.liferay.ide.server.tomcat.core.LiferayTomcatPlugin;
import com.liferay.ide.server.tomcat.core.LiferayTomcatRuntime70;
import com.liferay.ide.server.tomcat.core.LiferayTomcatServerBehavior;
import com.liferay.ide.server.tomcat.core.util.ExternalPropertiesConfiguration;
import com.liferay.ide.server.util.LiferayPortalValueLoader;
import com.liferay.ide.server.util.ServerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jst.server.tomcat.core.internal.TomcatVersionHelper;
import org.eclipse.jst.server.tomcat.core.internal.xml.Factory;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Context;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.ServerInstance;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.osgi.framework.Version;

public class LiferayTomcatUtil {
    private static String CONFIG_DIR = "conf";
    public static final String CONFIG_TYPE_SERVER = "server";
    public static final String CONFIG_TYPE_VERSION = "version";
    private static String DEFAULT_PORTAL_CONTEXT_FILE = "ROOT.xml";
    private static String DEFAULT_PORTAL_DIR = "/webapps/ROOT";
    private static String HOST_NAME = "localhost";
    private static final Version MANIFEST_VERSION_REQUIRED = ILiferayConstants.V620;
    private static String SERVICE_NAME = "Catalina";

    public static void addRuntimeVMArgments(List<String> runtimeVMArgs, IPath installPath, IPath configPath, IPath deployPath, boolean isTestEnv, IServer currentServer, ILiferayTomcatServer liferayTomcatServer) {
        runtimeVMArgs.add("-Dfile.encoding=UTF8");
        runtimeVMArgs.add("-Dorg.apache.catalina.loader.WebappClassLoader.ENABLE_CLEAR_REFERENCES=false");
        runtimeVMArgs.add("-Djava.util.logging.manager=org.apache.juli.ClassLoaderLogManager");
        ILiferayRuntime runtime = ServerUtil.getLiferayRuntime((IServer)currentServer);
        Version portalVersion = new Version(LiferayTomcatUtil.getVersion(runtime));
        if (CoreUtil.compareVersions((Version)portalVersion, (Version)LiferayTomcatRuntime70.leastSupportedVersion) < 0) {
            runtimeVMArgs.add("-Djava.security.auth.login.config=\"" + configPath.toOSString() + "/conf/jaas.config\"");
        } else {
            runtimeVMArgs.add("-Djava.net.preferIPv4Stack=true");
        }
        runtimeVMArgs.add("-Djava.util.logging.config.file=\"" + installPath.toOSString() + "/conf/logging.properties\"");
        runtimeVMArgs.add("-Djava.io.tmpdir=\"" + installPath.toOSString() + "/temp\"");
        boolean useDefaultPortalServerSettings = liferayTomcatServer.getUseDefaultPortalServerSettings();
        if (useDefaultPortalServerSettings) {
            LiferayTomcatUtil.addUserDefaultVMArgs(runtimeVMArgs);
        } else {
            LiferayTomcatUtil.addUserVMArgs(runtimeVMArgs, currentServer, liferayTomcatServer);
            File externalPropertiesFile = LiferayTomcatUtil.getExternalPropertiesFile(installPath, configPath, currentServer, liferayTomcatServer);
            runtimeVMArgs.add("-Dexternal-properties=\"" + externalPropertiesFile.getAbsolutePath() + "\"");
        }
    }

    private static void addUserDefaultVMArgs(List<String> runtimeVMArgs) {
        String[] memoryArgs = ILiferayTomcatConstants.DEFAULT_MEMORY_ARGS.split(" ");
        if (memoryArgs != null) {
            String[] stringArray = memoryArgs;
            int n = memoryArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                runtimeVMArgs.add(arg);
                ++n2;
            }
        }
    }

    private static void addUserVMArgs(List<String> runtimeVMArgs, IServer currentServer, ILiferayTomcatServer portalTomcatServer) {
        String[] memoryArgs = ILiferayTomcatConstants.DEFAULT_MEMORY_ARGS.split(" ");
        String userTimezone = ILiferayTomcatConstants.DEFAULT_USER_TIMEZONE;
        if (currentServer != null && portalTomcatServer != null) {
            memoryArgs = DebugPlugin.parseArguments((String)portalTomcatServer.getMemoryArgs());
            userTimezone = portalTomcatServer.getUserTimezone();
        }
        if (memoryArgs != null) {
            String[] stringArray = memoryArgs;
            int n = memoryArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                runtimeVMArgs.add(arg);
                ++n2;
            }
        }
        runtimeVMArgs.add("-Duser.timezone=" + userTimezone);
    }

    public static IStatus canAddModule(IModule module, IServer currentServer) {
        IProjectFacet liferayFacet;
        IFacetedProject facetedProject;
        IProject project = module.getProject();
        if (project != null && (facetedProject = ProjectUtil.getFacetedProject((IProject)project)) != null && (liferayFacet = ProjectUtil.getLiferayFacet((IFacetedProject)facetedProject)) != null) {
            IStatus status;
            IPluginPublisher pluginPublisher;
            String facetId = liferayFacet.getId();
            IRuntime runtime = null;
            try {
                runtime = ServerUtil.getRuntime((IProject)project);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (runtime != null && (pluginPublisher = LiferayServerCore.getPluginPublisher((String)facetId, (String)runtime.getRuntimeType().getId())) != null && !(status = pluginPublisher.canPublishModule(currentServer, module)).isOK()) {
                return status;
            }
        }
        return Status.OK_STATUS;
    }

    protected static IPath checkAndReturnCustomPortalDir(IPath appServerDir) {
        IPath retval = null;
        if (appServerDir != null) {
            String docBase;
            Context tcPortalContext;
            File contextFile = appServerDir.append(CONFIG_DIR).append(SERVICE_NAME).append(HOST_NAME).append(DEFAULT_PORTAL_CONTEXT_FILE).toFile();
            if (contextFile.exists() && (tcPortalContext = LiferayTomcatUtil.loadContextFile(contextFile)) != null && (docBase = tcPortalContext.getDocBase()) != null) {
                return new Path(docBase);
            }
            if (retval == null) {
                retval = appServerDir.append(DEFAULT_PORTAL_DIR);
            }
        }
        return retval;
    }

    public static void displayToggleMessage(String msg, String key) {
    }

    private static File ensurePortalIDEPropertiesExists(IPath installPath, IPath configPath, IServer currentServer, ILiferayTomcatServer portalServer) {
        IPath idePropertiesPath = installPath.append("../portal-ide.properties");
        String hostName = "localhost";
        try {
            ServerInstance server = TomcatVersionHelper.getCatalinaServerInstance((IPath)configPath.append("conf/server.xml"), null, null);
            hostName = server.getHost().getName();
        }
        catch (Exception e) {
            LiferayTomcatPlugin.logError(e);
        }
        Properties props = new Properties();
        if (portalServer != null && portalServer.getServerMode() == 2) {
            props.put("include-and-override", "portal-developer.properties");
        }
        props.put("com.liferay.portal.servlet.filters.etag.ETagFilter", "false");
        props.put("com.liferay.portal.servlet.filters.header.HeaderFilter", "false");
        props.put("json.service.auth.token.enabled", "false");
        props.put("auto.deploy.tomcat.conf.dir", configPath.append("conf/Catalina/" + hostName).toOSString());
        if (currentServer != null && portalServer != null) {
            IPath runtimLocation = currentServer.getRuntime().getLocation();
            String autoDeployDir = portalServer.getAutoDeployDirectory();
            if (!"../deploy".equals(autoDeployDir)) {
                Path autoDeployDirPath = new Path(autoDeployDir);
                if (autoDeployDirPath.isAbsolute() && autoDeployDirPath.toFile().exists()) {
                    props.put("auto.deploy.deploy.dir", portalServer.getAutoDeployDirectory());
                } else {
                    File autoDeployDirFile = new File(runtimLocation.toFile(), autoDeployDir);
                    if (autoDeployDirFile.exists()) {
                        props.put("auto.deploy.deploy.dir", autoDeployDirFile.getPath());
                    }
                }
            }
            props.put("auto.deploy.interval", portalServer.getAutoDeployInterval());
        }
        props.put("jsonws.web.service.public.methods", "*");
        File file = idePropertiesPath.toFile();
        try {
            props.store(new FileOutputStream(file), null);
        }
        catch (Exception e) {
            LiferayTomcatPlugin.logError(e);
        }
        return file;
    }

    public static IPath[] getAllUserClasspathLibraries(IPath runtimeLocation, IPath portalDir) {
        ArrayList<Path> libs = new ArrayList<Path>();
        IPath libFolder = runtimeLocation.append("lib");
        IPath extLibFolder = runtimeLocation.append("lib/ext");
        IPath webinfLibFolder = portalDir.append("WEB-INF/lib");
        try {
            List libFiles = FileListing.getFileListing((File)new File(libFolder.toOSString()));
            for (File lib : libFiles) {
                if (!lib.exists() || !lib.getName().endsWith(".jar")) continue;
                libs.add(new Path(lib.getPath()));
            }
            List extLibFiles = FileListing.getFileListing((File)new File(extLibFolder.toOSString()));
            for (File lib : extLibFiles) {
                if (!lib.exists() || !lib.getName().endsWith(".jar")) continue;
                libs.add(new Path(lib.getPath()));
            }
            libFiles = FileListing.getFileListing((File)new File(webinfLibFolder.toOSString()));
            for (File lib : libFiles) {
                if (!lib.exists() || !lib.getName().endsWith(".jar")) continue;
                libs.add(new Path(lib.getPath()));
            }
        }
        catch (FileNotFoundException e) {
            LiferayTomcatPlugin.logError(e);
        }
        return libs.toArray(new IPath[0]);
    }

    public static String getConfigInfoFromCache(String configType, IPath portalDir) {
        IPath configInfoPath = null;
        if (configType.equals(CONFIG_TYPE_VERSION)) {
            configInfoPath = LiferayTomcatPlugin.getDefault().getStateLocation().append("version.properties");
        } else if (configType.equals(CONFIG_TYPE_SERVER)) {
            configInfoPath = LiferayTomcatPlugin.getDefault().getStateLocation().append("serverInfos.properties");
        } else {
            return null;
        }
        File configInfoFile = configInfoPath.toFile();
        String portalDirKey = CoreUtil.createStringDigest((String)portalDir.toPortableString());
        Properties properties = new Properties();
        if (configInfoFile.exists()) {
            try {
                FileInputStream fileInput = new FileInputStream(configInfoFile);
                properties.load(fileInput);
                fileInput.close();
                String configInfo = (String)properties.get(portalDirKey);
                if (!CoreUtil.isNullOrEmpty((String)configInfo)) {
                    return configInfo;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getConfigInfoFromManifest(String configType, IPath portalDir) {
        File implJar = portalDir.append("WEB-INF/lib/portal-impl.jar").toFile();
        String version = null;
        String serverInfo = null;
        if (implJar.exists()) {
            try {
                JarFile jar = new JarFile(implJar);
                Manifest manifest = jar.getManifest();
                Attributes attributes = manifest.getMainAttributes();
                version = attributes.getValue("Liferay-Portal-Version");
                serverInfo = attributes.getValue("Liferay-Portal-Server-Info");
                if (CoreUtil.compareVersions((Version)Version.parseVersion((String)version), (Version)MANIFEST_VERSION_REQUIRED) < 0) {
                    version = null;
                    serverInfo = null;
                }
            }
            catch (IOException e) {
                LiferayTomcatPlugin.logError(e);
            }
        }
        if (configType.equals(CONFIG_TYPE_VERSION)) {
            return version;
        }
        if (configType.equals(CONFIG_TYPE_SERVER)) {
            return serverInfo;
        }
        return null;
    }

    private static File getExternalPropertiesFile(IPath installPath, IPath configPath, IServer currentServer, ILiferayTomcatServer portalServer) {
        File retval = null;
        if (portalServer != null) {
            File externalPropertiesFile;
            File portalIdePropFile;
            retval = portalIdePropFile = LiferayTomcatUtil.ensurePortalIDEPropertiesExists(installPath, configPath, currentServer, portalServer);
            String externalProperties = portalServer.getExternalProperties();
            if (!CoreUtil.isNullOrEmpty((String)externalProperties) && (externalPropertiesFile = LiferayTomcatUtil.setupExternalPropertiesFile(portalIdePropFile, externalProperties)) != null) {
                retval = externalPropertiesFile;
            }
        }
        return retval;
    }

    public static ILiferayTomcatRuntime getLiferayTomcatRuntime(IRuntime runtime) {
        if (runtime != null) {
            return (ILiferayTomcatRuntime)runtime.createWorkingCopy().loadAdapter(ILiferayTomcatRuntime.class, null);
        }
        return null;
    }

    public static IPath getPortalDir(IPath appServerDir) {
        return LiferayTomcatUtil.checkAndReturnCustomPortalDir(appServerDir);
    }

    public static String getVersion(ILiferayRuntime runtime) {
        String version = LiferayTomcatUtil.getConfigInfoFromCache(CONFIG_TYPE_VERSION, runtime.getAppServerPortalDir());
        if (version == null) {
            LiferayPortalValueLoader loader;
            Version loadedVersion;
            version = LiferayTomcatUtil.getConfigInfoFromManifest(CONFIG_TYPE_VERSION, runtime.getAppServerPortalDir());
            if (version == null && (loadedVersion = (loader = new LiferayPortalValueLoader(runtime.getUserLibs())).loadVersionFromClass()) != null) {
                version = loadedVersion.toString();
            }
            if (version != null) {
                LiferayTomcatUtil.saveConfigInfoIntoCache(CONFIG_TYPE_VERSION, version, runtime.getAppServerPortalDir());
            }
        }
        return version;
    }

    public static boolean isExtProjectContext(Context context) {
        return false;
    }

    public static boolean isLiferayModule(IModule module) {
        boolean retval = false;
        if (module != null) {
            IProject project = module.getProject();
            retval = ProjectUtil.isLiferayFacetedProject((IProject)project);
        }
        return retval;
    }

    public static Context loadContextFile(File contextFile) {
        FileInputStream fis = null;
        Context context = null;
        if (contextFile != null && contextFile.exists()) {
            try {
                try {
                    String path;
                    Factory factory = new Factory();
                    factory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server40");
                    fis = new FileInputStream(contextFile);
                    context = (Context)factory.loadDocument((InputStream)fis);
                    if (context != null && (path = context.getPath()) == null) {
                        String fileName = contextFile.getName();
                        path = fileName.substring(0, fileName.length() - ".xml".length());
                        if ("ROOT".equals(path)) {
                            path = "";
                        }
                        context.setPath("/" + path);
                    }
                }
                catch (Exception exception) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return context;
    }

    public static IPath modifyLocationForBundle(IPath currentLocation) {
        Path modifiedLocation = null;
        if (currentLocation == null || CoreUtil.isNullOrEmpty((String)currentLocation.toOSString())) {
            return null;
        }
        File location = currentLocation.toFile();
        if (location.exists() && location.isDirectory()) {
            File[] files = location.listFiles();
            boolean matches = false;
            String pattern = ".*tomcat.*";
            File tomcatDir = null;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory() && file.getName().matches(pattern)) {
                    matches = true;
                    tomcatDir = file;
                    break;
                }
                ++n2;
            }
            if (matches && tomcatDir != null) {
                modifiedLocation = new Path(tomcatDir.getPath());
            }
        }
        return modifiedLocation;
    }

    public static void saveConfigInfoIntoCache(String configType, String configInfo, IPath portalDir) {
        IPath versionsInfoPath = null;
        if (configType.equals(CONFIG_TYPE_VERSION)) {
            versionsInfoPath = LiferayTomcatPlugin.getDefault().getStateLocation().append("version.properties");
        } else if (configType.equals(CONFIG_TYPE_SERVER)) {
            versionsInfoPath = LiferayTomcatPlugin.getDefault().getStateLocation().append("serverInfos.properties");
        }
        if (versionsInfoPath != null) {
            File versionInfoFile = versionsInfoPath.toFile();
            if (configInfo != null) {
                String portalDirKey = CoreUtil.createStringDigest((String)portalDir.toPortableString());
                Properties properties = new Properties();
                try {
                    FileInputStream fileInput = new FileInputStream(versionInfoFile);
                    properties.load(fileInput);
                    fileInput.close();
                }
                catch (FileNotFoundException fileInput) {
                }
                catch (IOException e) {
                    LiferayTomcatPlugin.logError(e);
                }
                properties.put(portalDirKey, configInfo);
                try {
                    FileOutputStream fileOutput = new FileOutputStream(versionInfoFile);
                    properties.store(fileOutput, "");
                    fileOutput.close();
                }
                catch (Exception e) {
                    LiferayTomcatPlugin.logError(e);
                }
            }
        }
    }

    private static File setupExternalPropertiesFile(File portalIdePropFile, String externalPropertiesPath) {
        File retval = null;
        File externalPropertiesFile = new File(externalPropertiesPath);
        if (externalPropertiesFile.exists()) {
            ExternalPropertiesConfiguration props = new ExternalPropertiesConfiguration();
            try {
                props.load(new FileInputStream(externalPropertiesFile));
                props.setProperty("include-and-override", portalIdePropFile.getAbsolutePath());
                props.setHeader("# Last modified by Liferay IDE " + new Date());
                props.save(new FileOutputStream(externalPropertiesFile));
                retval = externalPropertiesFile;
            }
            catch (Exception e) {
                retval = null;
            }
        } else {
            retval = null;
        }
        return retval;
    }

    public static void syncStopServer(final IServer server) {
        if (server.getServerState() != 2) {
            return;
        }
        final LiferayTomcatServerBehavior serverBehavior = (LiferayTomcatServerBehavior)((Object)server.loadAdapter(LiferayTomcatServerBehavior.class, null));
        Thread shutdownThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                serverBehavior.stop(true);
                IServer iServer = server;
                synchronized (iServer) {
                    try {
                        server.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        };
        IServerListener shutdownListener = new IServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serverChanged(ServerEvent event) {
                if (event.getState() == 4) {
                    IServer iServer = server;
                    synchronized (iServer) {
                        server.notifyAll();
                    }
                }
            }
        };
        server.addServerListener(shutdownListener);
        try {
            shutdownThread.start();
            shutdownThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        server.removeServerListener(shutdownListener);
    }

    public static IStatus validateRuntimeStubLocation(String runtimeTypeId, IPath runtimeStubLocation) {
        try {
            IRuntimeWorkingCopy runtimeStub = ServerCore.findRuntimeType((String)runtimeTypeId).createRuntime(null, null);
            runtimeStub.setLocation(runtimeStubLocation);
            runtimeStub.setStub(true);
            return runtimeStub.validate(null);
        }
        catch (Exception e) {
            return LiferayTomcatPlugin.createErrorStatus(e);
        }
    }
}

